/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.output;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Set;
import pyrosim.PyroMod;
import pyrosim.domain.APyroObject;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityReplacer;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.tasks.AReplaceRefTask;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public class Slice
extends APyroObject
implements IPyroGeomSrc,
IDirectDependent {
    static final long serialVersionUID = 1L;
    private IQuantity d_measurement;
    private boolean d_includeFlowVector;
    private boolean d_visible;
    private boolean d_cellCentered;
    private static final Color s_color = new Color(Color.PINK.getRed(), Color.PINK.getGreen(), Color.pink.getBlue(), 150);

    public Slice(IQuantity iQuantity, boolean bl, boolean bl2) {
        this.d_measurement = iQuantity;
        this.d_includeFlowVector = bl;
        this.d_visible = true;
        this.d_cellCentered = bl2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.d_visible = true;
        objectInputStream.defaultReadObject();
    }

    public IQuantity getQuantity() {
        return this.d_measurement;
    }

    public void setQuantity(IQuantity iQuantity) {
        this.d_measurement = iQuantity;
        this.changedEvt(new Object[0]);
    }

    public boolean includeFlowVector() {
        return this.d_includeFlowVector;
    }

    public void setIncludeFlowVector(boolean bl) {
        if (this.d_includeFlowVector == bl) {
            return;
        }
        this.d_includeFlowVector = bl;
        this.changedEvt(new Object[0]);
    }

    public boolean isCellCentered() {
        return this.d_cellCentered;
    }

    public void setCellCentered(boolean bl) {
        if (this.d_cellCentered == bl) {
            return;
        }
        this.d_cellCentered = bl;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean isEquiv(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Slice) {
            Slice slice = (Slice)object;
            return slice.d_includeFlowVector == this.d_includeFlowVector && slice.d_cellCentered == this.d_cellCentered && slice.d_measurement.equals(this.d_measurement);
        }
        return false;
    }

    public int hashCode() {
        int n = 7;
        n = 31 * n + this.d_measurement.hashCode();
        n = 31 * n + (this.d_cellCentered ? 1 : 0);
        n = 31 * n + (this.d_includeFlowVector ? 1 : 0);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Slice) {
            Slice slice = (Slice)object;
            return slice.d_includeFlowVector == this.d_includeFlowVector && slice.d_cellCentered == this.d_cellCentered && slice.d_measurement.equals(this.d_measurement);
        }
        return false;
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.d_visible == bl) {
            return;
        }
        this.d_visible = bl;
        this.changedEvt(PyroMod.EVT_VISIBILITY_CHANGED);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getSliceGeom());
    }

    public IGeom getSliceGeom() {
        return EmptyGeom.INSTANCE;
    }

    @Override
    public void setGeom(IGeomNode iGeomNode) {
        this.setGeom(iGeomNode.flatten().getLocalGeom());
    }

    public void setGeom(IGeom iGeom) {
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        return new DisplayGeom(this.getGeom(), (IPrimProps)new IPrimProps.Face(s_color, null, 0));
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        QuantityUtil.takeDepSnapshot(depList, DLink.STRONG, this.getQuantity());
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        QuantReplacer quantReplacer = new QuantReplacer();
        quantReplacer.removeInvalidReplacements(t, set, this.getQuantity());
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        QuantReplacer quantReplacer = new QuantReplacer();
        return quantReplacer.taskReplaceDep(iPyroObject, iPyroObject2, this.getQuantity());
    }

    @Override
    public Task taskUpdateDep(IPyroObject iPyroObject, Collection<Object> collection) {
        return EmptyTask.INSTANCE;
    }

    private class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)Slice.this.getDomain());
        }

        @Override
        protected Task taskReplaceQuant(IQuantity iQuantity, IQuantity iQuantity2) {
            assert (iQuantity2 != null);
            return new AReplaceRefTask<IQuantity>((Object)iQuantity, (Object)iQuantity2){

                @Override
                protected void set(IQuantity iQuantity) {
                    Slice.this.setQuantity(iQuantity);
                }
            };
        }
    }
}

