/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.output;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityReplacer;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.tasks.AReplaceRefTask;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public class ProfRec
extends NamedPyroObject
implements Serializable,
Cloneable,
IDirectDependent {
    static final long serialVersionUID = 1L;
    public static final int IOR_X = 1;
    public static final int IOR_X_NEG = -1;
    public static final int IOR_Y = 2;
    public static final int IOR_Y_NEG = -2;
    public static final int IOR_Z = 3;
    public static final int IOR_Z_NEG = -3;
    private int d_ior;
    private IQuantity d_q;
    private UnitPoint3D d_pt;

    public ProfRec(String string, int n, IQuantity iQuantity, UnitPoint3D unitPoint3D) {
        super(string);
        this.d_ior = n;
        this.d_q = iQuantity;
        this.d_pt = unitPoint3D;
    }

    public ProfRec(ProfRec profRec) {
        super(profRec.getName());
        this.d_ior = profRec.d_ior;
        this.d_q = profRec.d_q;
        this.d_pt = profRec.d_pt;
    }

    @Override
    public Object clone() {
        return new ProfRec(this);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ProfRec)) {
            return false;
        }
        ProfRec profRec = (ProfRec)object;
        return super.equals(object) && this.d_ior == profRec.d_ior && this.d_q.equals(profRec.d_q) && this.d_pt.equals(profRec.d_pt);
    }

    public int getIOR() {
        return this.d_ior;
    }

    public IQuantity getQuantity() {
        return this.d_q;
    }

    public UnitPoint3D getPoint() {
        return this.d_pt;
    }

    public void setIOR(int n) {
        if (this.d_ior == n) {
            return;
        }
        this.d_ior = n;
        this.changedEvt(new Object[0]);
    }

    public void setQuantity(IQuantity iQuantity) {
        if (this.d_q.equals(iQuantity)) {
            return;
        }
        this.d_q = iQuantity;
        this.changedEvt(new Object[0]);
    }

    public void setPoint(UnitPoint3D unitPoint3D) {
        Unit unit = this.d_pt.getUnit();
        if (this.d_pt.getValue(unit).equals(unitPoint3D.getValue(unit))) {
            return;
        }
        this.d_pt = unitPoint3D;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        QuantityUtil.takeDepSnapshot(depList, DLink.STRONG, this.getQuantity());
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        QuantReplacer quantReplacer = new QuantReplacer();
        quantReplacer.removeInvalidReplacements(t, set, this.getQuantity());
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        QuantReplacer quantReplacer = new QuantReplacer();
        return quantReplacer.taskReplaceDep(iPyroObject, iPyroObject2, this.getQuantity());
    }

    @Override
    public Task taskUpdateDep(IPyroObject iPyroObject, Collection<Object> collection) {
        return EmptyTask.INSTANCE;
    }

    private class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)ProfRec.this.getDomain());
        }

        @Override
        protected Task taskReplaceQuant(IQuantity iQuantity, IQuantity iQuantity2) {
            assert (iQuantity2 != null);
            return new AReplaceRefTask<IQuantity>((Object)iQuantity, (Object)iQuantity2){

                @Override
                protected void set(IQuantity iQuantity) {
                    ProfRec.this.setQuantity(iQuantity);
                }
            };
        }
    }
}

