/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Grid;
import pyrosim.domain.output.Slice;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.APlaneHandle;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.PlanarSurface;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.Pair;

public class PlanarSlice
extends Slice {
    static final long serialVersionUID = 1L;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    private int d_plane;
    private UnitDouble d_location;

    public PlanarSlice(int n, UnitDouble unitDouble, IQuantity iQuantity, boolean bl, boolean bl2) {
        super(iQuantity, bl, bl2);
        this.d_plane = n;
        this.d_location = unitDouble;
    }

    public PlanarSlice(SliceGeom sliceGeom, IQuantity iQuantity, boolean bl, boolean bl2) {
        this(sliceGeom.plane, new UnitDouble(sliceGeom.loc, Geometry.LU), iQuantity, bl, bl2);
    }

    public PlanarSlice(PlanarSurface planarSurface, IQuantity iQuantity, boolean bl, boolean bl2) {
        super(iQuantity, bl, bl2);
        Pair<Integer, UnitDouble> pair = PlanarSlice.convert(planarSurface.plane);
        this.d_plane = (Integer)pair.v1;
        this.d_location = (UnitDouble)pair.v2;
    }

    public int getPlane() {
        return this.d_plane;
    }

    public UnitDouble getLocation() {
        return this.d_location;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof PlanarSlice) {
            PlanarSlice planarSlice = (PlanarSlice)object;
            return super.equals(planarSlice) && this.d_plane == planarSlice.d_plane && this.d_location.equals(planarSlice.d_location);
        }
        return false;
    }

    @Override
    public AABox getBounds() {
        return new AABox(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    private static Pair<Integer, UnitDouble> convert(Plane3d plane3d) {
        int n;
        Vector3d vector3d;
        Vector3d vector3d2 = plane3d.getNormal();
        int n2 = Util3D.getClosestAxis(vector3d2);
        switch (n2) {
            case 0: {
                vector3d = GeomConstants.VEC3D_XPOS;
                n = 0;
                break;
            }
            case 1: {
                vector3d = GeomConstants.VEC3D_YPOS;
                n = 1;
                break;
            }
            default: {
                vector3d = GeomConstants.VEC3D_ZPOS;
                n = 2;
            }
        }
        double d = vector3d.dot(vector3d2) < 0.0 ? plane3d.w : -plane3d.w;
        return new Pair<Integer, UnitDouble>(n, new UnitDouble(d, Geometry.LU));
    }

    private static Plane3d convert(int n, double d) {
        switch (n) {
            case 0: {
                return new Plane3d(1.0, 0.0, 0.0, -d);
            }
            case 1: {
                return new Plane3d(0.0, 1.0, 0.0, -d);
            }
        }
        return new Plane3d(0.0, 0.0, 1.0, -d);
    }

    @Override
    public IGeom getSliceGeom() {
        PyroMod pyroMod = (PyroMod)this.getDomain();
        if (pyroMod == null) {
            pyroMod = PyroSim.getApp().getMediator();
        }
        List list = pyroMod != null ? pyroMod.getGridManager().flatten() : Collections.EMPTY_LIST;
        return new SliceGeom(this.d_plane, this.d_location.getValue(Geometry.LU), list);
    }

    @Override
    public void setGeom(IGeom iGeom) {
        if (iGeom instanceof SliceGeom) {
            SliceGeom sliceGeom = (SliceGeom)iGeom;
            this.d_plane = sliceGeom.plane;
            this.d_location = new UnitDouble(sliceGeom.loc, Geometry.LU);
            this.changedEvt(new Object[0]);
        } else if (iGeom instanceof PlanarSurface) {
            PlanarSurface planarSurface = (PlanarSurface)iGeom;
            Pair<Integer, UnitDouble> pair = PlanarSlice.convert(planarSurface.plane);
            this.d_plane = (Integer)pair.v1;
            this.d_location = (UnitDouble)pair.v2;
            this.changedEvt(new Object[0]);
        }
    }

    public String toString() {
        String string = "";
        switch (this.getPlane()) {
            case 0: {
                string = Intl.intl("X");
                break;
            }
            case 1: {
                string = Intl.intl("Y");
                break;
            }
            case 2: {
                string = Intl.intl("Z");
            }
        }
        string = string + " = " + Global.format(this.getLocation());
        string = string + ": " + this.getQuantity().getDescription();
        return string;
    }

    public static class PlanarSliceHash {
        private final Integer d_plane;
        private final UnitDouble d_loc;
        private final IQuantity d_measurement;

        public PlanarSliceHash(int n, UnitDouble unitDouble, IQuantity iQuantity) {
            this.d_plane = n;
            this.d_loc = unitDouble;
            this.d_measurement = iQuantity;
        }

        public int hashCode() {
            return this.d_plane.hashCode() + this.d_loc.hashCode() + this.d_measurement.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof PlanarSliceHash)) {
                return false;
            }
            PlanarSliceHash planarSliceHash = (PlanarSliceHash)object;
            return planarSliceHash.d_plane.equals(this.d_plane) && planarSliceHash.d_loc.equals(this.d_loc) && planarSliceHash.d_measurement.equals(this.d_measurement);
        }
    }

    public static class SliceGeom
    extends GeomGroup {
        private static final long serialVersionUID = -4738852155242983374L;
        public final Collection<? extends Grid> grids;
        public final int plane;
        public final double loc;

        public SliceGeom(int n, double d, Collection<? extends Grid> collection) {
            this(SliceGeom.getQuads(n, d, collection), n, d, collection);
        }

        private SliceGeom(List<? extends IGeom> list, int n, double d, Collection<? extends Grid> collection) {
            super(list);
            this.plane = n;
            this.loc = d;
            this.grids = collection;
        }

        private static List<AARectangle> getQuads(int n, double d, Collection<? extends Grid> collection) {
            ArrayList<AARectangle> arrayList = new ArrayList<AARectangle>();
            for (Grid grid : collection) {
                AABox aABox = grid.getGeom().getBoundingBox(new AABox());
                switch (n) {
                    case 0: {
                        if (!(aABox.getMinX() <= d) || !(d <= aABox.getMaxX())) break;
                        arrayList.add(new AARectangle(0, d, aABox.getMinY(), aABox.getMinZ(), aABox.getMaxY(), aABox.getMaxZ(), false));
                        break;
                    }
                    case 1: {
                        if (!(aABox.getMinY() <= d) || !(d <= aABox.getMaxY())) break;
                        arrayList.add(new AARectangle(1, d, aABox.getMinX(), aABox.getMinZ(), aABox.getMaxX(), aABox.getMaxZ(), false));
                        break;
                    }
                    case 2: {
                        if (!(aABox.getMinZ() <= d) || !(d <= aABox.getMaxZ())) break;
                        arrayList.add(new AARectangle(2, d, aABox.getMinX(), aABox.getMinY(), aABox.getMaxX(), aABox.getMaxY(), false));
                    }
                }
            }
            return arrayList;
        }

        @Override
        public GeomGroup optimize(IPointOptimizer iPointOptimizer) {
            GeomGroup geomGroup = super.optimize(iPointOptimizer);
            return geomGroup == this ? this : new SliceGeom(geomGroup.children, this.plane, this.loc, this.grids);
        }

        @Override
        public IDOF getDOF() {
            return IDOF.ALIGNED;
        }

        @Override
        public IGeom transform(TransformInfo transformInfo, int n) {
            Plane3d plane3d;
            if (transformInfo.isIdentity()) {
                return this;
            }
            Matrix4d matrix4d = transformInfo.getMatrix();
            switch (this.plane) {
                case 0: {
                    plane3d = new Plane3d(1.0, 0.0, 0.0, -this.loc);
                    break;
                }
                case 1: {
                    plane3d = new Plane3d(0.0, 1.0, 0.0, -this.loc);
                    break;
                }
                case 2: {
                    plane3d = new Plane3d(0.0, 0.0, 1.0, -this.loc);
                    break;
                }
                default: {
                    assert (false);
                    plane3d = null;
                }
            }
            plane3d = plane3d.transformBy(matrix4d);
            Point3d point3d = new Point3d(-plane3d.x * plane3d.w, -plane3d.y * plane3d.w, -plane3d.z * plane3d.w);
            Vector3d vector3d = plane3d.getNormal();
            int n2 = Util.getClosestAxis(vector3d);
            switch (n2) {
                case 0: {
                    return new SliceGeom(0, point3d.x, this.grids);
                }
                case 1: {
                    return new SliceGeom(1, point3d.y, this.grids);
                }
                case 2: {
                    return new SliceGeom(2, point3d.z, this.grids);
                }
            }
            return this;
        }

        @Override
        public Collection<? extends IHandle> generateManipHandles() {
            return Arrays.asList(new Handle(this));
        }

        private static class Handle
        extends APlaneHandle<SliceGeom> {
            public Handle(SliceGeom sliceGeom) {
                super(sliceGeom);
            }

            @Override
            public boolean equals(Object object) {
                return super.equals(object) && object instanceof Handle;
            }

            @Override
            public IGeomNode getGeom() {
                return GeomNodeUtil.newNode((IGeom)this.getManipGeom());
            }

            @Override
            protected Vector3d getPlaneNormal(SliceGeom sliceGeom) {
                switch (sliceGeom.plane) {
                    case 0: {
                        return GeomConstants.VEC3D_XPOS;
                    }
                    case 1: {
                        return GeomConstants.VEC3D_YPOS;
                    }
                    case 2: {
                        return GeomConstants.VEC3D_ZPOS;
                    }
                }
                return null;
            }

            @Override
            protected SliceGeom modify(SliceGeom sliceGeom, double d) {
                return new SliceGeom(sliceGeom.plane, sliceGeom.loc + d, sliceGeom.grids);
            }
        }
    }
}

