/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.output;

import java.util.ArrayList;
import pyrosim.domain.output.AMeasurementSet;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class Boundaries
extends AMeasurementSet {
    static final long serialVersionUID = 1L;
    private UnitDouble d_pressCoeffCharVel = this.getQuantities().contains(Quantity.PRESSURE_COEFFICIENT.create()) ? SIUS.newud(1.0, 8) : null;
    private UnitDouble d_gaugeTemperature = null;
    private double d_gaugeEmissivity = 0.9;

    public Boundaries(IQuantity ... iQuantityArray) {
        super(iQuantityArray);
    }

    @Override
    public int getOutputType() {
        return 16;
    }

    public UnitDouble getPressCoeffCharVel() {
        return this.d_pressCoeffCharVel;
    }

    public void setPressCoeffCharVel(UnitDouble unitDouble) {
        this.d_pressCoeffCharVel = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getGaugeTemperature() {
        return this.d_gaugeTemperature;
    }

    public void setGaugeTemperature(UnitDouble unitDouble) {
        this.d_gaugeTemperature = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public double getGaugeEmissivity() {
        return this.d_gaugeEmissivity;
    }

    public void setGaugeEmissivty(double d) {
        this.d_gaugeEmissivity = d;
        this.changedEvt(new Object[0]);
    }

    public static Boundaries mergeBoundaries(Boundaries boundaries, Boundaries boundaries2) {
        Boundaries boundaries3 = new Boundaries(new IQuantity[0]);
        if (!Boundaries.consumeBounds(boundaries3, boundaries)) {
            return null;
        }
        if (!Boundaries.consumeBounds(boundaries3, boundaries2)) {
            return null;
        }
        return boundaries3;
    }

    private static boolean consumeBounds(Boundaries boundaries, Boundaries boundaries2) {
        ArrayList<IQuantity> arrayList = new ArrayList<IQuantity>(boundaries.getQuantities());
        for (IQuantity iQuantity : boundaries2.getQuantities()) {
            if (iQuantity.get().equals((Object)Quantity.PRESSURE_COEFFICIENT)) {
                if (arrayList.contains(iQuantity)) {
                    if (theUtil.equal(boundaries.getPressCoeffCharVel(), boundaries2.getPressCoeffCharVel())) continue;
                    return false;
                }
                arrayList.add(iQuantity);
                boundaries.setPressCoeffCharVel(boundaries2.getPressCoeffCharVel());
                continue;
            }
            if (iQuantity.get().equals((Object)Quantity.GAUGE_HEAT_FLUX)) {
                if (arrayList.contains(iQuantity)) {
                    if (!theUtil.equal(boundaries.getGaugeTemperature(), boundaries2.getGaugeTemperature())) {
                        return false;
                    }
                    if (theUtil.eq(boundaries.getGaugeEmissivity(), boundaries2.getGaugeEmissivity(), 1.0E-6)) continue;
                    continue;
                }
                arrayList.add(iQuantity);
                boundaries.setGaugeTemperature(boundaries2.getGaugeTemperature());
                boundaries.setGaugeEmissivty(boundaries2.getGaugeEmissivity());
                continue;
            }
            if (arrayList.contains(iQuantity)) continue;
            arrayList.add(iQuantity);
        }
        boundaries.setQuantities(arrayList);
        return true;
    }
}

