/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.output;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.StatGeom;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityReplacer;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.util.Util;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.BlockGeom;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public abstract class AMsrStat
extends NamedPyroObject
implements IMeasurementStat,
IDirectDependent {
    static final long serialVersionUID = 1L;
    private IQuantity d_msr;
    private Set<Integer> d_stats;
    private IGeom d_geom;
    private boolean d_visible;
    private CustomFDSProps d_customProps;
    private static final Color s_boxColor = new Color(0.2f, 0.2f, 1.0f, 0.3f);
    private static final Color s_pointColor = new Color(0.2f, 0.2f, 1.0f, 1.0f);

    public abstract Predicate<Quantity> getQuantityFilter();

    public AMsrStat(String string, IQuantity iQuantity, Collection<Integer> collection, IGeom iGeom) {
        super(string);
        this.d_msr = iQuantity;
        this.d_stats = new HashSet<Integer>(collection);
        assert (AMsrStat.isValidGeom(iGeom));
        this.d_geom = iGeom;
        this.d_visible = true;
        this.d_customProps = CustomFDSProps.EMPTY;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_customProps == null) {
            this.d_customProps = CustomFDSProps.EMPTY;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AMsrStat)) {
            return false;
        }
        AMsrStat aMsrStat = (AMsrStat)object;
        return this.d_msr.equals(aMsrStat.d_msr) && this.d_stats.equals(aMsrStat.d_stats) && this.d_geom.equals(aMsrStat.d_geom) && this.d_customProps.equals(aMsrStat.d_customProps);
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String string) {
        return this.d_customProps;
    }

    @Override
    public void setCustomFDSProps(String string, CustomFDSProps customFDSProps) {
        if (this.d_customProps == customFDSProps) {
            return;
        }
        this.d_customProps = customFDSProps;
        this.changedEvt(new Object[0]);
    }

    @Override
    public Object clone() {
        AMsrStat aMsrStat = (AMsrStat)super.clone();
        aMsrStat.d_stats = new HashSet<Integer>(this.d_stats);
        return aMsrStat;
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.d_visible == bl) {
            return;
        }
        this.d_visible = bl;
        this.changedEvt(PyroMod.EVT_VISIBILITY_CHANGED);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public IQuantity getQuantity() {
        return this.d_msr;
    }

    @Override
    public void setStats(Collection<Integer> collection) {
        this.d_stats.clear();
        this.d_stats.addAll(collection);
        this.changedEvt(new Object[0]);
    }

    @Override
    public Set<Integer> getStats() {
        return Collections.unmodifiableSet(this.d_stats);
    }

    public static boolean isValidGeom(IGeom iGeom) {
        return iGeom instanceof Point || iGeom instanceof AABoxGeom || iGeom instanceof AARectangle || iGeom instanceof StatGeom.GridGeom || iGeom instanceof StatGeom.LinearArrayGeom;
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getMsrGeom());
    }

    @Override
    public IGeom getMsrGeom() {
        if (this.d_geom instanceof BlockGeom) {
            return this.d_geom;
        }
        if (this.d_geom instanceof AABoxGeom) {
            AABoxGeom aABoxGeom = (AABoxGeom)this.d_geom;
            return new BlockGeom(aABoxGeom.min, aABoxGeom.max, aABoxGeom.swizzle);
        }
        if (this.d_geom instanceof RestrictedRect) {
            return this.d_geom;
        }
        if (this.d_geom instanceof AARectangle) {
            return new RestrictedRect((AARectangle)this.d_geom);
        }
        return this.d_geom;
    }

    @Override
    public void setGeom(IGeomNode iGeomNode) {
        this.setGeom(iGeomNode.flatten().getLocalGeom());
    }

    public void setGeom(IGeom iGeom) {
        if (AMsrStat.isValidGeom(iGeom)) {
            this.d_geom = iGeom;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        IPrimProps.AProps aProps;
        Color color = this.d_geom instanceof Point ? s_pointColor : s_boxColor;
        IPrimProps.AProps aProps2 = aProps = this.d_geom instanceof Point || this.d_geom instanceof LineSeg ? new IPrimProps.Vertex(color, 10.0) : new IPrimProps.Face(color, null, 2);
        if (this.d_geom instanceof StatGeom.LinearArrayGeom) {
            return GeomUtil.generateLinearArrayDisplayGeom((StatGeom.LinearArrayGeom)this.d_geom, aProps);
        }
        return new DisplayGeom(this.getGeom(), (IPrimProps)aProps);
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        QuantityUtil.takeDepSnapshot(depList, DLink.STRONG, this.d_msr);
        if (this.d_geom instanceof StatGeom.GridGeom) {
            depList.add(DLink.STRONG, (IPyroObject)((StatGeom.GridGeom)this.d_geom).grid);
        }
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (QuantityUtil.isQuantityRef(t, this.d_msr)) {
            Util.keepOnlyNull(set);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (QuantityUtil.isQuantityRef(iPyroObject, this.d_msr)) {
            assert (iPyroObject.equals(iPyroObject2));
            QuantReplacer quantReplacer = new QuantReplacer();
            return quantReplacer.taskReplaceDep(iPyroObject, iPyroObject2, this.d_msr);
        }
        if (iPyroObject instanceof Grid) {
            assert (iPyroObject2 != null);
            return new AReplaceRefTask<Grid>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                protected void set(Grid grid) {
                    AMsrStat.this.setGeom(GeomNodeUtil.newNode(new StatGeom.GridGeom(grid)));
                }
            };
        }
        return EmptyTask.INSTANCE;
    }

    @Override
    public Task taskUpdateDep(IPyroObject iPyroObject, Collection<Object> collection) {
        if (iPyroObject instanceof Grid) {
            return GeomUtil.taskChanged(this);
        }
        return EmptyTask.INSTANCE;
    }

    static {
        TVEntryPoint.registerReferencedUpdateTypes(Grid.class);
    }

    protected class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)AMsrStat.this.getDomain());
        }

        @Override
        protected boolean canReplaceQuant(IQuantity iQuantity, IQuantity iQuantity2) {
            return iQuantity.equals(iQuantity2);
        }

        @Override
        protected Task taskReplaceQuant(IQuantity iQuantity, IQuantity iQuantity2) {
            assert (iQuantity2 != null);
            return new AReplaceRefTask<IQuantity>((Object)AMsrStat.this.d_msr, (Object)iQuantity2){

                @Override
                protected void set(IQuantity iQuantity) {
                    AMsrStat.this.d_msr = iQuantity;
                    AMsrStat.this.changedEvt(new Object[0]);
                }
            };
        }
    }

    public static class RestrictedRect
    extends AARectangle {
        static final long serialVersionUID = 1L;

        public RestrictedRect(AARectangle aARectangle) {
            super(aARectangle.d_plane, aARectangle.d_planeVal, aARectangle.d_minx, aARectangle.d_miny, aARectangle.d_maxx, aARectangle.d_maxy, aARectangle.flipped);
        }

        @Override
        public IDOF getDOF() {
            return IDOF.ALIGNED;
        }
    }
}

