/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.hvac;

import java.util.Collection;
import java.util.function.Predicate;
import pyrosim.domain.bridge.BridgeList;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacDuctLoss;
import pyrosim.domain.hvac.HvacNode;

public class HvacUtil {
    public static Predicate<HvacDuctLoss> getDuctLossFilter(HvacNode hvacNode) {
        return new NodeFilter(hvacNode);
    }

    public static Predicate<HvacDuctLoss> getDuctLossFilter(HvacDuct hvacDuct) {
        return new DuctFilter(hvacDuct);
    }

    public static Predicate<HvacDuctLoss> getDuctLossFilter(HvacDuct hvacDuct, HvacDuct hvacDuct2) {
        return new DuctFilter2(hvacDuct, hvacDuct2);
    }

    public static Predicate<HvacDuctLoss> getDuctLossFilter(HvacNode hvacNode, HvacDuct hvacDuct, HvacDuct hvacDuct2) {
        NodeFilter nodeFilter = new NodeFilter(hvacNode);
        return nodeFilter.and(new DuctFilter2(hvacDuct, hvacDuct2));
    }

    public static Predicate<HvacDuctLoss> getDuctLossFilter(HvacNode hvacNode, HvacDuct hvacDuct) {
        NodeFilter nodeFilter = new NodeFilter(hvacNode);
        return nodeFilter.and(new DuctFilter(hvacDuct));
    }

    public static Collection<HvacDuctLoss> getDuctLosses(BridgeList bridgeList, HvacNode hvacNode) {
        return bridgeList.flatten(HvacDuctLoss.class, HvacUtil.getDuctLossFilter(hvacNode));
    }

    public static Collection<HvacDuctLoss> getDuctLosses(BridgeList bridgeList, HvacDuct hvacDuct) {
        return bridgeList.flatten(HvacDuctLoss.class, HvacUtil.getDuctLossFilter(hvacDuct));
    }

    public static Collection<HvacDuctLoss> getDuctLosses(BridgeList bridgeList, HvacDuct hvacDuct, HvacDuct hvacDuct2) {
        return bridgeList.flatten(HvacDuctLoss.class, HvacUtil.getDuctLossFilter(hvacDuct, hvacDuct2));
    }

    public static HvacDuctLoss getDuctLoss(BridgeList bridgeList, HvacNode hvacNode, HvacDuct hvacDuct, HvacDuct hvacDuct2) {
        Collection<HvacDuctLoss> collection = bridgeList.flatten(HvacDuctLoss.class, HvacUtil.getDuctLossFilter(hvacNode, hvacDuct, hvacDuct2));
        return collection.isEmpty() ? null : collection.iterator().next();
    }

    public static Collection<HvacDuctLoss> getDuctLosses(BridgeList bridgeList, HvacNode hvacNode, HvacDuct hvacDuct) {
        return bridgeList.flatten(HvacDuctLoss.class, HvacUtil.getDuctLossFilter(hvacNode, hvacDuct));
    }

    public static Predicate<HvacDuct> getConnectedDuctsFilter(HvacNode hvacNode) {
        return new ConnectedNodeFilter(hvacNode);
    }

    public static Collection<HvacDuct> getConnectedDucts(ModelComposite modelComposite, HvacNode hvacNode) {
        return modelComposite.flatten(HvacDuct.class, HvacUtil.getConnectedDuctsFilter(hvacNode));
    }

    public static class DuctFilter2
    implements Predicate<HvacDuctLoss> {
        public final HvacDuct duct1;
        public final HvacDuct duct2;

        public DuctFilter2(HvacDuct hvacDuct, HvacDuct hvacDuct2) {
            this.duct1 = hvacDuct;
            this.duct2 = hvacDuct2;
        }

        @Override
        public boolean test(HvacDuctLoss hvacDuctLoss) {
            return this.accept(hvacDuctLoss);
        }

        public boolean accept(HvacDuctLoss hvacDuctLoss) {
            return hvacDuctLoss.duct1 == this.duct1 && hvacDuctLoss.duct2 == this.duct2 || hvacDuctLoss.duct1 == this.duct2 && hvacDuctLoss.duct2 == this.duct1;
        }
    }

    public static class DuctFilter
    implements Predicate<HvacDuctLoss> {
        public final HvacDuct duct;

        public DuctFilter(HvacDuct hvacDuct) {
            this.duct = hvacDuct;
        }

        @Override
        public boolean test(HvacDuctLoss hvacDuctLoss) {
            return hvacDuctLoss.duct1 == this.duct || hvacDuctLoss.duct2 == this.duct;
        }
    }

    public static class NodeFilter
    implements Predicate<HvacDuctLoss> {
        public final HvacNode node;

        public NodeFilter(HvacNode hvacNode) {
            this.node = hvacNode;
        }

        @Override
        public boolean test(HvacDuctLoss hvacDuctLoss) {
            return hvacDuctLoss.node == this.node;
        }
    }

    public static class ConnectedNodeFilter
    implements Predicate<HvacDuct> {
        public final HvacNode node;

        public ConnectedNodeFilter(HvacNode hvacNode) {
            this.node = hvacNode;
        }

        @Override
        public boolean test(HvacDuct hvacDuct) {
            return hvacDuct.getNodes().contains(this.node);
        }
    }
}

