/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.hvac;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.IImplicitGeomSrc;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.AHvacGeomComponent;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacFilter;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.geom.Geometry;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.util.Util;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Task;

public class HvacNode
extends AHvacGeomComponent
implements IImplicitGeomSrc {
    private static final long serialVersionUID = 1414663300556603303L;
    public static final String OPT_NODETYPE = "OPT_NODETYPE";
    private static final IPrimProps s_primProps;

    public HvacNode(String string) {
        super(string);
        HvacNode.setDefaults(this);
    }

    @Override
    public HvacNode clone() {
        return (HvacNode)super.clone();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.getProp("XYZ") == null) {
            this.setProp("XYZ", new UnitPoint3D(0.0, 0.0, 0.0, SI.METER));
        }
    }

    public static void setDefaults(HvacNode hvacNode) {
        hvacNode.setProp("TYPE_ID", "NODE");
        hvacNode.setProp(OPT_NODETYPE, (Object)NodeType.AUTO);
        hvacNode.setProp("FILTER_ID", null);
        hvacNode.setProp("LOSS", Arrays.asList(new UnitDouble(0.0, Unit.ONE), new UnitDouble(0.0, Unit.ONE)));
        hvacNode.setProp("VENT_ID", null);
        hvacNode.setProp("XYZ", new UnitPoint3D(0.0, 0.0, 0.0, SI.METER));
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        this.addDep(depList, "VENT_ID");
        this.addDep(depList, "FILTER_ID");
    }

    @Override
    public Object getProp(String string) {
        assert (!string.equals("DUCT_ID"));
        return super.getProp(string);
    }

    @Override
    public void setProp(String string, Object object) {
        assert (!string.equals("DUCT_ID"));
        super.setProp(string, object);
    }

    public void setVent(Vent vent) {
        assert (vent != null);
        this.pauseUpdates();
        this.setProp("VENT_ID", vent);
        this.setProp(OPT_NODETYPE, (Object)NodeType.VENT);
        this.resumeUpdates();
    }

    public Vent getVent() {
        return (Vent)this.getProp("VENT_ID");
    }

    @Override
    public Collection<IPyroGeomSrc> getDefiningObjs(Collection<IPyroGeomSrc> collection) {
        if (this.getNodeType() == NodeType.VENT && this.getVent() != null) {
            collection.add(this.getVent());
        }
        return collection;
    }

    public List<UnitDouble> getTerminalLoss() {
        return (List)this.getProp("LOSS");
    }

    public void setTerminalLoss(UnitDouble unitDouble, UnitDouble unitDouble2) {
        List<UnitDouble> list = Arrays.asList(unitDouble, unitDouble2);
        this.setProp("LOSS", list);
    }

    public void setNodeType(NodeType nodeType) {
        assert (nodeType != NodeType.VENT);
        this.pauseUpdates();
        this.setProp(OPT_NODETYPE, (Object)nodeType);
        this.setProp("VENT_ID", null);
        this.resumeUpdates();
    }

    public NodeType getNodeType() {
        return (NodeType)((Object)this.getProp(OPT_NODETYPE));
    }

    public NodeType getFinalNodeType(int n) {
        NodeType nodeType = this.getNodeType();
        if (nodeType != NodeType.AUTO) {
            return nodeType;
        }
        if (n == 1) {
            return NodeType.AMBIENT;
        }
        return NodeType.INTERNAL;
    }

    public void setFilter(HvacFilter hvacFilter) {
        this.setProp("FILTER_ID", hvacFilter);
    }

    public HvacFilter getFilter() {
        return (HvacFilter)this.getProp("FILTER_ID");
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t instanceof Vent) {
            Util.keepIfNullOr(set, Vent.class);
        } else if (t instanceof HvacFilter) {
            Util.keepIfNullOr(set, HvacFilter.class);
        } else if (t instanceof HvacDuct) {
            Util.keepIfNullOr(set, HvacDuct.class);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (iPyroObject instanceof Vent) {
            return new AReplaceRefTask<Vent>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                protected void set(Vent vent) {
                    if (vent != null) {
                        HvacNode.this.setVent(vent);
                    } else {
                        HvacNode.this.setNodeType(NodeType.AMBIENT);
                    }
                }
            };
        }
        if (iPyroObject instanceof HvacFilter) {
            return new AReplaceRefTask<HvacFilter>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                protected void set(HvacFilter hvacFilter) {
                    HvacNode.this.setFilter(hvacFilter);
                }
            };
        }
        return super.taskReplaceDep(iPyroObject, iPyroObject2);
    }

    @Override
    public Task taskUpdateDep(IPyroObject iPyroObject, Collection<Object> collection) {
        if (!(iPyroObject instanceof Vent)) {
            return super.taskUpdateDep(iPyroObject, collection);
        }
        return GeomUtil.taskChanged(this);
    }

    public Point3d getLocation() {
        if (this.getNodeType() == NodeType.VENT) {
            Vent vent = this.getVent();
            return vent.getBounds().getCenter();
        }
        return ((UnitPoint3D)this.getProp("XYZ")).getPoint3dValue(Geometry.LU);
    }

    public void setLocation(Point3d point3d) {
        this.setLocation(new UnitPoint3D(point3d, Geometry.LU));
    }

    public void setLocation(UnitPoint3D unitPoint3D) {
        this.setProp("XYZ", unitPoint3D);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        IGeomNode iGeomNode = this.getGeom();
        return new DisplayGeom(iGeomNode, s_primProps);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getNodeGeom());
    }

    public IGeom getNodeGeom() {
        return new Point(this.getLocation());
    }

    @Override
    public void setGeom(IGeomNode iGeomNode) {
        this.setGeom(iGeomNode.flatten().getLocalGeom());
    }

    public void setGeom(IGeom iGeom) {
        if (iGeom instanceof Point && this.getNodeType() != NodeType.VENT) {
            Point point = (Point)iGeom;
            this.setLocation(point.loc);
        }
    }

    public int getOpenDuctCount(int n) {
        switch (this.getNodeType()) {
            case AUTO: 
            case INTERNAL: {
                return this.getFilter() == null ? Integer.MAX_VALUE : 2 - n;
            }
            case AMBIENT: 
            case VENT: {
                return 1 - n;
            }
        }
        return 0;
    }

    static {
        TVEntryPoint.registerReferencedUpdateTypes(Vent.class);
        s_primProps = new IPrimProps.Vertex(new Color(0xFF7F00), 15.0);
    }

    private static class DuctLoss {
        public final HvacDuct duct1;
        public final HvacDuct duct2;
        public final UnitDouble loss;

        public DuctLoss(HvacDuct hvacDuct, HvacDuct hvacDuct2, UnitDouble unitDouble) {
            this.duct1 = hvacDuct;
            this.duct2 = hvacDuct2;
            this.loss = unitDouble;
        }
    }

    public static enum NodeType {
        AUTO(false),
        INTERNAL(false),
        AMBIENT(true),
        VENT(true);

        public final boolean terminal;

        private NodeType(boolean bl) {
            this.terminal = bl;
        }
    }
}

