/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.hvac;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacComponent;
import pyrosim.domain.hvac.IHvacObject;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Task;

public class HvacLeak
extends HvacComponent
implements IHvacObject {
    private static final long serialVersionUID = 1L;

    public HvacLeak(String string) {
        super(string);
        HvacLeak.setDefaults(this);
    }

    public static void setDefaults(HvacLeak hvacLeak) {
        hvacLeak.setProp("TYPE_ID", "LEAK");
        hvacLeak.setProp("VENT_ID", null);
        hvacLeak.setProp("VENT2_ID", null);
        hvacLeak.setProp("AREA", SIUS.newud(0.0, 79));
        hvacLeak.setProp("LEAK_ENTHALPY", false);
        hvacLeak.setProp("LOSS", Arrays.asList(new UnitDouble(0.0, Unit.ONE)));
    }

    public Vent getVent1() {
        return (Vent)this.getProp("VENT_ID");
    }

    public Vent getVent2() {
        return (Vent)this.getProp("VENT2_ID");
    }

    public UnitDouble getLeakArea() {
        return (UnitDouble)this.getProp("AREA");
    }

    public boolean isEnthalpyCalc() {
        return (Boolean)this.getProp("LEAK_ENTHALPY");
    }

    public UnitDouble getLoss() {
        return (UnitDouble)((List)this.getProp("LOSS")).get(0);
    }

    public void setVent1(Vent vent) {
        this.updateProp("VENT_ID", vent);
    }

    public void setVent2(Vent vent) {
        this.updateProp("VENT2_ID", vent);
    }

    public void setLeakArea(UnitDouble unitDouble) {
        this.updateProp("AREA", unitDouble);
    }

    public void setEnthalpy(boolean bl) {
        this.updateProp("LEAK_ENTHALPY", bl);
    }

    public void setLoss(UnitDouble unitDouble) {
        this.updateProp("LOSS", Arrays.asList(unitDouble));
    }

    private void updateProp(String string, Object object) {
        this.pauseUpdates();
        this.setProp(string, object);
        this.resumeUpdates();
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        this.addDep(depList, "VENT_ID");
        this.addDep(depList, "VENT2_ID");
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        Util.keepIfNullOr(set, Vent.class);
    }

    @Override
    public Task taskReplaceDep(final IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (iPyroObject instanceof Vent) {
            return new AReplaceRefTask<Vent>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                protected void set(Vent vent) {
                    if (iPyroObject.equals(HvacLeak.this.getVent1())) {
                        HvacLeak.this.setVent1(vent);
                    } else if (iPyroObject.equals(HvacLeak.this.getVent2())) {
                        HvacLeak.this.setVent2(vent);
                    } else assert (false);
                }
            };
        }
        return super.taskReplaceDep(iPyroObject, iPyroObject2);
    }

    @Override
    public Task taskUpdateDep(IPyroObject iPyroObject, Collection<Object> collection) {
        if (!(iPyroObject instanceof Vent)) {
            return super.taskUpdateDep(iPyroObject, collection);
        }
        return GeomUtil.taskChanged(this);
    }
}

