/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.hvac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.hvac.HvacComponent;
import pyrosim.domain.hvac.IHvacObject;
import pyrosim.domain.variant.DefRampProfile;
import pyrosim.domain.variant.Variant;
import pyrosim.domain.variant.VariantProfile;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class HvacFilter
extends HvacComponent
implements IHvacObject {
    private static final long serialVersionUID = 1L;
    public static final String OPT_LOSS_MODEL = "opt_loss_ramp";
    public static final VariantProfile FUNC_PROF = new VariantProfile(new DefRampProfile(Intl.intl("Custom"), 28, DefRampProfile.Input.MASS));
    private Variant d_func;

    public HvacFilter(String string) {
        super(string);
        HvacFilter.setDefaults(this);
        this.d_func = FUNC_PROF.getDefault();
    }

    public static void setDefaults(HvacFilter hvacFilter) {
        hvacFilter.setProp("TYPE_ID", "FILTER");
        hvacFilter.setProp("CLEAN_LOSS", new UnitDouble(0.0, Unit.ONE));
        hvacFilter.setProp("EFFICIENCY", Collections.EMPTY_LIST);
        hvacFilter.setProp("LOADING", Collections.EMPTY_LIST);
        hvacFilter.setProp("LOADING_MULTIPLIER", Collections.EMPTY_LIST);
        hvacFilter.setProp("SPEC_ID", Collections.EMPTY_LIST);
        hvacFilter.setProp("LOSS", Collections.EMPTY_LIST);
        hvacFilter.setProp(OPT_LOSS_MODEL, (Object)LossModel.LINEAR);
    }

    public Variant getCustomLoss() {
        return this.d_func;
    }

    public void setCustomLoss(Variant variant) {
        if (theUtil.equal(this.d_func, variant)) {
            return;
        }
        this.d_func = variant;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        this.addDep(depList, "SPEC_ID");
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t instanceof ExSpec) {
            Util.keepIfNullOr(set, ExSpec.class);
            List list = (List)this.getProp("SPEC_ID");
            for (ExSpec exSpec : list) {
                if (!set.contains(exSpec)) continue;
                set.remove(exSpec);
            }
        }
    }

    @Override
    public Task taskReplaceDep(final IPyroObject iPyroObject, final IPyroObject iPyroObject2) {
        if (iPyroObject instanceof ExSpec) {
            return new AUndoableTask(){
                private ExSpec d_oldSpec;
                private ExSpec d_replSpec;

                @Override
                public void run() {
                    this.d_oldSpec = (ExSpec)iPyroObject;
                    this.d_replSpec = (ExSpec)iPyroObject2;
                    HvacFilter.this.setExSpec(this.d_oldSpec, this.d_replSpec);
                }

                @Override
                public void undo() {
                    ExSpec exSpec = this.d_oldSpec;
                    this.d_oldSpec = this.d_replSpec;
                    this.d_replSpec = exSpec;
                    HvacFilter.this.setExSpec(this.d_oldSpec, this.d_replSpec);
                }
            };
        }
        return super.taskReplaceDep(iPyroObject, iPyroObject2);
    }

    private void setExSpec(ExSpec exSpec, ExSpec exSpec2) {
        ArrayList<ExSpec> arrayList = new ArrayList<ExSpec>((Collection)this.getProp("SPEC_ID"));
        ArrayList<UnitDouble> arrayList2 = new ArrayList<UnitDouble>((Collection)this.getProp("LOADING"));
        ArrayList<UnitDouble> arrayList3 = new ArrayList<UnitDouble>((Collection)this.getProp("LOADING_MULTIPLIER"));
        int n = arrayList.indexOf(exSpec);
        if (n >= 0) {
            UnitDouble unitDouble = (UnitDouble)arrayList2.get(n);
            UnitDouble unitDouble2 = (UnitDouble)arrayList3.get(n);
            arrayList.remove(n);
            arrayList2.remove(n);
            arrayList3.remove(n);
            if (exSpec2 != null) {
                arrayList.add(exSpec2);
                arrayList2.add(unitDouble);
                arrayList3.add(unitDouble2);
            }
        }
        this.setProp("SPEC_ID", arrayList);
        this.setProp("LOADING", arrayList2);
        this.setProp("LOADING_MULTIPLIER", arrayList3);
        this.changedEvt(new Object[0]);
    }

    @Override
    public Object clone() {
        HvacFilter hvacFilter = (HvacFilter)super.clone();
        hvacFilter.d_func = this.d_func.clone();
        return hvacFilter;
    }

    public static enum LossModel {
        LINEAR,
        CUSTOM;

    }
}

