/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.hvac;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.hvac.HvacComponent;
import pyrosim.domain.hvac.IHvacObject;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.variant.DefRampProfile;
import pyrosim.domain.variant.Variant;
import pyrosim.domain.variant.VariantProfile;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class HvacFan
extends HvacComponent
implements IHvacObject,
ISignalSink {
    private static final long serialVersionUID = 5609437954326712322L;
    public static final String OPT_FAN_MODEL = "opt_fan_model";
    public static final Integer FAN_MODEL_VOLFLOW = 0;
    public static final Integer FAN_MODEL_PRESDROP = 1;
    public static final Integer FAN_MODEL_QUADRATIC = 2;
    public static final VariantProfile PRESSUREFLOW_PROFILE = new VariantProfile(new DefRampProfile(Intl.intl("Custom"), 39, DefRampProfile.Input.FLOW));
    private TimeFunction d_tauFunc;
    private Variant d_pressureFlowRamp;
    @Deprecated
    private IInPin d_inPin;

    public HvacFan(String string) {
        super(string);
        HvacFan.setDefaults(this);
        this.d_tauFunc = TimeFunction.newDefault();
        this.d_pressureFlowRamp = PRESSUREFLOW_PROFILE.getDefault();
        this.d_inPin = new OneLogicInPin(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_inPin == null) {
            this.d_inPin = new OneLogicInPin(this);
        }
    }

    @Override
    public boolean equals(Object object) {
        return object == this || object instanceof HvacFan && super.equals(object) && theUtil.equal(((HvacFan)object).d_tauFunc, this.d_tauFunc) && this.d_inPin.equals(((HvacFan)object).d_inPin);
    }

    @Override
    public Object clone() {
        HvacFan hvacFan = (HvacFan)super.clone();
        hvacFan.d_pressureFlowRamp = this.d_pressureFlowRamp.clone();
        hvacFan.d_tauFunc = (TimeFunction)this.d_tauFunc.clone();
        hvacFan.d_inPin = (IInPin)this.d_inPin.clone(hvacFan);
        return hvacFan;
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        this.addDep(depList, "RAMP_ID");
    }

    public static void setDefaults(HvacFan hvacFan) {
        hvacFan.setProp("TYPE_ID", "FAN");
        hvacFan.setProp("TAU_FAN", null);
        hvacFan.setProp("LOSS", Arrays.asList(new UnitDouble(0.0, Unit.ONE)));
        hvacFan.setProp(OPT_FAN_MODEL, FAN_MODEL_QUADRATIC);
        hvacFan.setProp("MAX_FLOW", new UnitDouble(0.0, SI.METER.pow(3).divide(SI.SECOND)));
        hvacFan.setProp("MAX_PRESSURE", new UnitDouble(0.0, SI.PASCAL));
        hvacFan.setProp("RAMP_ID", null);
        hvacFan.setProp("VOLUME_FLOW", new UnitDouble(0.0, SI.METER.pow(3).divide(SI.SECOND)));
    }

    public Variant getPressureFlow() {
        return this.d_pressureFlowRamp;
    }

    public void setPressureFlow(Variant variant) {
        if (theUtil.equal(this.d_pressureFlowRamp, variant)) {
            return;
        }
        this.d_pressureFlowRamp = variant;
        this.changedEvt(new Object[0]);
    }

    public TimeFunction getTauFunc() {
        return this.d_tauFunc;
    }

    public void setTauFunc(TimeFunction timeFunction) {
        if (theUtil.equal(this.d_tauFunc, timeFunction)) {
            return;
        }
        this.d_tauFunc = timeFunction;
        this.changedEvt(new Object[0]);
    }
}

