/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.hvac;

import java.util.Collection;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.bridge.ABridgeObj;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacNode;
import thunderheadeng.units.UnitDouble;

public class HvacDuctLoss
extends ABridgeObj {
    static final long serialVersionUID = 1L;
    public final HvacNode node;
    public final HvacDuct duct1;
    public final HvacDuct duct2;
    public final UnitDouble fwdLoss;
    public final UnitDouble revLoss;

    public HvacDuctLoss(HvacNode hvacNode, HvacDuct hvacDuct, HvacDuct hvacDuct2, UnitDouble unitDouble, UnitDouble unitDouble2) {
        this.node = hvacNode;
        this.duct1 = hvacDuct;
        this.duct2 = hvacDuct2;
        this.fwdLoss = unitDouble;
        this.revLoss = unitDouble2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HvacDuctLoss)) {
            return false;
        }
        HvacDuctLoss hvacDuctLoss = (HvacDuctLoss)object;
        return (hvacDuctLoss.duct1 == this.duct1 && hvacDuctLoss.duct2 == this.duct2 || hvacDuctLoss.duct1 == this.duct2 && hvacDuctLoss.duct2 == this.duct1) && hvacDuctLoss.getLoss(this.duct1).equals(this.getLoss(this.duct1)) && hvacDuctLoss.getLoss(this.duct2).equals(this.getLoss(this.duct2));
    }

    public int hashCode() {
        return 0x324F83FA ^ this.node.hashCode() + this.duct1.hashCode() + this.duct2.hashCode() + this.fwdLoss.hashCode() + this.revLoss.hashCode();
    }

    @Override
    public boolean isEquiv(Object object) {
        return this.equals(object);
    }

    public UnitDouble getLoss(HvacDuct hvacDuct) {
        if (hvacDuct == this.duct1) {
            return this.fwdLoss;
        }
        if (hvacDuct == this.duct2) {
            return this.revLoss;
        }
        return null;
    }

    public HvacDuct otherDuct(HvacDuct hvacDuct) {
        if (hvacDuct == this.duct1) {
            return this.duct2;
        }
        if (hvacDuct == this.duct2) {
            return this.duct1;
        }
        return null;
    }

    @Override
    public void getBridgedObjects(Collection<IPyroObject> collection) {
        collection.add(this.node);
        collection.add(this.duct1);
        collection.add(this.duct2);
    }
}

