/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.hvac;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.IImplicitGeomSrc;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.hvac.AHvacGeomComponent;
import pyrosim.domain.hvac.HvacAircoil;
import pyrosim.domain.hvac.HvacFan;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.hvac.HvacUtil;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.geom.Geometry;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;
import thunderheadeng.geometry.BoundingSphere;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.ILinearCurve;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class HvacDuct
extends AHvacGeomComponent
implements ISignalSink,
IImplicitGeomSrc {
    private static final long serialVersionUID = -4887397052092333390L;
    public static final String OPT_SHAPE = "opt_shape";
    public static final String OPT_AIRFLOW = "opt_none_damper_fan";
    public static final String OPT_FRICTION_TYPE = "opt_friction_type";
    public transient String d_n1;
    public transient String d_n2;
    private TimeBasedValue<UnitDouble> d_volflow;
    private IInPin d_inPin;
    private static final IPrimProps s_primProps;
    private static final Predicate<HvacNode> s_nodeFilter;

    public HvacDuct(String string) {
        super(string);
        HvacDuct.setDefaults(this);
        this.d_inPin = new OneLogicInPin(this);
        this.d_volflow = new TimeBasedValue<UnitDouble>(SIUS.newud(0.0, 24), TimeFunction.newDefault());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (!this.isPropDefined(OPT_FRICTION_TYPE)) {
            UnitDouble unitDouble = (UnitDouble)this.getProp("ROUGHNESS");
            if (unitDouble == null) {
                this.setProp(OPT_FRICTION_TYPE, (Object)FrictionType.NO_FRICTION);
            } else if (unitDouble.getValueNoUnit() == 0.0) {
                this.setProp(OPT_FRICTION_TYPE, (Object)FrictionType.COMPUTED_FRICTION);
            } else {
                this.setProp(OPT_FRICTION_TYPE, (Object)FrictionType.EXPLICIT);
            }
        }
    }

    public TimeBasedValue<UnitDouble> getVolflow() {
        return this.d_volflow;
    }

    public void setVolflow(TimeBasedValue<UnitDouble> timeBasedValue) {
        if (theUtil.equal(this.d_volflow, timeBasedValue)) {
            return;
        }
        this.d_volflow = timeBasedValue;
        this.changedEvt(new Object[0]);
    }

    private static void setDefaults(HvacDuct hvacDuct) {
        hvacDuct.setProp("TYPE_ID", "DUCT");
        hvacDuct.setProp(OPT_SHAPE, (Object)Shape.CIRCULAR);
        hvacDuct.setProp("DIAMETER", new UnitDouble(1.0, NonSI.FOOT));
        hvacDuct.setProp("AREA", new UnitDouble(0.0, SI.METER.pow(2)));
        hvacDuct.setProp("PERIMETER", new UnitDouble(0.0, SI.METER));
        hvacDuct.setProp(OPT_AIRFLOW, (Object)AirflowObj.NONE);
        hvacDuct.setProp("FAN_ID", null);
        hvacDuct.setProp("AIRCOIL_ID", null);
        hvacDuct.setProp("LENGTH", null);
        hvacDuct.setProp("LOSS", Arrays.asList(new UnitDouble(0.0, Unit.ONE), new UnitDouble(0.0, Unit.ONE)));
        hvacDuct.setProp("NODE_ID", Arrays.asList(null, null));
        hvacDuct.setProp("REVERSE", false);
        hvacDuct.setProp("ROUGHNESS", new UnitDouble(0.001, SI.METER));
        hvacDuct.setProp(OPT_FRICTION_TYPE, (Object)FrictionType.EXPLICIT);
    }

    public UnitDouble getFinalLength() {
        UnitDouble unitDouble = (UnitDouble)this.getProp("LENGTH");
        if (unitDouble != null) {
            return unitDouble;
        }
        List list = (List)this.getProp("NODE_ID");
        if (list.size() >= 2) {
            HvacNode hvacNode = (HvacNode)list.get(0);
            HvacNode hvacNode2 = (HvacNode)list.get(1);
            if (hvacNode != null && hvacNode2 != null) {
                return HvacDuct.getDistance(hvacNode, hvacNode2);
            }
        }
        return new UnitDouble(1.0, SI.METER);
    }

    public static UnitDouble getDistance(HvacNode hvacNode, HvacNode hvacNode2) {
        double d = hvacNode.getLocation().distance(hvacNode2.getLocation());
        return new UnitDouble(d, Geometry.LU);
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        this.addDep(depList, "AIRCOIL_ID");
        this.addDep(depList, "FAN_ID");
        this.addDep(depList, "NODE_ID");
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t instanceof HvacNode) {
            Util.keepIfNullOr(set, HvacNode.class);
            List list = (List)this.getProp("NODE_ID");
            for (HvacNode hvacNode : list) {
                if (hvacNode == null || hvacNode == t) continue;
                set.remove(hvacNode);
            }
        } else if (t instanceof HvacAircoil) {
            Util.keepIfNullOr(set, HvacAircoil.class);
        } else if (t instanceof HvacFan) {
            Util.keepIfNullOr(set, HvacFan.class);
        }
    }

    @Override
    public Task taskUpdateDep(IPyroObject iPyroObject, Collection<Object> collection) {
        if (iPyroObject instanceof HvacNode || iPyroObject instanceof HvacAircoil || iPyroObject instanceof HvacFan) {
            return GeomUtil.taskChanged(this);
        }
        return super.taskUpdateDep(iPyroObject, collection);
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (iPyroObject instanceof HvacNode) {
            List<HvacNode> list = this.getNodes();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) != iPyroObject) continue;
                arrayList.add(i);
            }
            final int[] nArray = theUtil.toIntArray(arrayList);
            return new AReplaceRefTask<HvacNode>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                protected void set(HvacNode hvacNode) {
                    ArrayList<HvacNode> arrayList = new ArrayList<HvacNode>(HvacDuct.this.getNodes());
                    for (int n : nArray) {
                        arrayList.set(n, hvacNode);
                    }
                    HvacDuct.this.setNodes((HvacNode)arrayList.get(0), (HvacNode)arrayList.get(1));
                }
            };
        }
        if (iPyroObject instanceof HvacAircoil) {
            return new AReplaceRefTask<HvacAircoil>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                protected void set(HvacAircoil hvacAircoil) {
                    HvacDuct.this.setAircoil(hvacAircoil);
                }
            };
        }
        if (iPyroObject instanceof HvacFan) {
            return new AReplaceRefTask<HvacFan>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                protected void set(HvacFan hvacFan) {
                    HvacDuct.this.setFan(hvacFan);
                }
            };
        }
        return super.taskReplaceDep(iPyroObject, iPyroObject2);
    }

    private void setAircoil(HvacAircoil hvacAircoil) {
        this.pauseUpdates();
        this.setProp("AIRCOIL_ID", hvacAircoil);
        AirflowObj airflowObj = hvacAircoil == null ? AirflowObj.NONE : AirflowObj.AIRCOIL;
        this.setProp(OPT_AIRFLOW, (Object)airflowObj);
        this.resumeUpdates();
    }

    private void setFan(HvacFan hvacFan) {
        this.pauseUpdates();
        this.setProp("FAN_ID", hvacFan);
        AirflowObj airflowObj = hvacFan == null ? AirflowObj.NONE : AirflowObj.FAN;
        this.setProp(OPT_AIRFLOW, (Object)airflowObj);
        this.resumeUpdates();
    }

    @Override
    public Collection<IPyroGeomSrc> getDefiningObjs(Collection<IPyroGeomSrc> collection) {
        collection.addAll(this.getNodes());
        return collection;
    }

    public List<HvacNode> getNodes() {
        return (List)this.getProp("NODE_ID");
    }

    public void setNodes(HvacNode hvacNode, HvacNode hvacNode2) {
        this.setNodes(Arrays.asList(hvacNode, hvacNode2));
    }

    public void setNodes(List<HvacNode> list) {
        assert (list.size() == 2);
        this.setProp("NODE_ID", list);
    }

    @Override
    public void setProp(String string, Object object) {
        assert (!string.equals("VOLUME_FLOW")) : "Use HvacDuct.setVolflow() instead.";
        super.setProp(string, object);
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public Object clone() {
        HvacDuct hvacDuct = (HvacDuct)super.clone();
        hvacDuct.d_inPin = (IInPin)this.d_inPin.clone(hvacDuct);
        hvacDuct.d_volflow = this.d_volflow.clone();
        return hvacDuct;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof HvacDuct && super.equals(object) && this.d_inPin.equals(((HvacDuct)object).d_inPin);
    }

    public boolean isNodeAttached(HvacNode hvacNode) {
        List list = (List)this.getProp("NODE_ID");
        if (!list.isEmpty()) {
            return hvacNode.equals(list.get(0)) || hvacNode.equals(list.get(1));
        }
        return false;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        IGeomNode iGeomNode = this.getGeom();
        if (iGeomNode == GeomNodeUtil.EMPTY_NODE) {
            return DisplayGeom.EMPTY;
        }
        return new DisplayGeom(iGeomNode, s_primProps);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getDuctGeom());
    }

    public IGeom getDuctGeom() {
        List<HvacNode> list = this.getNodes();
        if (list.size() < 2 || list.get(0) == null || list.get(1) == null) {
            return EmptyGeom.INSTANCE;
        }
        return new DuctGeom(list.get(0), list.get(1));
    }

    @Override
    public void setGeom(IGeomNode iGeomNode) {
        this.setGeom(iGeomNode.flatten().getLocalGeom());
    }

    public void setGeom(IGeom iGeom) {
        if (iGeom instanceof DuctGeom) {
            DuctGeom ductGeom = (DuctGeom)iGeom;
            ArrayList<HvacNode> arrayList = new ArrayList<HvacNode>(2);
            arrayList.add(ductGeom.node1);
            arrayList.add(ductGeom.node2);
            this.setProp("NODE_ID", arrayList);
        }
    }

    public static Predicate<HvacNode> getNodeFilter() {
        return s_nodeFilter;
    }

    static {
        TVEntryPoint.registerReferencedUpdateTypes(HvacNode.class, HvacAircoil.class, HvacFan.class);
        s_primProps = new IPrimProps.Edge(new Color(16753920), 3.0, IPrimProps.DEF_STIPPLE, 0);
        s_nodeFilter = new Predicate<HvacNode>(){

            @Override
            public boolean test(HvacNode hvacNode) {
                PyroMod pyroMod = (PyroMod)hvacNode.getDomain();
                if (pyroMod == null) {
                    return false;
                }
                int n = HvacUtil.getConnectedDucts(pyroMod.getObstructions(), hvacNode).size();
                int n2 = hvacNode.getOpenDuctCount(n);
                return 0 < n2;
            }
        };
    }

    public static class DuctGeom
    extends LineSeg {
        private static final long serialVersionUID = -6451536396755602607L;
        public final HvacNode node1;
        public final HvacNode node2;

        public DuctGeom(HvacNode hvacNode, HvacNode hvacNode2) {
            super(hvacNode.getLocation(), hvacNode2.getLocation());
            this.node1 = hvacNode;
            this.node2 = hvacNode2;
        }

        @Override
        public LineSeg optimize(IPointOptimizer iPointOptimizer) {
            return this;
        }

        @Override
        public LineSeg transform(TransformInfo transformInfo, int n) {
            return this;
        }

        @Override
        public boolean equals(Object object) {
            return object == this || object instanceof DuctGeom && ((DuctGeom)object).node1 == this.node1 && ((DuctGeom)object).node2 == this.node2;
        }

        @Override
        public LineSeg negate() {
            return new DuctGeom(this.node2, this.node1);
        }

        @Override
        public Collection<? extends IHandle> generateManipHandles() {
            return Arrays.asList(new Handle(this, 0), new Handle(this, 1));
        }

        protected static class Handle
        extends ILinearCurve.Handle {
            public Handle(DuctGeom ductGeom, int n) {
                super(ductGeom, n);
            }

            @Override
            public boolean equals(Object object) {
                return object == this || object instanceof Handle && super.equals(object);
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_ONE_PASS, new DefaultFilter(new Class[]{HvacNode.class}){

                    @Override
                    public boolean acceptPickObject(Object object) {
                        return object instanceof HvacNode && HvacDuct.getNodeFilter().test((HvacNode)object);
                    }
                });
            }

            protected LineSeg newGeom(LineSeg lineSeg, int n, Point3d point3d, Point3d point3d2) throws Exception {
                DuctGeom ductGeom = (DuctGeom)lineSeg;
                HvacNode[] hvacNodeArray = new HvacNode[]{ductGeom.node1, ductGeom.node2};
                Point3d point3d3 = n == 0 ? point3d : point3d2;
                BoundingSphere boundingSphere = new BoundingSphere(point3d3, 1.0E-6);
                CollResult collResult = new CollResult(HvacNode.class);
                PyroSim.getApp().getMediator().getGeomLocator().find(boundingSphere, collResult, false);
                HvacNode hvacNode = null;
                double d = Double.POSITIVE_INFINITY;
                for (HvacNode hvacNode2 : collResult.coll) {
                    Point3d point3d4 = hvacNode2.getLocation();
                    double d2 = point3d3.distance(point3d4);
                    if (!(d2 < d)) continue;
                    d = d2;
                    hvacNode = hvacNode2;
                }
                if (hvacNode == null) {
                    throw new Exception();
                }
                hvacNodeArray[n] = hvacNode;
                return new DuctGeom(hvacNodeArray[0], hvacNodeArray[1]);
            }
        }
    }

    public static enum FrictionType {
        NO_FRICTION(Intl.intl("No Friction")),
        COMPUTED_FRICTION("Minimum Friction"),
        EXPLICIT("Explicit");

        public final String displayName;

        private FrictionType(String string2) {
            this.displayName = string2;
        }
    }

    public static enum AirflowObj {
        NONE,
        DAMPER,
        FAN,
        AIRCOIL,
        VOLFLOW;

    }

    public static enum Shape {
        CIRCULAR,
        NON_CIRCULAR;

    }
}

