/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.hvac;

import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.hvac.HvacComponent;
import pyrosim.domain.hvac.IHvacObject;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.OneLogicInPin;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class HvacAircoil
extends HvacComponent
implements IHvacObject,
ISignalSink {
    private static final long serialVersionUID = 1L;
    public static final String OPT_AIRCOIL_MODEL = "opt_aircoil_model";
    private TimeBasedValue<UnitDouble> d_fixedQ;
    @Deprecated
    private IInPin d_inPin;

    public HvacAircoil(String string) {
        super(string);
        HvacAircoil.setDefaults(this);
        this.d_fixedQ = new TimeBasedValue<UnitDouble>(new UnitDouble(0.0, SI.KILO(SI.JOULE).divide(SI.SECOND)), TimeFunction.newDefault());
        this.d_inPin = new OneLogicInPin(this);
    }

    public static void setDefaults(HvacAircoil hvacAircoil) {
        hvacAircoil.setProp("TYPE_ID", "AIRCOIL");
        hvacAircoil.setProp("COOLANT_SPECIFIC_HEAT", new UnitDouble(0.0, SI.KILO(SI.JOULE).divide(SI.KILOGRAM.multiply(SI.KELVIN))));
        hvacAircoil.setProp("COOLANT_MASS_FLOW", new UnitDouble(0.0, SI.KILOGRAM.divide(SI.SECOND)));
        hvacAircoil.setProp("COOLANT_TEMPERATURE", new UnitDouble(0.0, SI.CELSIUS));
        hvacAircoil.setProp("EFFICIENCY", new UnitDouble(0.0, Unit.ONE));
        hvacAircoil.setProp(OPT_AIRCOIL_MODEL, (Object)Model.FIXEDQ);
    }

    public TimeBasedValue<UnitDouble> getFixedQ() {
        return this.d_fixedQ;
    }

    public void setFixedQ(TimeBasedValue<UnitDouble> timeBasedValue) {
        if (theUtil.equal(this.d_fixedQ, timeBasedValue)) {
            return;
        }
        this.d_fixedQ = timeBasedValue;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public Object clone() {
        HvacAircoil hvacAircoil = (HvacAircoil)super.clone();
        hvacAircoil.d_inPin = (IInPin)this.d_inPin.clone(hvacAircoil);
        return hvacAircoil;
    }

    @Override
    public boolean equals(Object object) {
        return object == this || object instanceof HvacAircoil && this.d_fixedQ.equals(((HvacAircoil)object).d_fixedQ) && super.equals(object) && this.d_inPin.equals(((HvacAircoil)object).d_inPin);
    }

    public static enum Model {
        COOLANT,
        FIXEDQ;

    }
}

