/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom.plane;

import java.io.Serializable;
import java.util.Objects;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.geom.plane.IPlane;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Global;

public class PointNormalPlane
implements IPlane,
Serializable {
    private static final long serialVersionUID = 1L;
    public final Point3d point;
    public final Vector3d normal;

    public PointNormalPlane(Point3d point3d, Vector3d vector3d) {
        this.point = point3d;
        this.normal = vector3d;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PointNormalPlane)) {
            return false;
        }
        PointNormalPlane pointNormalPlane = (PointNormalPlane)object;
        return pointNormalPlane.point.equals(this.point) && pointNormalPlane.normal.equals(this.normal);
    }

    public int hashCode() {
        return 153307386 + Objects.hash(this.point, this.normal);
    }

    @Override
    public Plane3d get() {
        return new Plane3d(this.normal, this.point);
    }

    @Override
    public String toString(Unit unit) {
        UnitPoint3D unitPoint3D = new UnitPoint3D(this.point, Geometry.LU).convert(unit);
        return String.format(Intl.intl("point=(%s, %s, %s) %s, normal=(%s, %s, %s)"), Global.format(unitPoint3D.x()), Global.format(unitPoint3D.y()), Global.format(unitPoint3D.z()), unit.toString(), Global.format(this.normal.x), Global.format(this.normal.y), Global.format(this.normal.z));
    }
}

