/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom.plane;

import java.io.Serializable;
import org.jscience.physics.units.Unit;
import pyrosim.domain.geom.plane.IPlane;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.theUtil;

public class EuclideanPlane
implements IPlane,
Serializable {
    private static final long serialVersionUID = 1L;
    public final double x;
    public final double y;
    public final double z;
    public final double w;

    public EuclideanPlane(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof EuclideanPlane)) {
            return false;
        }
        EuclideanPlane euclideanPlane = (EuclideanPlane)object;
        return euclideanPlane.x == this.x && euclideanPlane.y == this.y && euclideanPlane.z == this.z && euclideanPlane.w == this.w;
    }

    public int hashCode() {
        return 0x398FAD23 ^ theUtil.hashCode(this.x) + theUtil.hashCode(this.y) + theUtil.hashCode(this.z) + theUtil.hashCode(this.w);
    }

    @Override
    public Plane3d get() {
        Plane3d plane3d = new Plane3d(this.x, this.y, this.z, this.w);
        return plane3d.normalize();
    }

    private static String format(double d, Unit unit) {
        return Global.format(UnitDouble.convert(d, Geometry.LU, unit), unit);
    }

    @Override
    public String toString(Unit unit) {
        return String.format("%s, %s, %s, %s", Global.format(this.x), Global.format(this.y), Global.format(this.z), EuclideanPlane.format(this.w, unit));
    }
}

