/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom.plane;

import java.io.Serializable;
import java.util.Objects;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.geom.plane.IPlane;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;

public class AAPlane
implements IPlane,
Serializable {
    private static final long serialVersionUID = 1L;
    public final Axis axis;
    public final double val;
    public final boolean pnormal;

    public AAPlane(Axis axis, double d, boolean bl) {
        this.axis = axis;
        this.val = d;
        this.pnormal = bl;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AAPlane)) {
            return false;
        }
        AAPlane aAPlane = (AAPlane)object;
        return aAPlane.axis == this.axis && aAPlane.pnormal == this.pnormal && aAPlane.val == this.val;
    }

    public int hashCode() {
        return 0x23498FA ^ Objects.hash(new Object[]{this.axis, this.val, this.pnormal});
    }

    @Override
    public Plane3d get() {
        double d = this.pnormal ? 1.0 : -1.0;
        double d2 = -d * this.val;
        switch (this.axis) {
            case X: {
                return new Plane3d(d, 0.0, 0.0, d2);
            }
            case Y: {
                return new Plane3d(0.0, d, 0.0, d2);
            }
        }
        return new Plane3d(0.0, 0.0, d, d2);
    }

    @Override
    public String toString(Unit unit) {
        char c = this.pnormal ? (char)'+' : '-';
        String string = String.format("%c%s", new Object[]{Character.valueOf(c), this.axis});
        return String.format(Intl.intl("%s=%s, normal=%s"), this.axis.toString(), Global.format(UnitDouble.convert(this.val, Geometry.LU, unit), unit), string);
    }

    public static enum Axis {
        X,
        Y,
        Z;

    }
}

