/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import junit.framework.TestCase;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.PyroSim;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.geom.Obstruction;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.WallGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint2D;
import thunderheadeng.units.UnitPoint3D;

public class WallTest
extends TestCase {
    SurfaceManager d_surfMgr;
    Obstruction d_wall;
    Unit u;

    private Obstruction newTestWall(Point2d point2d, Point2d point2d2, double d, double d2, double d3) {
        LineSeg lineSeg = new LineSeg(new Point3d(point2d.x, point2d.y, d), new Point3d(point2d2.x, point2d2.y, d));
        WallGeom.Alignment alignment = d3 < 0.0 ? WallGeom.Alignment.RIGHT : WallGeom.Alignment.LEFT;
        WallGeom wallGeom = new WallGeom(lineSeg, alignment, Math.abs(d3), d2 - d);
        return new Obstruction("test", GeomNodeUtil.newNode(wallGeom), new Surface[]{this.d_surfMgr.get(PredefSurf.INERT)});
    }

    protected void setUp() throws Exception {
        this.d_surfMgr = new SurfaceManager();
        this.d_surfMgr.addPredefined();
        this.u = SI.METER;
        this.d_wall = this.newTestWall(new Point2d(1.0, 2.0), new Point2d(4.0, 5.0), 3.0, 6.0, 3.0);
    }

    public void testMinPoint() {
        this.u = SI.METER;
        this.d_wall = this.newTestWall(new Point2d(1.0, 0.0), new Point2d(1.0, 4.0), 3.0, 6.0, 2.0);
        UnitPoint3D unitPoint3D = GeomUtil.getUnitBounds(this.d_wall).getMin();
        Point3d point3d = unitPoint3D.getValue(this.u);
        WallTest.assertEquals((Object)point3d, (Object)new Point3d(-1.0, 0.0, 3.0));
        WallTest.assertEquals((Object)GeomUtil.getUnitBounds(this.d_wall).getMax(), (Object)new UnitPoint3D(1.0, 4.0, 6.0, this.u));
        this.d_wall = this.newTestWall(new Point2d(1.0, 0.0), new Point2d(1.0, 4.0), 3.0, 6.0, -2.0);
        unitPoint3D = GeomUtil.getUnitBounds(this.d_wall).getMin();
        point3d = unitPoint3D.getValue(this.u);
        WallTest.assertEquals((Object)point3d, (Object)new Point3d(1.0, 0.0, 3.0));
        WallTest.assertEquals((Object)GeomUtil.getUnitBounds(this.d_wall).getMax(), (Object)new UnitPoint3D(3.0, 4.0, 6.0, this.u));
        this.d_wall = this.newTestWall(new Point2d(5.0, 0.0), new Point2d(17.0, 9.0), 0.0, 5.0, 5.0);
        unitPoint3D = GeomUtil.getUnitBounds(this.d_wall).getMin();
        point3d = unitPoint3D.getValue(this.u);
        WallTest.assertEquals((Object)point3d, (Object)new Point3d(2.0, 0.0, 0.0));
        WallTest.assertEquals((Object)GeomUtil.getUnitBounds(this.d_wall).getMax(), (Object)new UnitPoint3D(17.0, 13.0, 5.0, this.u));
        this.d_wall = this.newTestWall(new Point2d(5.0, 0.0), new Point2d(17.0, 9.0), 0.0, 5.0, -5.0);
        unitPoint3D = GeomUtil.getUnitBounds(this.d_wall).getMin();
        point3d = unitPoint3D.getValue(this.u);
        WallTest.assertEquals((Object)point3d, (Object)new Point3d(5.0, -4.0, 0.0));
        WallTest.assertEquals((Object)GeomUtil.getUnitBounds(this.d_wall).getMax(), (Object)new UnitPoint3D(20.0, 9.0, 5.0, this.u));
    }

    private void assertEpsEquals(UnitPoint2D unitPoint2D, UnitPoint2D unitPoint2D2) {
        BaseUnit baseUnit = SI.METER;
        WallTest.assertTrue((String)("expected:<" + unitPoint2D.toString() + "> but was:<" + unitPoint2D2.toString() + ">"), (boolean)unitPoint2D.getP2dValue(baseUnit).epsilonEquals(unitPoint2D2.getP2dValue(baseUnit), 1.0E-9));
    }

    private void assertEpsEquals(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2) {
        BaseUnit baseUnit = SI.METER;
        WallTest.assertTrue((String)("expected:<" + unitPoint3D.toString() + "> but was:<" + unitPoint3D2.toString() + ">"), (boolean)unitPoint3D.getPoint3dValue(baseUnit).epsilonEquals(unitPoint3D2.getPoint3dValue(baseUnit), 1.0E-9));
    }

    private void assertEpsEquals(UnitDouble unitDouble, UnitDouble unitDouble2) {
        WallTest.assertTrue((String)("expected:<" + unitDouble.toString() + "> but was:<" + unitDouble2.toString() + ">"), (boolean)unitDouble.epsilonEquals(unitDouble2, 1.0E-9));
    }

    static {
        new PyroSim();
    }
}

