/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.GridMergeUtil;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.domain.boundcond.surf.Fuel;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.geom.AFDSObject;
import pyrosim.domain.geom.FDSUtil;
import pyrosim.domain.geom.ISurfObj;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.domain.rasterization.IFDSObjProps;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.geom.Geometry;
import pyrosim.geom.IPyroDisplayProps;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.scene3d.Rectifier;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.DisplayGeomBuilder;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.LineConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Filters;
import thunderheadeng.util.HashPool;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class Vent
extends AFDSObject
implements ISurfObj {
    static final long serialVersionUID = 1L;
    public static final int OPTION_OUTLINE = 1;
    public static final int ALL_OPTIONS = 1;
    public static final int DEF_OPTIONS = 0;
    private AARectangle d_quad;
    private Vector3d d_normal;
    private Surface d_surf;
    private TexOrigin d_texOrigin;
    private Object d_texMapper;
    private Vector3d d_louver;
    private OpenProps d_openProps;
    private UnitDouble d_spreadRate;
    private UnitPoint3D d_centerPoint;
    private UnitDouble d_radius;
    public static final Composite.IObjectProp surfProp;

    public Vent(String string, Surface surface) {
        this(string, surface, new AARectangle(2, 0.0, 0.0, 0.0, 1.0, 1.0, false), null, null);
    }

    public Vent(String string, Surface surface, AARectangle aARectangle) {
        this(string, surface, aARectangle, null, null);
    }

    public Vent(String string, Surface surface, AARectangle aARectangle, UnitDouble unitDouble, UnitPoint3D unitPoint3D) {
        super(string);
        this.d_quad = new AARectangle(aARectangle.d_plane, aARectangle.d_planeVal, aARectangle.d_minx, aARectangle.d_miny, aARectangle.d_maxx, aARectangle.d_maxy, aARectangle.flipped);
        assert (!(this.d_quad instanceof VentGeom));
        this.d_surf = surface;
        this.d_normal = aARectangle instanceof VentGeom ? ((VentGeom)aARectangle).normal : null;
        this.d_spreadRate = unitDouble;
        this.d_centerPoint = unitPoint3D;
        this.d_radius = aARectangle instanceof VentGeom ? ((VentGeom)aARectangle).radius : null;
        this.d_texOrigin = TexOrigin.defaultWorld();
        this.d_texMapper = FDSUtil.getDefaultTexMapperSets();
        this.setOptions(0, true);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_texMapper instanceof IElemSource) {
            IElemSource iElemSource = (IElemSource)this.d_texMapper;
            this.d_texMapper = iElemSource == Elements.NO_UV ? Collections.emptyMap() : Collections.singletonMap("uvset", iElemSource);
        }
    }

    public static Predicate<Surface> getSurfaceFilter() {
        return Filters.acceptAll();
    }

    @Override
    public void getCustomFDSTypes(Collection<String> collection) {
        collection.add("VENT");
    }

    @Override
    public boolean isControllable() {
        return Vent.isControllableSurf(this.d_surf);
    }

    public static boolean isControllableSurf(Surface surface) {
        return !surface.isPredefined(PredefSurf.OPEN) && !surface.isPredefined(PredefSurf.MIRROR) && !surface.isPredefined(PredefSurf.HVAC);
    }

    private static int filterOptions(int n) {
        return n & 1;
    }

    public void setOptions(int n, boolean bl) {
        this.setFlags(Vent.filterOptions(n), bl, new Object[0]);
    }

    public boolean getOptions(int n) {
        return this.testFlags(Vent.filterOptions(n));
    }

    public int getSetOptions() {
        return Vent.filterOptions(super.getSetFlags());
    }

    public Vector3d getLouver() {
        return this.d_louver;
    }

    public void setLouver(Vector3d vector3d) {
        if (theUtil.equal(this.d_louver, vector3d)) {
            return;
        }
        this.d_louver = vector3d;
        this.changedEvt(new Object[0]);
    }

    public void setNormal(Vector3d vector3d) {
        this.d_normal = vector3d;
        this.changedEvt(new Object[0]);
    }

    public Vector3d getNormal() {
        return this.d_normal;
    }

    @Override
    public TexOrigin getTextureOrigin() {
        return this.d_texOrigin;
    }

    @Override
    public void setTextureOrigin(TexOrigin texOrigin) {
        this.d_texOrigin = texOrigin;
        this.changedEvt(new Object[0]);
    }

    public void setOpenProps(OpenProps openProps) {
        this.d_openProps = openProps;
        this.changedEvt(new Object[0]);
    }

    public OpenProps getOpenProps() {
        return this.d_openProps;
    }

    @Override
    public int getNumFaces() {
        return 1;
    }

    @Override
    public Surface[] getSurfaces() {
        return new Surface[]{this.getSurface()};
    }

    @Override
    public void setSurfaces(Surface[] surfaceArray) {
        assert (surfaceArray.length == 1);
        this.setSurface(surfaceArray[0]);
    }

    @Override
    public Predicate<Surface> getSurfFilter() {
        if (this.d_surf.isPredefined(PredefSurf.HVAC)) {
            return Filters.accept(this.d_surf);
        }
        return Vent.getSurfaceFilter();
    }

    public Surface getSurface() {
        return this.d_surf;
    }

    public void setSurface(Surface surface) {
        if (this.d_surf == surface) {
            return;
        }
        this.d_surf = surface;
        this.changedEvt(new Object[0]);
    }

    @Override
    public IFDSObjProps getFragGenerator() {
        return null;
    }

    @Override
    public DisplayGeom getDisplayGeom(PyroMod pyroMod, IDisplayProps iDisplayProps) {
        Vent vent = this;
        DisplayGeom displayGeom = this.getBaseDisplayGeom(pyroMod, iDisplayProps);
        if (vent.getOptions(1) || !(iDisplayProps instanceof IPyroDisplayProps)) {
            return displayGeom;
        }
        IPyroDisplayProps iPyroDisplayProps = (IPyroDisplayProps)iDisplayProps;
        boolean bl = false;
        IGeomNode iGeomNode = displayGeom.node.flatten();
        List<IPrimitive> list = GeomUtil.explodeToTypes(iGeomNode.getLocalGeom(), 7);
        DisplayGeomBuilder displayGeomBuilder = new DisplayGeomBuilder();
        for (int i = 0; i < list.size(); ++i) {
            Elements.Orient orient;
            Elements.Orient orient2;
            IPrimitive iPrimitive = list.get(i);
            IPrimProps iPrimProps = displayGeom.props.get(i);
            IPropertySet iPropertySet = Elements.getPrimElements(iGeomNode.getLocalElements(), i);
            if (iPrimitive instanceof IFace && (orient2 = this.getCullOrient(iPyroDisplayProps, (IFace)iPrimitive, orient = (Elements.Orient)((Object)((IElemSource)((Object)iPropertySet.get(Elements.ORIENT))).getPrimElement(0)))) != null) {
                bl = true;
                int n = iPrimProps.getOptions() | 2;
                iPrimProps = iPrimProps.setOptions(n);
                iPropertySet = Elements.copyOf(iPropertySet);
                iPropertySet.setIfNotDefault(Elements.ORIENT, orient2 == Elements.Orient.CCW ? Elements.CCW : Elements.CW);
                iPropertySet = Elements.finalizeElements(iPropertySet);
            }
            displayGeomBuilder.add((IGeom)iPrimitive, new UniformProps(iPrimProps), iPropertySet);
        }
        if (!bl) {
            return displayGeom;
        }
        return displayGeomBuilder.finish().toDisplay();
    }

    private Elements.Orient getCullOrient(IPyroDisplayProps iPyroDisplayProps, IFace iFace, Elements.Orient orient) {
        Tuple3d tuple3d;
        Object object;
        Vent vent = this;
        if (vent.getOptions(1)) {
            return null;
        }
        if (!(iFace instanceof IPolygon)) {
            return null;
        }
        Vector3d vector3d = vent.getNormal();
        if (vector3d == null) {
            object = iPyroDisplayProps.getMergedMeshes();
            if (object == null) {
                return null;
            }
            tuple3d = iFace.getBoundingBox(new AABox()).getCenter();
            Iterator<Face> iterator = ((GridMergeUtil.MergeResult)object).model.findFaces(new AABox((Point3d)tuple3d)).iterator();
            if (iterator.hasNext()) {
                Face face = iterator.next();
                vector3d = Util3D.negate(face.plane.getNormal());
            }
            if (vector3d == null) {
                return null;
            }
        }
        assert (vector3d != null);
        object = (IPolygon)iFace;
        tuple3d = object.getNormal(orient.isCCW());
        if (vector3d.epsilonEquals(tuple3d, 1.0E-9)) {
            return orient;
        }
        return orient.flip();
    }

    private DisplayGeom getBaseDisplayGeom(PyroMod pyroMod, IDisplayProps iDisplayProps) {
        Object object;
        IPyroDisplayProps iPyroDisplayProps = iDisplayProps instanceof IPyroDisplayProps ? (IPyroDisplayProps)iDisplayProps : null;
        DisplayGeomBuilder displayGeomBuilder = new DisplayGeomBuilder();
        VentGeom ventGeom = this.getVentGeom();
        IGeomNode iGeomNode = GeomNodeUtil.newNode(ventGeom, Elements.newElements(Elements.UV, this.getTexMappers()));
        iGeomNode = FDSUtil.finalizeUVElements(iGeomNode, this.d_texOrigin);
        Color color = this.getColors()[0];
        IPrimProps.Face face = FDSUtil.newObstFaceProps(color, this.getSurface(), 0);
        displayGeomBuilder.add(iGeomNode.getLocalGeom(), face, iGeomNode.getLocalElements());
        if (ventGeom.normal != null && (iPyroDisplayProps == null || iPyroDisplayProps.getVentOrientVisible())) {
            object = ventGeom.getBoundingBox(new AABox());
            Point3d point3d = Util3D.getMidPoint(((AABox)object).getMin(), ((AABox)object).getMax());
            Point3d point3d2 = new Point3d(ventGeom.normal);
            point3d2.scale(Vent.getNormalDistFromCenter((AABox)object));
            point3d2.add(point3d);
            LineSeg lineSeg = new LineSeg(point3d, point3d2);
            displayGeomBuilder.add((IGeom)lineSeg, new UniformProps(new IPrimProps.Edge(Color.BLACK, 1.0, IPrimProps.DEF_STIPPLE, 0)), Elements.NONE);
        }
        object = displayGeomBuilder.finish().toDisplay();
        if (this.getOptions(1)) {
            object = GeomUtil.convertToOutline((DisplayGeom)object);
        }
        return object;
    }

    private static Color resolveColor(Color color, Surface surface) {
        if (color != null) {
            return color;
        }
        return surface.getColor();
    }

    public static double getNormalDistFromCenter(AABox aABox) {
        double d = aABox.getWidth();
        double d2 = aABox.getDepth();
        double d3 = aABox.getHeight();
        double d4 = Double.MIN_VALUE;
        if (d > d4) {
            d4 = d;
        }
        if (d2 > d4) {
            d4 = d2;
        }
        if (d3 > d4 && d3 > 0.0) {
            d4 = d3;
        }
        return d4 * 0.25;
    }

    @Override
    public IGeomNode getGeom() {
        IPropertySet iPropertySet = Elements.newElements(Elements.UV, this.getTexMappers());
        return GeomNodeUtil.newNode(this.getVentGeom(), iPropertySet);
    }

    public VentGeom getVentGeom() {
        return new VentGeom(this);
    }

    @Override
    public void setGeom(IGeomNode iGeomNode) {
        iGeomNode = iGeomNode.flatten();
        this.pauseUpdates();
        this.setGeom(iGeomNode.getLocalGeom());
        this.setTexMappers(iGeomNode.getLocalElements().get(Elements.UV));
        this.resumeUpdates();
    }

    public void setTexMappers(Map<String, IElemSource<Point2d>> map) {
        if (Objects.equals(map, this.d_texMapper)) {
            return;
        }
        this.d_texMapper = map;
        this.changedEvt(new Object[0]);
    }

    public Map<String, IElemSource<Point2d>> getTexMappers() {
        return (Map)this.d_texMapper;
    }

    public void setGeom(IGeom iGeom) {
        if (iGeom instanceof VentGeom) {
            VentGeom ventGeom = (VentGeom)iGeom;
            this.d_quad = new AARectangle(ventGeom.d_plane, ventGeom.d_planeVal, ventGeom.d_minx, ventGeom.d_miny, ventGeom.d_maxx, ventGeom.d_maxy, ventGeom.flipped);
            this.d_normal = ventGeom.normal;
            this.d_centerPoint = ventGeom.centerPoint;
            this.d_radius = ventGeom.radius;
            this.d_louver = ventGeom.louver;
            this.changedEvt(new Object[0]);
        } else if (iGeom instanceof AARectangle) {
            this.pauseUpdates();
            this.d_quad = (AARectangle)iGeom;
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    public UnitPoint3D getDefaultCenterPoint() {
        AABox aABox = new AABox();
        this.getGeom().getBoundingBox(aABox);
        return new UnitPoint3D((aABox.getMaxX() + aABox.getMinX()) / 2.0, (aABox.getMaxY() + aABox.getMinY()) / 2.0, (aABox.getMaxZ() + aABox.getMinZ()) / 2.0, PyroSim.getApp().getUnitSystem().getLengthUnit());
    }

    public UnitDouble getFireSpreadRate() {
        return this.d_spreadRate;
    }

    public void setFireSpreadRate(UnitDouble unitDouble) {
        this.d_spreadRate = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public UnitPoint3D getCenterPoint() {
        return this.d_centerPoint;
    }

    public void setCenterPoint(UnitPoint3D unitPoint3D) {
        this.d_centerPoint = unitPoint3D;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getRadius() {
        return this.d_radius;
    }

    public void setRadius(UnitDouble unitDouble) {
        this.d_radius = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public static boolean isValidFireSpreadSurf(Surface surface) {
        if (surface == null) {
            return false;
        }
        if (surface.getSurfDesc() instanceof BurnerSurfDesc) {
            return true;
        }
        if (surface.getSurfDesc() instanceof LayeredSurfDesc) {
            LayeredSurfDesc layeredSurfDesc = (LayeredSurfDesc)surface.getSurfDesc();
            return layeredSurfDesc.d_iReac instanceof Fuel.ManualReac;
        }
        return false;
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        super.takeDepSnapshot(depList);
        depList.add(DLink.REQUIRED, (IPyroObject)this.d_surf);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t == this.d_surf) {
            Util.keepIfNullOr(set, Surface.class);
        } else if (t instanceof ExSpec) {
            Util.keepIfNullOr(set, ExSpec.class);
        }
    }

    @Override
    public Task taskUpdateDep(IPyroObject iPyroObject, Collection<Object> collection) {
        if (!(iPyroObject instanceof Surface) && Util.containsAny(collection, Surface.EVT_APPEARANCE, Surface.EVT_COLOR, EventChannel.EVT_GENERAL)) {
            return super.taskUpdateDep(iPyroObject, collection);
        }
        return GeomUtil.taskChanged(this);
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (iPyroObject instanceof Surface) {
            return new AReplaceRefTask<Surface>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                protected void set(Surface surface) {
                    Vent.this.setSurface(surface);
                }
            };
        }
        return super.taskReplaceDep(iPyroObject, iPyroObject2);
    }

    static {
        TVEntryPoint.registerReferencedUpdateTypes(Surface.class);
        surfProp = new Composite.AObjectProp<Vent, Surface>(Vent.class){

            @Override
            public void set(Vent vent, Surface surface) {
                vent.setSurface(surface);
            }

            @Override
            public Object get(Vent vent) {
                return vent.getSurface();
            }
        };
    }

    public static class OptionProp
    extends Composite.AObjectProp<Vent, Boolean> {
        private final int d_option;

        public OptionProp(int n) {
            super(Vent.class);
            this.d_option = n;
        }

        @Override
        public void set(Vent vent, Boolean bl) {
            vent.setOptions(this.d_option, bl);
        }

        @Override
        public Object get(Vent vent) {
            return vent.getOptions(this.d_option);
        }
    }

    public static class OpenProps
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final OpenProps DEFAULT = new OpenProps(null, new TimeBasedValue<UnitDouble>(new UnitDouble(0.0, SIUS.unit(39)), TimeFunction.newDefault()));
        public final UnitDouble temp;
        public final TimeBasedValue<UnitDouble> pressure;

        public OpenProps(UnitDouble unitDouble, TimeBasedValue<UnitDouble> timeBasedValue) {
            this.temp = unitDouble;
            this.pressure = timeBasedValue;
        }
    }

    public static class VentGeom
    extends AARectangle {
        static final long serialVersionUID = -7721415650741267503L;
        public final Vector3d normal;
        public final Vector3d louver;
        public final UnitDouble radius;
        public final UnitPoint3D centerPoint;

        public VentGeom(Vent vent) {
            this(vent.d_quad, vent.d_normal, vent.d_centerPoint, vent.d_louver, vent.d_radius);
        }

        public VentGeom(AARectangle aARectangle, Vector3d vector3d, UnitPoint3D unitPoint3D, Vector3d vector3d2, UnitDouble unitDouble) {
            super(aARectangle.d_plane, aARectangle.d_planeVal, aARectangle.d_minx, aARectangle.d_miny, aARectangle.d_maxx, aARectangle.d_maxy, aARectangle.flipped);
            this.normal = vector3d;
            this.louver = vector3d2;
            this.radius = unitDouble;
            this.centerPoint = unitPoint3D;
        }

        public AARectangle optimize(HashPool<Point3d> hashPool) {
            return this;
        }

        @Override
        public IDOF getDOF() {
            return IDOF.ALIGNED;
        }

        @Override
        public IPolygon transform(TransformInfo transformInfo, int n) {
            if (transformInfo.isIdentity()) {
                return this;
            }
            Matrix4d matrix4d = transformInfo.getMatrix();
            AABox aABox = new AABox();
            super.getBoundingBox(aABox);
            Point3d point3d = Util3D.xform(matrix4d, aABox.getMin());
            Point3d point3d2 = Util3D.xform(matrix4d, aABox.getMax());
            Rectifier.rectify(point3d, point3d2);
            AARectangle aARectangle = AARectangle.construct(point3d, point3d2, false);
            if (aARectangle == null) {
                return this;
            }
            Vector3d vector3d = this.normal;
            if (this.normal != null) {
                vector3d = Util3D.xform(matrix4d, this.normal);
                vector3d.normalize();
            }
            UnitPoint3D unitPoint3D = this.centerPoint;
            if (this.centerPoint != null) {
                unitPoint3D = Geometry.xform(matrix4d, this.centerPoint);
            }
            Vector3d vector3d2 = this.louver == null ? null : Util3D.xform(matrix4d, this.louver);
            return new VentGeom(aARectangle, vector3d, unitPoint3D, vector3d2, this.radius);
        }

        @Override
        public Collection<? extends IHandle> generateManipHandles() {
            Collection<? extends IHandle> collection = super.generateManipHandles();
            ArrayList<? extends IHandle> arrayList = new ArrayList<IHandle>(collection);
            arrayList.add(new NormalHandle(this));
            return arrayList;
        }

        private static class NormalHandle
        implements IHandle {
            private VentGeom geom;

            public NormalHandle(VentGeom ventGeom) {
                this.geom = ventGeom;
            }

            public boolean equals(Object object) {
                return object instanceof NormalHandle;
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return null;
            }

            protected Point3d getMidPoint() {
                AABox aABox = this.geom.getBoundingBox(new AABox());
                Point3d point3d = aABox.getMin();
                Point3d point3d2 = aABox.getMax();
                return Util3D.getMidPoint(point3d, point3d2);
            }

            @Override
            public IGeomNode getGeom() {
                return GeomNodeUtil.newNode(new Point(this.getLocation()));
            }

            protected Point3d getLocation() {
                Point3d point3d = this.getMidPoint();
                Vector3d vector3d = this.geom.normal;
                if (vector3d != null) {
                    Vector3d vector3d2 = new Vector3d(vector3d);
                    vector3d2.scale(this.getNormalDistFromCenter());
                    point3d.add(vector3d2);
                }
                return point3d;
            }

            @Override
            public ISnapConstraint getConstraint(Point3d point3d) {
                return new LineConstraint(point3d, this.geom.getNormal(true));
            }

            @Override
            public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
            }

            @Override
            public VentGeom modify(Point3d point3d) throws ManipException {
                Vector3d vector3d = this.geom.getNormal(true);
                Point3d point3d2 = this.getMidPoint();
                double d = Util3D.tOnLine(point3d2, vector3d, point3d);
                Vector3d vector3d2 = Math.abs(d) < this.getNormalDistFromCenter() * 0.5 ? null : Util3D.scale(vector3d, Math.signum(d));
                this.geom = new VentGeom(this.geom, vector3d2, this.geom.centerPoint, this.geom.louver, this.geom.radius);
                return this.geom;
            }

            @Override
            public Object end() {
                return this.geom;
            }

            public double getNormalDistFromCenter() {
                return Vent.getNormalDistFromCenter(this.geom.getBoundingBox(new AABox()));
            }
        }
    }
}

