/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.io.Serializable;
import javax.vecmath.Point3d;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.theUtil;

public class TexOrigin
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final UnitPoint3D DEF_LOC = Geometry.UP3D_ZERO;
    public static final TexOrigin DEF_WORLD = new TexOrigin(DEF_LOC, false);
    public static final TexOrigin DEF_LOCAL = new TexOrigin(DEF_LOC, true);
    private final UnitPoint3D d_loc;
    private final boolean d_relativeToObj;

    public TexOrigin(UnitPoint3D unitPoint3D, boolean bl) {
        this.d_loc = unitPoint3D;
        this.d_relativeToObj = bl;
    }

    public static TexOrigin defaultWorld() {
        return DEF_WORLD;
    }

    public static TexOrigin defaultLocal() {
        return DEF_LOCAL;
    }

    public static TexOrigin getAbsolute(Point3d point3d) {
        return point3d.x == 0.0 && point3d.y == 0.0 && point3d.z == 0.0 ? DEF_WORLD : new TexOrigin(new UnitPoint3D(point3d, Geometry.LU), false);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TexOrigin)) {
            return false;
        }
        TexOrigin texOrigin = (TexOrigin)object;
        return this.d_relativeToObj == texOrigin.d_relativeToObj && this.d_loc.equals(texOrigin.d_loc);
    }

    public int hashCode() {
        return theUtil.hashCode(this.d_relativeToObj) + this.d_loc.hashCode();
    }

    public TexOrigin toWorld(IPyroGeomSrc iPyroGeomSrc) {
        if (!this.d_relativeToObj) {
            return this;
        }
        return new TexOrigin(this.getWorld(iPyroGeomSrc), false);
    }

    public UnitPoint3D getLocal() {
        return this.d_loc;
    }

    public UnitPoint3D getWorld(IPyroGeomSrc iPyroGeomSrc) {
        return this.getWorld(iPyroGeomSrc.getGeom());
    }

    public UnitPoint3D getWorld(IGeomNode iGeomNode) {
        if (this.d_relativeToObj) {
            AABox aABox = new AABox();
            iGeomNode.getBoundingBox(aABox);
            return this.d_loc.add(new UnitPoint3D(aABox.getMin(), Geometry.LU));
        }
        return this.d_loc;
    }

    public boolean isRelativeToObj() {
        return this.d_relativeToObj;
    }
}

