/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.domain.Composite;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.geom.AFDSObject;
import pyrosim.domain.particle.ConstColoring;
import pyrosim.domain.particle.IColoring;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.rasterization.IFDSObjProps;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.BlockGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class PartCloud
extends AFDSObject
implements IDirectDependent,
ICustomFDSPropsContainer {
    static final long serialVersionUID = 1L;
    private static final int VOLUME_ALPHA = 51;
    private static final Color DEF_COLOR = new Color(0.7f, 0.7f, 0.9f, 0.2f);
    private IGeom d_geom;
    private Particle d_particle;
    private IDropletCount d_initDropCount;
    private IInsertion d_insertion;
    private UnitDouble d_density;
    public static final Composite.IObjectProp insertionProp;
    public static final Composite.IObjectProp initDropsProp;
    public static final Composite.IObjectProp partProp;

    public PartCloud() {
        this(Intl.intl("Particle Cloud"), null, new AABoxGeom(GeomConstants.PNT3D_ORIGIN, GeomConstants.PNT3D_ORIGIN, 0));
    }

    public PartCloud(String string, Particle particle, IGeom iGeom) {
        super(string);
        this.d_geom = iGeom;
        this.d_particle = particle;
        this.d_initDropCount = new DropDensityCount();
        this.d_insertion = new InsertOnce();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof PartCloud)) {
            return false;
        }
        PartCloud partCloud = (PartCloud)object;
        return this.d_initDropCount.equals(partCloud.getInitDrops()) && this.d_particle.equals(partCloud.getParticle()) && this.d_insertion.equals(partCloud.d_insertion) && this.getCustomFDSProps().equals(partCloud.getCustomFDSProps());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_density != null) {
            this.d_insertion = new InsertOnce(this.d_density);
            this.d_density = null;
        }
    }

    @Override
    public void getCustomFDSTypes(Collection<String> collection) {
        collection.add("INIT");
    }

    @Override
    public boolean isControllable() {
        return true;
    }

    public Particle getParticle() {
        return this.d_particle;
    }

    public void setParticle(Particle particle) {
        this.d_particle = particle;
        this.changedEvt(new Object[0]);
    }

    public IDropletCount getInitDrops() {
        return this.d_initDropCount;
    }

    public void setInitDrops(IDropletCount iDropletCount) {
        this.d_initDropCount = iDropletCount;
        this.changedEvt(new Object[0]);
    }

    public IInsertion getInsertion() {
        return this.d_insertion;
    }

    public void setInsertion(IInsertion iInsertion) {
        this.d_insertion = iInsertion;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void setColors(Color ... colorArray) {
    }

    @Override
    public Color[] getColors() {
        return this.getColors(this.getPartCloudGeom());
    }

    public Color[] getColors(IGeom iGeom) {
        Color color = DEF_COLOR;
        if (this.d_particle != null) {
            color = this.d_particle.getDefaultColor();
            IColoring iColoring = this.d_particle.getColoring();
            if (iColoring != null && iColoring instanceof ConstColoring) {
                color = ((ConstColoring)iColoring).color;
            }
        }
        if (!(iGeom instanceof Point)) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 51);
        }
        return new Color[]{color};
    }

    @Override
    public IFDSObjProps getFragGenerator() {
        return null;
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        super.takeDepSnapshot(depList);
        depList.add(DLink.STRONG, (IPyroObject)this.d_particle);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t == this.d_particle) {
            Util.keepIfNullOr(set, Particle.class);
        } else {
            super.removeInvalidReplacements(t, set);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (!(iPyroObject instanceof Particle)) {
            return super.taskReplaceDep(iPyroObject, iPyroObject2);
        }
        assert (iPyroObject2 != null);
        return new AReplaceRefTask<Particle>((Object)iPyroObject, (Object)iPyroObject2){

            @Override
            protected void set(Particle particle) {
                PartCloud.this.setParticle(particle);
            }
        };
    }

    @Override
    public Task taskUpdateDep(IPyroObject iPyroObject, Collection<Object> collection) {
        if (!(iPyroObject instanceof Particle)) {
            return super.taskUpdateDep(iPyroObject, collection);
        }
        return GeomUtil.taskChanged(this);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        IGeom iGeom = this.getPartCloudGeom();
        Color[] colorArray = this.getColors(iGeom);
        IPrimProps.AProps aProps = iGeom instanceof Point ? new IPrimProps.Vertex(colorArray[0], 10.0) : new IPrimProps.Face(colorArray[0], null, 2);
        return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(iGeom), (IPrimProps)aProps);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getPartCloudGeom());
    }

    public IGeom getPartCloudGeom() {
        if (this.d_geom instanceof AABoxGeom && !(this.d_geom instanceof BlockGeom)) {
            AABoxGeom aABoxGeom = (AABoxGeom)this.d_geom;
            return new BlockGeom(aABoxGeom.min, aABoxGeom.max, 0);
        }
        return this.d_geom;
    }

    @Override
    public void setGeom(IGeomNode iGeomNode) {
        this.setGeom(iGeomNode.flatten().getLocalGeom());
    }

    public void setGeom(IGeom iGeom) {
        if (this.getGeomTypeFilter().test(iGeom.getClass())) {
            this.d_geom = iGeom;
            this.changedEvt(new Object[0]);
        }
    }

    public Predicate<Class<? extends IGeom>> getGeomTypeFilter() {
        return clazz -> Point.class.isAssignableFrom((Class<?>)clazz) || AABoxGeom.class.isAssignableFrom((Class<?>)clazz);
    }

    public UnitDouble getVolume() {
        AABox aABox = this.d_geom.getBoundingBox(new AABox());
        double d = aABox.getWidth();
        double d2 = aABox.getDepth();
        double d3 = aABox.getHeight();
        return new UnitDouble(d * d2 * d3, SIUS.unit(56));
    }

    static {
        TVEntryPoint.registerReferencedUpdateTypes(Particle.class);
        insertionProp = new Composite.AObjectProp<PartCloud, IInsertion>(PartCloud.class){

            @Override
            public void set(PartCloud partCloud, IInsertion iInsertion) {
                partCloud.setInsertion(iInsertion);
            }

            @Override
            public Object get(PartCloud partCloud) {
                return partCloud.getInsertion();
            }
        };
        initDropsProp = new Composite.AObjectProp<PartCloud, IDropletCount>(PartCloud.class){

            @Override
            public void set(PartCloud partCloud, IDropletCount iDropletCount) {
                partCloud.setInitDrops(iDropletCount);
            }

            @Override
            public Object get(PartCloud partCloud) {
                return partCloud.getInitDrops();
            }
        };
        partProp = new Composite.AObjectProp<PartCloud, Particle>(PartCloud.class){

            @Override
            public void set(PartCloud partCloud, Particle particle) {
                partCloud.setParticle(particle);
            }

            @Override
            public Object get(PartCloud partCloud) {
                return partCloud.getParticle();
            }

            @Override
            public boolean equal(Particle particle, Particle particle2) {
                return particle == particle2;
            }
        };
    }

    public static class InsertPeriodically
    implements IInsertion {
        private static final long serialVersionUID = 1L;
        public final UnitDouble dt;
        public final UnitDouble massPerTime;

        public InsertPeriodically() {
            this(new UnitDouble(0.01, SI.SECOND), SIUS.newud(1.0, 76));
        }

        public InsertPeriodically(UnitDouble unitDouble, UnitDouble unitDouble2) {
            this.dt = unitDouble;
            this.massPerTime = unitDouble2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof InsertPeriodically)) {
                return false;
            }
            InsertPeriodically insertPeriodically = (InsertPeriodically)object;
            return this.dt.equals(insertPeriodically.dt) && theUtil.equal(this.massPerTime, insertPeriodically.massPerTime);
        }
    }

    public static class InsertOnce
    implements IInsertion {
        private static final long serialVersionUID = 1L;
        public final UnitDouble massPerVolume;

        public InsertOnce() {
            this(SIUS.newud(1.0, 4));
        }

        public InsertOnce(UnitDouble unitDouble) {
            this.massPerVolume = unitDouble;
        }

        public boolean equals(Object object) {
            return object instanceof InsertOnce && theUtil.equal(((InsertOnce)object).massPerVolume, this.massPerVolume);
        }
    }

    public static interface IInsertion
    extends Serializable {
    }

    public static class DropDensityCount
    implements IDropletCount {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_density;

        public DropDensityCount() {
            this(SIUS.newud(10.0, 55));
        }

        public DropDensityCount(UnitDouble unitDouble) {
            this.d_density = unitDouble;
        }

        @Override
        public int getNumDrops(PartCloud partCloud) {
            double d = partCloud.getVolume().getValue(SIUS.unit(56));
            double d2 = this.d_density.getValue(SIUS.unit(55));
            return (int)Math.round(d * d2);
        }

        public boolean equals(Object object) {
            if (!(object instanceof DropDensityCount)) {
                return false;
            }
            DropDensityCount dropDensityCount = (DropDensityCount)object;
            return this.d_density.equals(dropDensityCount.d_density);
        }
    }

    public static class PerCellCount
    implements IDropletCount {
        static final long serialVersionUID = 1L;
        public final int partPerCell;
        public final boolean cellCentered;

        public PerCellCount() {
            this(1, false);
        }

        public PerCellCount(int n, boolean bl) {
            this.partPerCell = n;
            this.cellCentered = bl;
        }

        public boolean equals(Object object) {
            if (!(object instanceof PerCellCount)) {
                return false;
            }
            PerCellCount perCellCount = (PerCellCount)object;
            return this.partPerCell == perCellCount.partPerCell && this.cellCentered == perCellCount.cellCentered;
        }

        @Override
        public int getNumDrops(PartCloud partCloud) {
            return 0;
        }
    }

    public static class ConstDropletCount
    implements IDropletCount {
        static final long serialVersionUID = 1L;
        public final int d_dropCount;

        public ConstDropletCount() {
            this(100);
        }

        public ConstDropletCount(int n) {
            this.d_dropCount = n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ConstDropletCount)) {
                return false;
            }
            ConstDropletCount constDropletCount = (ConstDropletCount)object;
            return this.d_dropCount == constDropletCount.d_dropCount;
        }

        @Override
        public int getNumDrops(PartCloud partCloud) {
            return this.d_dropCount;
        }
    }

    public static interface IDropletCount
    extends Serializable {
        public int getNumDrops(PartCloud var1);
    }
}

