/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import pyrosim.PyroMod;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.PyroDisplayGeom;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.SkipDep;
import pyrosim.domain.geom.AFDSObject;
import pyrosim.domain.geom.FDSUtil;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.domain.rasterization.FaceProps;
import pyrosim.domain.rasterization.IFDSObjProps;
import pyrosim.domain.rasterization.IFragGenerator;
import pyrosim.domain.rasterization.ObstFragGenerator;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.geom.IPyroDisplayProps;
import pyrosim.geom.TexCoordGenerator;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.util.LWArray;
import pyrosim.util.Util;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.nmt.BooleanOp;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.nmt.NmtUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.SolidGeom;
import thunderheadeng.geometry.objs.elem.ElementBuilder;
import thunderheadeng.geometry.objs.elem.ElementBuilders;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.ElementPoly;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.ElementsBuilder;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.DisplayGeomBuilder;
import thunderheadeng.scene3d.geom.FlattenedProps;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.PlanarCoordMapper;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.Task;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.theUtil;

public class Obstruction
extends AFDSObject
implements IObstruction {
    static final long serialVersionUID = 1L;
    private static final int DEF_FLAGS = -2147483556;
    private Object d_geom;
    private Object d_surfaces;
    @Deprecated
    private Object d_texMapper;
    @SkipDep
    private TexOrigin d_texOrigin;
    @SkipDep
    private UnitDouble d_bulkDensity;
    private transient Integer d_cachedNumFaces = null;
    private static final int CREASEID = 0x7FFFFFFD;
    private static final int NOCREASEID = 0x7FFFFFFC;
    private static final Predicate<Surface> s_surfFilter = new Predicate<Surface>(){

        @Override
        public boolean test(Surface surface) {
            return !surface.isPredefined(PredefSurf.OPEN) && !surface.isPredefined(PredefSurf.MIRROR) && !surface.isPredefined(PredefSurf.HVAC) && !surface.isPredefined(PredefSurf.PERIODIC);
        }
    };

    public Obstruction(String string, IGeomNode iGeomNode, Surface[] surfaceArray) {
        super(string);
        this.d_geom = iGeomNode;
        this.d_surfaces = LWArray.newArray(surfaceArray);
        this.d_texOrigin = TexOrigin.defaultWorld();
        this.d_bulkDensity = null;
        this.setOptions(92, true);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl;
        objectInputStream.defaultReadObject();
        boolean bl2 = bl = PyroSimObjectInputStream.getVersion(objectInputStream) < 87;
        if (bl) {
            IElemSource iElemSource = (IElemSource)this.d_texMapper;
            this.d_texMapper = null;
            if (this.d_geom instanceof IGeom) {
                this.d_geom = GeomNodeUtil.newNode((IGeom)this.d_geom, Elements.NONE);
            } else assert (this.d_geom instanceof IGeomNode);
            if (iElemSource != Elements.NO_UV) {
                IElemSource iElemSource3 = iElemSource;
                this.d_geom = ((IGeomNode)this.d_geom).applyUVElements("uvset", (n, iElemSource2) -> iElemSource3.getPrimSource((int)n));
            }
            this.d_geom = ((IGeomNode)this.d_geom).prune();
        }
    }

    @Override
    public Object clone() {
        Obstruction obstruction = (Obstruction)super.clone();
        Surface[] surfaceArray = this.getSurfaces();
        obstruction.d_surfaces = LWArray.newArray(surfaceArray);
        return obstruction;
    }

    @Override
    public void getCustomFDSTypes(Collection<String> collection) {
        collection.add("OBST");
    }

    @Override
    public boolean isControllable() {
        return true;
    }

    @Override
    public UnitDouble getBulkDensity() {
        return this.d_bulkDensity;
    }

    @Override
    public void setBulkDensity(UnitDouble unitDouble) {
        if (theUtil.equal(unitDouble, this.d_bulkDensity)) {
            return;
        }
        this.d_bulkDensity = unitDouble;
        this.changedEvt(new Object[0]);
    }

    private static int filterOptions(int n) {
        return n & 0xFD;
    }

    @Override
    public void setOptions(int n, boolean bl) {
        this.setFlags(Obstruction.filterOptions(n), bl, new Object[0]);
    }

    @Override
    public boolean getOptions(int n) {
        return this.testFlags(Obstruction.filterOptions(n));
    }

    @Override
    public int getSetOptions() {
        return Obstruction.filterOptions(super.getSetFlags());
    }

    @Override
    public TexOrigin getTextureOrigin() {
        return this.d_texOrigin;
    }

    @Override
    public void setTextureOrigin(TexOrigin texOrigin) {
        if (this.d_texOrigin.equals(texOrigin)) {
            return;
        }
        this.d_texOrigin = texOrigin;
        this.changedEvt(new Object[0]);
    }

    @Override
    public int getNumFaces() {
        if (this.d_cachedNumFaces == null) {
            this.d_cachedNumFaces = this.getGeom().getNumPrims(1);
        }
        return this.d_cachedNumFaces;
    }

    @Override
    public IFDSObjProps getFragGenerator() {
        return new FragGen();
    }

    @Override
    public List<Pair<IObstruction, IHole>> intersectHoles(Supplier<Collection<? extends IHole>> supplier) {
        if (this.getDomain() == null) {
            return Collections.emptyList();
        }
        ArrayList<Pair<IObstruction, IHole>> arrayList = new ArrayList<Pair<IObstruction, IHole>>();
        BiConsumer<IHole, DisplayGeom> biConsumer = (iHole, displayGeom) -> {
            int n = displayGeom.node.getNumPrims(1);
            if (n == 0) {
                return;
            }
            Obstruction obstruction = (Obstruction)this.clone();
            obstruction.setGeom(displayGeom.node);
            Pair<Surface[], Color[]> pair = GeomUtil.getSurfsAndColors(n, displayGeom.props);
            obstruction.setSurfaces((Surface[])pair.v1);
            obstruction.setColors((Color[])pair.v2);
            arrayList.add(new Pair<Obstruction, IHole>(obstruction, (IHole)iHole));
        };
        DisplayGeom displayGeom2 = this.constructIsectDisplay(supplier, biConsumer, () -> this.getDisplayProps(true), iPropsSrc -> this.getInnerProps((PyroMod)this.getDomain(), (IPropsSrc)iPropsSrc, true));
        if (displayGeom2 == null) {
            return Collections.EMPTY_LIST;
        }
        biConsumer.accept(null, displayGeom2);
        return arrayList;
    }

    @Override
    public DisplayGeom getDisplayGeom(PyroMod pyroMod, IDisplayProps iDisplayProps) {
        Object object;
        IPyroDisplayProps iPyroDisplayProps = iDisplayProps instanceof IPyroDisplayProps ? (IPyroDisplayProps)iDisplayProps : null;
        DisplayGeom displayGeom = FDSUtil.getRastDisplay(iPyroDisplayProps, this, this.getTextureOrigin());
        if (displayGeom == null) {
            object = iPyroDisplayProps != null ? iPyroDisplayProps.getHoleFilter() : Filters.alwaysTrue();
            Supplier<Collection<IHole>> supplier = pyroMod != null && !Filters.alwaysFalse(object) ? () -> this.lambda$getDisplayGeom$297(pyroMod, (Predicate)object) : () -> Collections.emptyList();
            IPropsSrc iPropsSrc2 = this.getDisplayProps();
            if (pyroMod != null) {
                displayGeom = this.constructIsectDisplay(supplier, null, () -> iPropsSrc2, iPropsSrc -> this.getInnerProps(pyroMod, (IPropsSrc)iPropsSrc, false));
            }
            if (displayGeom == null) {
                IGeomNode iGeomNode = FDSUtil.finalizeUVElements(this.getGeom(), this.d_texOrigin);
                displayGeom = new DisplayGeom(iGeomNode, iPropsSrc2);
            }
        }
        object = this.getInnerProps(pyroMod, displayGeom.props, false);
        int n = 0;
        if (this.getOptions(32)) {
            n |= 1;
        }
        displayGeom = new PyroDisplayGeom(displayGeom, (IPrimProps)object, n);
        return displayGeom;
    }

    protected IPrimProps getInnerProps(PyroMod pyroMod, IPropsSrc iPropsSrc, boolean bl) {
        if (iPropsSrc instanceof UniformProps) {
            return iPropsSrc.get(0);
        }
        if (pyroMod != null) {
            Surface surface = pyroMod.getSurfaceMgr().get(PredefSurf.INERT);
            Color color = bl ? null : surface.getColor();
            return new IPrimProps.Face(color, surface, 0);
        }
        return new IPrimProps.Face(Color.BLACK, null, 0);
    }

    private DisplayGeom constructIsectDisplay(Supplier<Collection<? extends IHole>> supplier, BiConsumer<IHole, DisplayGeom> biConsumer, Supplier<IPropsSrc> supplier2, Function<IPropsSrc, IPrimProps> function) {
        if (this.getOptions(4)) {
            try {
                Collection<? extends IHole> collection = supplier.get();
                if (!collection.isEmpty()) {
                    IGeomNode iGeomNode;
                    IPropsSrc iPropsSrc = supplier2.get();
                    IPrimProps iPrimProps = function.apply(iPropsSrc);
                    ArrayList<HoleInfo> arrayList = new ArrayList<HoleInfo>(collection.size());
                    for (IHole object2 : collection) {
                        arrayList.add(new HoleInfo(object2, GeomUtil.flatten(object2.getGeom())));
                    }
                    PlanarCoordMapper planarCoordMapper = TexCoordGenerator.newGenerator(this.getGeom(), this.d_texOrigin);
                    DisplayGeom displayGeom = Obstruction.subtractHoles(planarCoordMapper, iGeomNode = FDSUtil.finalizeUVElements(this.getGeom(), this.d_texOrigin), iPropsSrc, 0, arrayList, iPrimProps, biConsumer);
                    if (displayGeom != null) {
                        return displayGeom;
                    }
                }
            }
            catch (Throwable throwable) {
                System.err.printf("Error subtracting holes: obst=%s%n", this.getName());
                throwable.printStackTrace();
            }
        }
        return null;
    }

    private static Model toModel(TransformInfo transformInfo, IGeom iGeom, Map<IPrimProps, Integer> map, IPropsSrc iPropsSrc, int n2, IPropertySet iPropertySet, int n3) {
        Model model = new Model();
        List list = GeomUtil.explode(iGeom.transform(transformInfo, 0), IFace.class);
        int n4 = list.size();
        IPropertySet iPropertySet2 = Elements.newElements();
        iPropertySet2.setIfNotDefault(Elements.CREASE, ((IElemSource)((Object)iPropertySet.get(Elements.CREASE))).subset(n3, n4));
        iPropertySet2.setIfNotDefault(Elements.ORIENT, ((IElemSource)((Object)iPropertySet.get(Elements.ORIENT))).subset(n3, n4));
        Elements.transformEq(iPropertySet2, transformInfo);
        IElemSource iElemSource = (IElemSource)((Object)iPropertySet2.get(Elements.CREASE));
        IElemSource iElemSource2 = (IElemSource)((Object)iPropertySet2.get(Elements.ORIENT));
        IPropsSrc iPropsSrc2 = iPropsSrc.subset(n2, n4);
        Iterator<IPrimProps> iterator = iPropsSrc2.iterator();
        int[] nArray = new int[]{0x7FFFFFFD};
        int[] nArray2 = new int[]{0x7FFFFFFC};
        ArrayList arrayList = new ArrayList();
        Point3d[][] point3dArray = new Point3d[1][3];
        Function<IPrimProps, Integer> function = iPrimProps -> map.size();
        Elements.processPolys(list, (list2, n, bl) -> {
            int n2 = list2.size();
            if (bl.booleanValue()) {
                List<Boolean> list3 = iElemSource.subset((int)n, n2).generate(Boolean.class, (List<IPolygon>)list2, iElemSource2.subset((int)n, n2), iPropsSrc2.subset((int)n, n2));
                Iterator<Boolean> iterator2 = list3.iterator();
                for (IFace iFace : list2) {
                    IPrimProps iPrimProps = (IPrimProps)iterator.next();
                    Integer n3 = (Integer)map.computeIfAbsent(iPrimProps, function);
                    IPolygon iPolygon = (IPolygon)iFace;
                    Point3d[][] point3dArray2 = PolyUtil.getLoops(iPolygon, false);
                    int n4 = PolyUtil.getNumVerts(iPolygon);
                    arrayList.clear();
                    for (int i = 0; i < n4; ++i) {
                        boolean bl2 = iterator2.next();
                        arrayList.add(bl2 ? nArray : nArray2);
                    }
                    model.addPolygonFace(iPolygon.getPlane(true), point3dArray2, new int[]{n3}, arrayList);
                }
            } else {
                int n5 = n;
                for (IFace iFace : list2) {
                    IPrimProps iPrimProps = (IPrimProps)iterator.next();
                    Integer n6 = (Integer)map.computeIfAbsent(iPrimProps, function);
                    Mesh mesh = iFace.triangulate(0.1);
                    ElementMesh<Boolean> elementMesh = iElemSource.getPrimSource(n5).generate(Boolean.class, iFace, (Elements.Orient)((Object)((Object)iElemSource2.getPrimElement(n5))), mesh, iPrimProps);
                    Iterator<Boolean> iterator3 = elementMesh.iterator();
                    for (int i = 0; i < mesh.indices.length; i += 3) {
                        arrayList.clear();
                        for (int j = 0; j < 3; ++j) {
                            point3dArray[0][j] = mesh.vertices[mesh.indices[i + j]];
                            arrayList.add(iterator3.next() != false ? nArray : nArray2);
                        }
                        model.addPolygonFace(new Plane3d(true, point3dArray[0]), point3dArray, new int[]{n6}, arrayList);
                    }
                    ++n5;
                }
            }
        });
        return model;
    }

    /*
     * WARNING - void declaration
     */
    private static DisplayGeom subtractHoles(IElemSource<Point2d> iElemSource, IGeomNode iGeomNode, IPropsSrc iPropsSrc, int n, List<HoleInfo> list, IPrimProps iPrimProps, BiConsumer<IHole, DisplayGeom> biConsumer) {
        void var12_16;
        void var14_24;
        Object object;
        int n2;
        Object object2;
        Object object3;
        void var14_21;
        int n3 = n;
        DisplayBuilder displayBuilder = new DisplayBuilder(iGeomNode, iPropsSrc, n3);
        TransformInfo transformInfo = iGeomNode.getLocalTransform().getInfo();
        int n4 = 0;
        for (IGeom serializable2 : displayBuilder.oldGeoms) {
            Obstruction.subtractHoles(transformInfo, serializable2, iPropsSrc, n, displayBuilder.oldElems, n4, list, iPrimProps, iElemSource, displayBuilder, biConsumer);
            int n5 = serializable2.getNumPrims(1);
            n += n5;
            n4 += n5;
        }
        int n6 = n - n3;
        ArrayList<IGeomNode> arrayList = new ArrayList<IGeomNode>(iGeomNode.getChildren().size());
        for (IGeomNode iGeomNode2 : iGeomNode.getChildren()) {
            arrayList.add(iGeomNode2.quickTransform(transformInfo));
        }
        Object object4 = null;
        boolean bl = false;
        while (var14_21 < arrayList.size()) {
            object3 = (IGeomNode)arrayList.get((int)var14_21);
            object2 = Obstruction.subtractHoles(iElemSource, (IGeomNode)object3, iPropsSrc, n, list, iPrimProps, biConsumer);
            int n7 = object3.getNumPrims(7);
            if (object2 != null) {
                if (object4 == null) {
                    object4 = new ArrayList();
                }
                object4.add((ModifiedChild)new ModifiedChild(((DisplayGeom)object2).node, ((DisplayGeom)object2).props, (int)var14_21, n, n7));
            }
            n += n7;
            ++var14_21;
        }
        if (!displayBuilder.isModified() && object4 == null) {
            return null;
        }
        object2 = new PropsBuilder();
        if (displayBuilder.isModified()) {
            ElementsBuilder elementsBuilder = new ElementsBuilder();
            for (n2 = 0; n2 < displayBuilder.geoms.size(); ++n2) {
                IGeom iGeom = displayBuilder.geoms.get(n2);
                int n8 = iGeom.getNumPrims(7);
                object = displayBuilder.props.get(n2);
                ((PropsBuilder)object2).add((IPropsSrc)object, n8);
                for (Map.Entry<Elements.ElemProp<?>, IElemSource<?>> entry : displayBuilder.elems.get(n2).entrySet()) {
                    elementsBuilder.add(entry.getKey(), entry.getValue(), n8);
                }
                for (Map.Entry<Object, IElemSource<Object>> entry : displayBuilder.uvElems.get(n2).entrySet()) {
                    elementsBuilder.addUV((String)entry.getKey(), entry.getValue(), n8);
                }
                elementsBuilder.next(n8);
            }
            object3 = elementsBuilder.finish();
            IGeom iGeom = thunderheadeng.geometry.objs.GeomUtil.group(displayBuilder.geoms);
        } else {
            IGeom iGeom = iGeomNode.getLocalGeom().transform(transformInfo, 0);
            object3 = Elements.transform(iGeomNode.getLocalElements(), transformInfo);
            ((PropsBuilder)object2).add(iPropsSrc.subset(n3, n6), n6);
        }
        if (object4 != null) {
            ArrayList arrayList2 = new ArrayList(arrayList.size());
            n2 = n3 + n6;
            int n9 = 0;
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                object = (ModifiedChild)iterator.next();
                arrayList2.addAll(arrayList.subList(n9, ((ModifiedChild)object).childIx));
                int n10 = ((ModifiedChild)object).propBegin - n2;
                ((PropsBuilder)object2).add(iPropsSrc.subset(n2, n10), n10);
                n2 += n10;
                arrayList2.add(((ModifiedChild)object).node);
                ((PropsBuilder)object2).add(((ModifiedChild)object).props, ((ModifiedChild)object).node.getNumPrims(7));
                n9 = ((ModifiedChild)object).childIx + 1;
                n2 += ((ModifiedChild)object).nSkippedProps;
            }
            arrayList2.addAll(arrayList.subList(n9, arrayList.size()));
            ((PropsBuilder)object2).add(iPropsSrc.subset(n2, n - n2), n - n2);
            ArrayList arrayList3 = arrayList2;
        } else {
            int n11 = n - n6 - n3;
            ((PropsBuilder)object2).add(iPropsSrc.subset(n3 + n6, n11), n11);
        }
        IGeomNode iGeomNode3 = GeomNodeUtil.newNode(TransformUtil.IDENTITY, (IGeom)var14_24, (IPropertySet)object3, (Collection<? extends IGeomNode>)var12_16);
        return new DisplayGeom(iGeomNode3, ((PropsBuilder)object2).finalizeProps());
    }

    private static void subtractHoles(TransformInfo transformInfo, IGeom iGeom2, IPropsSrc iPropsSrc2, int n, IPropertySet iPropertySet2, int n2, List<HoleInfo> list, IPrimProps iPrimProps, IElemSource<Point2d> iElemSource, DisplayBuilder displayBuilder, BiConsumer<IHole, DisplayGeom> biConsumer) {
        LinkedHashMap<IPrimProps, Integer> linkedHashMap = new LinkedHashMap<IPrimProps, Integer>();
        boolean bl = false;
        Model model = null;
        AABox aABox = transformInfo.getBounds(iGeom2, new AABox());
        boolean bl2 = !iGeom2.isShell();
        for (HoleInfo holeInfo : list) {
            DisplayGeomBuilder displayGeomBuilder = biConsumer != null ? new DisplayGeomBuilder() : null;
            for (Pair<TransformInfo, IGeom> pair : holeInfo.geom) {
                Model model2;
                boolean bl3;
                Containment containment = aABox.test(((TransformInfo)pair.v1).getBounds((IGeom)pair.v2, new AABox()));
                if (containment == Containment.OUTSIDE) continue;
                if (model == null) {
                    model = Obstruction.toModel(transformInfo, iGeom2, linkedHashMap, iPropsSrc2, n, iPropertySet2, n2);
                }
                bl2 = bl2 && model.getFaces().size() >= 4;
                Model model3 = Obstruction.toModel((TransformInfo)pair.v1, (IGeom)pair.v2, linkedHashMap, new UniformProps(iPrimProps), 0, Elements.NONE, 0);
                boolean bl4 = bl3 = !((IGeom)pair.v2).isShell() && model3.getFaces().size() >= 4;
                if (displayGeomBuilder == null) {
                    model2 = BooleanOp.subtract(model, bl2, model3, bl3);
                } else {
                    Pair<Model, Model> pair2 = BooleanOp.subtractAndIntersect(model, bl2, model3, bl3);
                    model2 = (Model)pair2.v1;
                    if (pair2.v2 != null) {
                        Obstruction.addDisplay((Model)pair2.v2, bl3, new PropertySet(), iElemSource, linkedHashMap, (iGeom, iPropertySet, iPropsSrc) -> displayGeomBuilder.add((IGeom)iGeom, (IPropsSrc)iPropsSrc, (IPropertySet)iPropertySet));
                    }
                }
                if (model2 == model || model2 == null) continue;
                model = model2;
                aABox = model.getBoundingBox();
                bl = true;
            }
            if (displayGeomBuilder == null) continue;
            biConsumer.accept(holeInfo.hole, displayGeomBuilder.finish().toDisplay());
        }
        if (bl) {
            assert (model != null);
            Obstruction.addDisplay(model, bl2, iPropertySet2, iElemSource, linkedHashMap, displayBuilder::add);
        } else {
            displayBuilder.skip();
        }
    }

    private static void addDisplay(Model model, boolean bl, IPropertySet iPropertySet, IElemSource<Point2d> iElemSource, Map<IPrimProps, Integer> map, TriConsumer<IGeom, IPropertySet, IPropsSrc> triConsumer) {
        Object object;
        Map.Entry<IPrimProps, Integer> entry22;
        IPrimProps[] iPrimPropsArray = new IPrimProps[map.size()];
        for (Map.Entry<IPrimProps, Integer> entry22 : map.entrySet()) {
            IPrimProps iPrimProps = entry22.getKey();
            if (iPrimProps.testOptions(2)) {
                iPrimProps = iPrimProps.setOptions(iPrimProps.getOptions() & 0xFFFFFFFD);
            }
            iPrimPropsArray[((Integer)entry22.getValue()).intValue()] = iPrimProps;
        }
        IPrimProps[] iPrimPropsArray2 = new IPrimProps[model.getFaces().size()];
        entry22 = new ArrayList(iPrimPropsArray2.length);
        int n = 0;
        ElementBuilder<Boolean> elementBuilder = ElementBuilders.crease();
        ArrayList arrayList = new ArrayList();
        for (Face cloneable2 : model.getFaces()) {
            arrayList.clear();
            object = GeomUtil.toPoly(cloneable2, nArray -> {
                boolean bl = NmtUtil.findGroup(nArray, 0x7FFFFFFD) || !NmtUtil.findGroup(nArray, 0x7FFFFFFC);
                arrayList.add(bl);
            });
            int string = cloneable2.groups[0];
            IPrimProps iPrimProps = iPrimPropsArray[string];
            iPrimPropsArray2[n++] = iPrimProps;
            entry22.add(object);
            elementBuilder.add(new ElementPoly<Boolean>(theUtil.toArray(arrayList, Boolean.class)), 1);
        }
        Object object2 = thunderheadeng.geometry.objs.GeomUtil.group((Collection<? extends IGeom>)((Object)entry22));
        if (bl) {
            object2 = new SolidGeom((IGeom)object2);
        }
        ListMap<String, IElemSource<Point2d>> listMap = new ListMap<String, IElemSource<Point2d>>();
        for (String string : iPropertySet.get(Elements.UV).keySet()) {
            listMap.put(string, iElemSource);
        }
        object = Elements.newElements();
        object.setIfNotDefault(Elements.UV, listMap);
        object.setIfNotDefault(Elements.CREASE, elementBuilder.finish());
        object = Elements.finalizeElements((IPropertySet)object);
        triConsumer.accept((IGeom)object2, (IPropertySet)object, new FlattenedProps(iPrimPropsArray2));
    }

    @Override
    public IGeomNode getGeom() {
        return (IGeomNode)this.d_geom;
    }

    @Override
    public void setGeom(IGeomNode iGeomNode) {
        if (this.d_geom == iGeomNode) {
            return;
        }
        assert (iGeomNode.getNumPrims(6) == 0) : "Geometry assigned to an obstruction should contain only faces.";
        this.d_geom = iGeomNode;
        this.d_cachedNumFaces = null;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void setSurfaces(Surface[] surfaceArray) {
        assert (surfaceArray.length == 1 || surfaceArray.length == this.getGeom().getNumPrims(1));
        this.d_surfaces = LWArray.newArray(surfaceArray);
        this.changedEvt(new Object[0]);
    }

    @Override
    public Surface[] getSurfaces() {
        return LWArray.toArray(this.d_surfaces, Surface.class);
    }

    public IPropsSrc getDisplayProps() {
        return this.getDisplayProps(false);
    }

    private IPropsSrc getDisplayProps(boolean bl) {
        Surface[] surfaceArray = this.getSurfaces();
        Color[] colorArray = this.getColors();
        int n = GeomUtil.isCullGeom(this.getGeom()) ? 2 : 0;
        BiFunction<Color, Surface, IPrimProps> biFunction = bl ? (color, surface) -> new IPrimProps.Face((Color)color, (IMaterial)surface, n) : (color, surface) -> FDSUtil.newObstFaceProps(color, surface, n);
        if (surfaceArray.length == 1 && colorArray.length == 1) {
            IPrimProps iPrimProps = biFunction.apply(colorArray[0], surfaceArray[0]);
            return new UniformProps(iPrimProps);
        }
        int n2 = Math.max(surfaceArray.length, colorArray.length);
        IPrimProps[] iPrimPropsArray = new IPrimProps[n2];
        for (int i = 0; i < n2; ++i) {
            Surface surface2 = surfaceArray.length == 1 ? surfaceArray[0] : surfaceArray[i];
            Color color2 = colorArray.length == 1 ? colorArray[0] : colorArray[i];
            iPrimPropsArray[i] = biFunction.apply(color2, surface2);
        }
        return new FlattenedProps(iPrimPropsArray);
    }

    @Override
    public Predicate<Surface> getSurfFilter() {
        return s_surfFilter;
    }

    public static Predicate<Surface> getSurfaceFilter() {
        return s_surfFilter;
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        super.takeDepSnapshot(depList);
        IPyroObject[] iPyroObjectArray = this.getSurfaces();
        depList.add(DLink.REQUIRED, iPyroObjectArray);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t instanceof Surface) {
            Util.keepIfNullOr(set, iPyroObject -> iPyroObject instanceof Surface && s_surfFilter.test((Surface)iPyroObject));
        } else {
            super.removeInvalidReplacements(t, set);
        }
    }

    @Override
    public Task taskUpdateDep(IPyroObject iPyroObject, Collection<Object> collection) {
        if (!(iPyroObject instanceof Surface) && Util.containsAny(collection, Surface.EVT_APPEARANCE, Surface.EVT_COLOR, EventChannel.EVT_GENERAL)) {
            return super.taskUpdateDep(iPyroObject, collection);
        }
        return GeomUtil.taskChanged(this);
    }

    @Override
    public Task taskReplaceDep(final IPyroObject iPyroObject, final IPyroObject iPyroObject2) {
        if (!(iPyroObject instanceof Surface)) {
            return super.taskReplaceDep(iPyroObject, iPyroObject2);
        }
        return new AUndoableTask(){
            private IGeomNode d_oldNode = null;
            private int[] d_ixes = null;

            @Override
            public void undo() {
                this.setData((Surface)iPyroObject, this.d_oldNode);
                this.d_ixes = null;
                this.d_oldNode = null;
            }

            private boolean keepUV() {
                Material material;
                if (iPyroObject == iPyroObject2) {
                    return true;
                }
                if (iPyroObject == null || iPyroObject2 == null) {
                    return false;
                }
                Surface surface = (Surface)iPyroObject;
                Surface surface2 = (Surface)iPyroObject2;
                Material material2 = surface.getAppearance();
                if (material2 == (material = surface2.getAppearance())) {
                    return true;
                }
                if (material2 == null || material == null) {
                    return false;
                }
                for (MatChannel matChannel : MatChannel.values()) {
                    Texture texture;
                    Texture texture2 = material2.getAttributes().getTexture(matChannel);
                    if (Objects.equals(texture2, texture = material2.getAttributes().getTexture(matChannel))) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void run() {
                boolean bl = this.keepUV();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                BitSet bitSet = new BitSet();
                Surface[] surfaceArray = Obstruction.this.getSurfaces();
                for (int i = 0; i < surfaceArray.length; ++i) {
                    if (surfaceArray[i] != iPyroObject) continue;
                    arrayList.add(i);
                    bitSet.set(i);
                }
                this.d_ixes = theUtil.toIntArray(arrayList);
                IGeomNode iGeomNode = this.d_oldNode = Obstruction.this.getGeom();
                if (!bl) {
                    iGeomNode = surfaceArray.length > 1 ? this.d_oldNode.applyUVElements((string, n, iElemSource) -> bitSet.get((int)n) ? FDSUtil.getDefaultTexMapper() : iElemSource) : this.d_oldNode.applyUniformProp(Elements.UV, FDSUtil.getDefaultTexMapperSets());
                }
                this.setData((Surface)iPyroObject2, iGeomNode);
            }

            private void setData(Surface surface, IGeomNode iGeomNode) {
                Surface[] surfaceArray = Obstruction.this.getSurfaces();
                Surface[] surfaceArray2 = (Surface[])surfaceArray.clone();
                for (int i = 0; i < this.d_ixes.length; ++i) {
                    surfaceArray2[this.d_ixes[i]] = surface;
                }
                Obstruction.this.pauseUpdates();
                Obstruction.this.setSurfaces(surfaceArray2);
                Obstruction.this.setGeom(iGeomNode);
                Obstruction.this.resumeUpdates();
            }
        };
    }

    private /* synthetic */ Collection lambda$getDisplayGeom$297(PyroMod pyroMod, Predicate predicate) {
        return theUtil.filter(pyroMod.getGeomProx().getNearObjs(this), IHole.class, predicate);
    }

    static {
        TVEntryPoint.registerReferencedUpdateTypes(Surface.class);
    }

    private static class DisplayBuilder {
        public final ITransform oldXform;
        public final List<IGeom> oldGeoms;
        public final IPropertySet oldElems;
        public final IPropsSrc oldProps;
        private int geomIx = 0;
        public List<IGeom> geoms = null;
        public List<Map<Elements.ElemProp<?>, IElemSource<?>>> elems = null;
        public List<Map<String, IElemSource<Point2d>>> uvElems = null;
        public List<IPropsSrc> props = null;

        public DisplayBuilder(IGeomNode iGeomNode, IPropsSrc iPropsSrc, int n) {
            this.oldXform = iGeomNode.getLocalTransform();
            this.oldGeoms = thunderheadeng.geometry.objs.GeomUtil.flatten(iGeomNode.getLocalGeom());
            this.oldElems = iGeomNode.getLocalElements();
            this.oldProps = iPropsSrc.subset(n, iGeomNode.getLocalGeom().getNumPrims(7));
        }

        public void add(IGeom iGeom, IPropertySet iPropertySet, IPropsSrc iPropsSrc) {
            int n;
            if (this.geoms == null) {
                this.geoms = new ArrayList<IGeom>(this.oldGeoms.size());
                assert (this.elems == null && this.props == null && this.uvElems == null);
                this.elems = new ArrayList(this.oldGeoms.size());
                this.uvElems = new ArrayList<Map<String, IElemSource<Point2d>>>(this.oldGeoms.size());
                this.props = new ArrayList<IPropsSrc>(this.oldGeoms.size());
                n = 0;
                TransformInfo transformInfo = this.oldXform.getInfo();
                IPropertySet iPropertySet2 = Elements.transform(this.oldElems, transformInfo);
                for (int i = 0; i < this.oldGeoms.size(); ++i) {
                    IGeom iGeom2 = this.oldGeoms.get(i).transform(transformInfo, 0);
                    this.geoms.add(iGeom2);
                    int n2 = iGeom2.getNumPrims(7);
                    this.props.add(this.oldProps.subset(n, n2));
                    this.elems.add(DisplayBuilder.toMap(iPropertySet2, n, n2));
                    this.uvElems.add(DisplayBuilder.toUVMap(iPropertySet2, n, n2));
                    n += n2;
                }
            }
            this.geoms.set(this.geomIx, iGeom);
            this.props.set(this.geomIx, iPropsSrc);
            n = iGeom.getNumPrims(7);
            this.elems.set(this.geomIx, DisplayBuilder.toMap(iPropertySet, 0, n));
            this.uvElems.set(this.geomIx, DisplayBuilder.toUVMap(iPropertySet, 0, n));
            ++this.geomIx;
        }

        private static Map<Elements.ElemProp<?>, IElemSource<?>> toMap(IPropertySet iPropertySet, int n, int n2) {
            HashMap hashMap = new HashMap();
            for (Elements.ElemProp<?> elemProp : Elements.FIXED) {
                hashMap.put(elemProp, ((IElemSource)iPropertySet.get(elemProp)).subset(n, n2));
            }
            return hashMap;
        }

        private static Map<String, IElemSource<Point2d>> toUVMap(IPropertySet iPropertySet, int n, int n2) {
            HashMap<String, IElemSource<Point2d>> hashMap = new HashMap<String, IElemSource<Point2d>>();
            for (Map.Entry<String, IElemSource<Point2d>> entry : iPropertySet.get(Elements.UV).entrySet()) {
                hashMap.put(entry.getKey(), entry.getValue().subset(n, n2));
            }
            return hashMap;
        }

        public void skip() {
            ++this.geomIx;
        }

        public boolean isModified() {
            return this.geoms != null;
        }
    }

    private static class ModifiedChild {
        public final IGeomNode node;
        public final IPropsSrc props;
        public final int childIx;
        public final int propBegin;
        public final int nSkippedProps;

        public ModifiedChild(IGeomNode iGeomNode, IPropsSrc iPropsSrc, int n, int n2, int n3) {
            this.node = iGeomNode;
            this.props = iPropsSrc;
            this.childIx = n;
            this.propBegin = n2;
            this.nSkippedProps = n3;
        }
    }

    private static class HoleInfo {
        public IHole hole;
        public final List<Pair<TransformInfo, IGeom>> geom;

        public HoleInfo(IHole iHole, List<Pair<TransformInfo, IGeom>> list) {
            this.hole = iHole;
            this.geom = list;
        }
    }

    private class FragGen
    implements IFDSObjProps {
        @Override
        public IFragGenerator getFragGenerator(RasterizationOptions rasterizationOptions) {
            return new ObstFragGenerator(Obstruction.this, rasterizationOptions);
        }

        @Override
        public FaceProps getFace(int n) {
            Surface[] surfaceArray = Obstruction.this.getSurfaces();
            Surface surface = surfaceArray.length > 1 ? surfaceArray[n] : surfaceArray[0];
            Color[] colorArray = Obstruction.this.getColors();
            Color color = colorArray.length == 1 ? colorArray[0] : colorArray[n];
            return new FaceProps(surface, color);
        }

        @Override
        public boolean thickenEnabled() {
            return Obstruction.this.getOptions(1);
        }
    }
}

