/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.geom.AFDSObject;
import pyrosim.domain.rasterization.IFDSObjProps;
import pyrosim.geom.Geometry;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.Util;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.BlockGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Task;

public class InitRegion
extends AFDSObject
implements IDirectDependent {
    static final long serialVersionUID = 1L;
    private static final int ALPHA = 51;
    private static final Color DEF_COLOR = new Color(0.3f, 0.7f, 0.9f, 0.2f);
    private AABoxGeom d_geom;
    private UnitDouble d_density;
    private UnitDouble d_temperature;
    private Map<ExSpec, UnitDouble> d_specMassFrac;
    private SpecFractionType d_specFracType;
    public static final Composite.IObjectProp densityProp = new Composite.AObjectProp<InitRegion, UnitDouble>(InitRegion.class){

        @Override
        public void set(InitRegion initRegion, UnitDouble unitDouble) {
            initRegion.setDensity(unitDouble);
        }

        @Override
        public Object get(InitRegion initRegion) {
            return initRegion.getDensity();
        }
    };
    public static final Composite.IObjectProp tempProp = new Composite.AObjectProp<InitRegion, UnitDouble>(InitRegion.class){

        @Override
        public void set(InitRegion initRegion, UnitDouble unitDouble) {
            initRegion.setTemperature(unitDouble);
        }

        @Override
        public Object get(InitRegion initRegion) {
            return initRegion.getTemperature();
        }
    };
    public static final Composite.IObjectProp specTypeProp = new Composite.AObjectProp<InitRegion, SpecFractionType>(InitRegion.class){

        @Override
        public void set(InitRegion initRegion, SpecFractionType specFractionType) {
            initRegion.setExtraSpeciesType(specFractionType);
        }

        @Override
        public Object get(InitRegion initRegion) {
            return initRegion.getExtraSpeciesType();
        }
    };

    public InitRegion() {
        this(Intl.intl("Init Region"), new AABoxGeom(GeomConstants.PNT3D_ORIGIN, GeomConstants.PNT3D_ORIGIN, 0));
    }

    public InitRegion(String string, AABoxGeom aABoxGeom) {
        super(string);
        this.d_geom = aABoxGeom.optimize(Geometry.P3D_POOL);
        this.d_density = null;
        this.d_temperature = null;
        this.d_specMassFrac = Collections.emptyMap();
        this.d_specFracType = SpecFractionType.MASS_FRACTION;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (!this.d_specMassFrac.isEmpty() && !(this.d_specMassFrac instanceof LinkedIdentityHashMap)) {
            this.d_specMassFrac = new LinkedIdentityHashMap<ExSpec, UnitDouble>(this.d_specMassFrac);
        }
        if (this.d_specFracType == null) {
            this.d_specFracType = SpecFractionType.MASS_FRACTION;
        }
    }

    @Override
    public Object clone() {
        InitRegion initRegion = (InitRegion)super.clone();
        if (initRegion.d_specMassFrac != Collections.EMPTY_MAP) {
            initRegion.d_specMassFrac = new LinkedIdentityHashMap<ExSpec, UnitDouble>(initRegion.d_specMassFrac);
        }
        return initRegion;
    }

    @Override
    public boolean isControllable() {
        return false;
    }

    @Override
    public void getCustomFDSTypes(Collection<String> collection) {
        collection.add("INIT");
    }

    @Override
    public void setColors(Color ... colorArray) {
    }

    @Override
    public Color[] getColors() {
        return new Color[]{DEF_COLOR};
    }

    public UnitDouble getDensity() {
        return this.d_density;
    }

    public void setDensity(UnitDouble unitDouble) {
        this.d_density = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getTemperature() {
        return this.d_temperature;
    }

    public void setTemperature(UnitDouble unitDouble) {
        this.d_temperature = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public Map<ExSpec, UnitDouble> getExtraSpecies() {
        return Collections.unmodifiableMap(this.d_specMassFrac);
    }

    public void setExtraSpeciesType(SpecFractionType specFractionType) {
        LinkedIdentityHashMap<ExSpec, UnitDouble> linkedIdentityHashMap = new LinkedIdentityHashMap<ExSpec, UnitDouble>();
        for (Map.Entry<ExSpec, UnitDouble> entry : this.d_specMassFrac.entrySet()) {
            UnitDouble unitDouble = entry.getValue();
            double d = unitDouble.getRawValue();
            UnitSystem unitSystem = PyroSim.getApp().getUnitSystem();
            Unit unit = unitSystem.getMassFractionUnit();
            if (specFractionType.equals((Object)SpecFractionType.VOLUME_FRACTION)) {
                unit = unitSystem.getVolumeFractionUnit();
            }
            UnitDouble unitDouble2 = new UnitDouble(d, unit);
            linkedIdentityHashMap.put(entry.getKey(), unitDouble2);
        }
        this.setExtraSpecies(linkedIdentityHashMap, specFractionType);
    }

    public SpecFractionType getExtraSpeciesType() {
        return this.d_specFracType;
    }

    public void setExtraSpecies(Map<ExSpec, UnitDouble> map, SpecFractionType specFractionType) {
        this.d_specMassFrac = map.isEmpty() ? Collections.EMPTY_MAP : map;
        this.d_specFracType = specFractionType;
        this.changedEvt(new Object[0]);
    }

    public void setSpecFrac(ExSpec exSpec, UnitDouble unitDouble) {
        if (unitDouble == null || unitDouble.getValueNoUnit() == 0.0) {
            if (this.d_specMassFrac.containsKey(exSpec)) {
                this.d_specMassFrac.remove(exSpec);
                if (this.d_specMassFrac.isEmpty()) {
                    this.d_specMassFrac = Collections.EMPTY_MAP;
                }
                this.changedEvt(new Object[0]);
            }
        } else {
            if (this.d_specMassFrac == Collections.EMPTY_MAP) {
                this.d_specMassFrac = new LinkedIdentityHashMap<ExSpec, UnitDouble>();
            }
            this.d_specMassFrac.put(exSpec, unitDouble);
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public IFDSObjProps getFragGenerator() {
        return null;
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        super.takeDepSnapshot(depList);
        depList.add(DLink.WEAK, this.d_specMassFrac.keySet());
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t instanceof ExSpec) {
            Util.keepIfNullOr(set, ExSpec.class);
        } else {
            super.removeInvalidReplacements(t, set);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (!(iPyroObject instanceof ExSpec)) {
            return super.taskReplaceDep(iPyroObject, iPyroObject2);
        }
        final ExSpec exSpec = (ExSpec)iPyroObject;
        final ExSpec exSpec2 = (ExSpec)iPyroObject2;
        return new AUndoableTask(){
            private UnitDouble d_oldVal;
            private UnitDouble d_replVal;

            @Override
            public void run() {
                assert (InitRegion.this.d_specMassFrac.containsKey(exSpec));
                this.d_oldVal = (UnitDouble)InitRegion.this.d_specMassFrac.remove(exSpec);
                if (exSpec2 != null) {
                    if (InitRegion.this.d_specMassFrac.containsKey(exSpec2)) {
                        this.d_replVal = (UnitDouble)InitRegion.this.d_specMassFrac.get(exSpec2);
                        InitRegion.this.d_specMassFrac.put(exSpec2, this.d_replVal.add(this.d_oldVal));
                    } else {
                        this.d_replVal = null;
                        InitRegion.this.d_specMassFrac.put(exSpec2, this.d_oldVal);
                    }
                } else if (InitRegion.this.d_specMassFrac.isEmpty()) {
                    InitRegion.this.d_specMassFrac = Collections.EMPTY_MAP;
                }
                InitRegion.this.changedEvt(new Object[0]);
            }

            @Override
            public void undo() {
                if (InitRegion.this.d_specMassFrac == Collections.EMPTY_MAP) {
                    InitRegion.this.d_specMassFrac = new LinkedIdentityHashMap();
                }
                InitRegion.this.d_specMassFrac.put(exSpec, this.d_oldVal);
                if (exSpec2 != null) {
                    if (this.d_replVal == null) {
                        InitRegion.this.d_specMassFrac.remove(exSpec2);
                    } else {
                        InitRegion.this.d_specMassFrac.put(exSpec2, this.d_replVal);
                    }
                }
                InitRegion.this.changedEvt(new Object[0]);
            }
        };
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        Color[] colorArray = this.getColors();
        return new DisplayGeom(this.getGeom(), (IPrimProps)new IPrimProps.Face(colorArray[0], null, 2));
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getBoxGeom());
    }

    public AABoxGeom getBoxGeom() {
        return this.d_geom instanceof BlockGeom ? this.d_geom : new BlockGeom(this.d_geom.min, this.d_geom.max, 0);
    }

    @Override
    public void setGeom(IGeomNode iGeomNode) {
        this.setGeom(iGeomNode.flatten().getLocalGeom());
    }

    public void setGeom(IGeom iGeom) {
        if (iGeom instanceof AABoxGeom) {
            this.d_geom = (AABoxGeom)iGeom;
            this.changedEvt(new Object[0]);
        }
    }

    public static class SpecFracProp
    extends Composite.AObjectProp<InitRegion, UnitDouble> {
        public ExSpec currSpec;

        public SpecFracProp() {
            super(InitRegion.class);
        }

        @Override
        public void set(InitRegion initRegion, UnitDouble unitDouble) {
            initRegion.setSpecFrac(this.currSpec, unitDouble);
        }

        @Override
        public Object get(InitRegion initRegion) {
            SpecFractionType specFractionType = initRegion.getExtraSpeciesType();
            int n = specFractionType.equals((Object)SpecFractionType.MASS_FRACTION) ? 18 : 87;
            UnitDouble unitDouble = (UnitDouble)initRegion.d_specMassFrac.get(this.currSpec);
            return unitDouble == null ? SIUS.newud(0.0, n) : unitDouble;
        }
    }

    public static enum SpecFractionType {
        MASS_FRACTION,
        VOLUME_FRACTION;

    }
}

