/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.geom.AFDSObject;
import pyrosim.domain.geom.FDSUtil;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.domain.rasterization.FaceProps;
import pyrosim.domain.rasterization.HoleFragGenerator;
import pyrosim.domain.rasterization.IFDSObjProps;
import pyrosim.domain.rasterization.IFragGenerator;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.geom.IPyroDisplayProps;
import pyrosim.io.PyroSimObjectInputStream;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.FlattenedProps;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.UniformProps;

public class Hole
extends AFDSObject
implements IHole {
    static final long serialVersionUID = 1L;
    public static final double ALPHA = 0.4;
    public static final Color DEF_COLOR = new Color(Color.GRAY.getRed(), Color.GRAY.getGreen(), Color.GRAY.getBlue(), 102);
    private Object d_geom;

    public Hole(String string, IGeomNode iGeomNode) {
        super(string);
        this.d_geom = iGeomNode;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl;
        objectInputStream.defaultReadObject();
        boolean bl2 = bl = PyroSimObjectInputStream.getVersion(objectInputStream) < 87;
        if (bl) {
            if (this.d_geom instanceof IGeom) {
                this.d_geom = GeomNodeUtil.newNode((IGeom)this.d_geom, Elements.NONE);
            } else assert (this.d_geom instanceof IGeomNode);
            this.d_geom = ((IGeomNode)this.d_geom).prune();
        }
    }

    @Override
    public void getCustomFDSTypes(Collection<String> collection) {
        collection.add("HOLE");
    }

    @Override
    public IFDSObjProps getFragGenerator() {
        return new FragGen();
    }

    @Override
    public boolean isControllable() {
        return true;
    }

    @Override
    public IGeomNode getGeom() {
        return (IGeomNode)this.d_geom;
    }

    @Override
    public void setGeom(IGeomNode iGeomNode) {
        if (iGeomNode == this.d_geom) {
            return;
        }
        this.d_geom = iGeomNode;
        this.changedEvt(new Object[0]);
    }

    private static IPrimProps toProps(Color color, boolean bl) {
        color = color == null ? DEF_COLOR : new Color(color.getRed(), color.getGreen(), color.getBlue(), 102);
        return new IPrimProps.Face(color, null, bl ? 2 : 0);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        IPropsSrc iPropsSrc;
        IPyroDisplayProps iPyroDisplayProps = iDisplayProps instanceof IPyroDisplayProps ? (IPyroDisplayProps)iDisplayProps : null;
        DisplayGeom displayGeom = FDSUtil.getRastDisplay(iPyroDisplayProps, this, TexOrigin.DEF_WORLD);
        if (displayGeom != null) {
            return displayGeom;
        }
        Color[] colorArray = this.getColors();
        boolean bl = GeomUtil.isCullGeom(this.getGeom());
        if (colorArray.length == 1) {
            iPropsSrc = new UniformProps(Hole.toProps(colorArray[0], bl));
        } else {
            IPrimProps[] iPrimPropsArray = new IPrimProps[colorArray.length];
            for (int i = 0; i < colorArray.length; ++i) {
                iPrimPropsArray[i] = Hole.toProps(colorArray[i], bl);
            }
            iPropsSrc = new FlattenedProps(iPrimPropsArray);
        }
        return new DisplayGeom(this.getGeom(), iPropsSrc);
    }

    private class FragGen
    implements IFDSObjProps {
        private FaceProps d_faceProps;

        private FragGen() {
            this.d_faceProps = new FaceProps(Hole.this.getColors()[0]);
        }

        @Override
        public FaceProps getFace(int n) {
            return this.d_faceProps;
        }

        @Override
        public IFragGenerator getFragGenerator(RasterizationOptions rasterizationOptions) {
            return new HoleFragGenerator(Hole.this, rasterizationOptions);
        }

        @Override
        public boolean thickenEnabled() {
            return true;
        }
    }
}

