/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.Unit;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;

public class FreePointLoc
implements Serializable {
    static final long serialVersionUID = 1L;
    public final IGeom d_geom;
    public final Vector3d d_orientation;
    public final UnitDouble d_rotation;
    @Deprecated
    public final int d_numPoints = 0;
    private static final Vector3d s_baseRotVec = new Vector3d(0.0, 0.0, -1.0);

    public FreePointLoc() {
        this(new Point(Geometry.UP3D_ZERO.getPoint3dValue(Geometry.LU)));
    }

    public FreePointLoc(IGeom iGeom) {
        this(iGeom, new Vector3d(0.0, 0.0, -1.0));
    }

    public FreePointLoc(IGeom iGeom, Vector3d vector3d) {
        this(iGeom, vector3d, new UnitDouble(0.0, NonSI.DEGREE_ANGLE));
    }

    public FreePointLoc(IGeom iGeom, Vector3d vector3d, UnitDouble unitDouble) {
        this.d_geom = iGeom;
        this.d_orientation = vector3d;
        this.d_rotation = unitDouble;
    }

    public FreePointLoc setGeom(IGeom iGeom) {
        return new FreePointLoc(iGeom, this.d_orientation, this.d_rotation);
    }

    public Matrix4d toTransform() {
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        if (!s_baseRotVec.equals(this.d_orientation)) {
            Vector3d vector3d = Util3D.cross(s_baseRotVec, this.d_orientation);
            double d = s_baseRotVec.angle(this.d_orientation);
            matrix4d.mul(Util.rotMat(vector3d.x, vector3d.y, vector3d.z, d));
        }
        return matrix4d;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FreePointLoc)) {
            return false;
        }
        FreePointLoc freePointLoc = (FreePointLoc)object;
        return this.d_geom.equals(freePointLoc.d_geom) && this.d_orientation.equals(freePointLoc.d_orientation) && this.d_rotation.equals(freePointLoc.d_rotation);
    }

    public int hashCode() {
        return 16851725 + this.d_geom.hashCode() + this.d_orientation.hashCode() + this.d_rotation.hashCode();
    }

    public void getBounds(AABox aABox, Unit unit) {
        this.d_geom.getBoundingBox(aABox);
    }

    public UnitAABox getBounds() {
        AABox aABox = new AABox();
        this.getBounds(aABox, Geometry.LU);
        return new UnitAABox(aABox, Geometry.LU);
    }

    public FreePointLoc transform(Matrix4d matrix4d) {
        IGeom iGeom = this.d_geom.transform(new TransformInfo(matrix4d), 1);
        return new FreePointLoc(iGeom, this.d_orientation, this.d_rotation);
    }
}

