/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.vecmath.Point2d;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.domain.rasterization.FDSObjectRasterization;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.domain.rasterization.FaceProps;
import pyrosim.geom.IPyroDisplayProps;
import pyrosim.geom.TexCoordGenerator;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.elem.ElementUniform;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.util.CachedSupplier;

public class FDSUtil {
    public static DisplayGeom getRastDisplay(IPyroDisplayProps iPyroDisplayProps, FDSObject fDSObject, TexOrigin texOrigin) {
        Serializable serializable2;
        if (iPyroDisplayProps == null || iPyroDisplayProps.getRasterizer() == null || !iPyroDisplayProps.getRasterizer().shouldRasterize(fDSObject)) {
            return null;
        }
        FDSRasterization fDSRasterization = iPyroDisplayProps.getRasterizer();
        FDSObjectRasterization fDSObjectRasterization = fDSRasterization.rasterize(fDSObject);
        if (fDSObjectRasterization == null) {
            return DisplayGeom.EMPTY;
        }
        ArrayList arrayList = new ArrayList(fDSObjectRasterization.geoms.length);
        PropsBuilder propsBuilder = new PropsBuilder();
        for (Serializable serializable2 : fDSObjectRasterization.geoms) {
            arrayList.add(serializable2.v1);
            if (((FaceProps[])serializable2.v2).length == 1) {
                IPrimProps iPrimProps = fDSObjectRasterization.fragGen.generateDisplayProps(((FaceProps[])serializable2.v2)[0]);
                int n = ((IGeom)serializable2.v1).getNumPrims(1);
                propsBuilder.add(iPrimProps, n);
                continue;
            }
            for (FaceProps faceProps : (FaceProps[])serializable2.v2) {
                propsBuilder.add(fDSObjectRasterization.fragGen.generateDisplayProps(faceProps));
            }
        }
        IPropsSrc iPropsSrc = propsBuilder.finalizeProps();
        GeomGroup geomGroup = new GeomGroup(arrayList);
        IGeomNode iGeomNode = GeomNodeUtil.newNode(geomGroup);
        serializable2 = TexCoordGenerator.newGenerator(iGeomNode, texOrigin);
        iGeomNode = iGeomNode.initUVElements((IElemSource<Point2d>)((Object)serializable2));
        return new DisplayGeom(iGeomNode, iPropsSrc);
    }

    public static Color resolveObstPropColor(Color color, Surface surface) {
        if (color != null || surface == null) {
            return color;
        }
        return surface.getColor();
    }

    public static IPrimProps.Face newObstFaceProps(Color color, Surface surface, int n) {
        assert (color != null || surface != null);
        Color color2 = FDSUtil.resolveObstPropColor(color, surface);
        if (surface.getAppearance() == null) {
            surface = null;
        }
        assert (color2 != null || surface != null);
        return new IPrimProps.Face(color2, surface, n);
    }

    public static boolean isDefaultTexMapper(IElemSource<Point2d> iElemSource) {
        return iElemSource == Elements.NO_UV || iElemSource instanceof ElementUniform && iElemSource.getPrimSource(0) == Elements.NO_UV;
    }

    public static IElemSource<Point2d> getDefaultTexMapper() {
        return Elements.NO_UV;
    }

    public static Map<String, IElemSource<Point2d>> getDefaultTexMapperSets() {
        return Collections.emptyMap();
    }

    public static IElemSource<Point2d> getUsableTexMapperPrim(IGeomNode iGeomNode, TexOrigin texOrigin) {
        return TexCoordGenerator.newGenerator(iGeomNode, texOrigin);
    }

    public static IGeomNode finalizeUVElements(IGeomNode iGeomNode, TexOrigin texOrigin) {
        CachedSupplier<IElemSource<Point2d>> cachedSupplier = new CachedSupplier<IElemSource<Point2d>>(() -> FDSUtil.getUsableTexMapperPrim(iGeomNode, texOrigin));
        IGeomNode iGeomNode2 = iGeomNode;
        iGeomNode2 = iGeomNode2.applyUVElements((string, n, iElemSource) -> iElemSource == Elements.NO_UV ? (IElemSource)cachedSupplier.get() : iElemSource);
        iGeomNode2 = iGeomNode2.applyDefaultUVElements(cachedSupplier);
        return iGeomNode2;
    }
}

