/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.vecmath.Point3d;
import junit.framework.TestCase;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.geom.AFDSObject;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.Obstruction;
import pyrosim.domain.geom.Vent;
import pyrosim.util.Util;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;

public class FDSObjectIteratorTest
extends TestCase {
    private IPyroObject[] d_array;
    private ModelComposite d_composite;

    private Obstruction createTestMember(String string) {
        SurfaceManager surfaceManager = new SurfaceManager();
        surfaceManager.addPredefined();
        Surface surface = surfaceManager.get(PredefSurf.INERT);
        AABoxGeom aABoxGeom = new AABoxGeom(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 1.0, 1.0), 0);
        return new Obstruction(string, GeomNodeUtil.newNode(aABoxGeom), new Surface[]{surface});
    }

    public void setUp() {
        Obstruction obstruction = this.createTestMember("topBlock1");
        ModelComposite modelComposite = new ModelComposite("topComposite1");
        Obstruction obstruction2 = this.createTestMember("L2Block1");
        modelComposite.add(obstruction2);
        Obstruction obstruction3 = this.createTestMember("L2Block2");
        modelComposite.add(obstruction3);
        Obstruction obstruction4 = this.createTestMember("topBlock2");
        this.d_array = new IPyroObject[]{obstruction, modelComposite, obstruction4};
        this.d_composite = new ModelComposite();
        this.d_composite.add(obstruction);
        this.d_composite.add(modelComposite);
        this.d_composite.add(obstruction4);
    }

    private static Iterator<? extends IPyroObject> iterate(boolean bl, ModelComposite modelComposite) {
        return FDSObjectIteratorTest.iterate(bl, modelComposite.getMembers());
    }

    private static Iterator<? extends IPyroObject> iterate(boolean bl, IPyroObject ... iPyroObjectArray) {
        return FDSObjectIteratorTest.iterate(bl, Arrays.asList(iPyroObjectArray));
    }

    private static Iterator<? extends IPyroObject> iterate(boolean bl, Collection<? extends IPyroObject> collection) {
        return bl ? Hierarchy.flatten(collection, FDSObject.class).iterator() : collection.iterator();
    }

    private static <T extends FDSObject> Iterator<T> iterate(boolean bl, Class<T> clazz, ModelComposite modelComposite) {
        return bl ? ((APyroObject)modelComposite).flatten(clazz).iterator() : modelComposite.getMembers(clazz).iterator();
    }

    public void testArrayShallow() {
        Iterator<? extends IPyroObject> iterator = FDSObjectIteratorTest.iterate(false, this.d_array);
        this.assertIter(iterator, false);
    }

    public void testCompositeShallow() {
        Iterator<? extends IPyroObject> iterator = FDSObjectIteratorTest.iterate(false, this.d_composite);
        this.assertIter(iterator, false);
    }

    public void testArrayDeep() {
        Iterator<? extends IPyroObject> iterator = FDSObjectIteratorTest.iterate(true, this.d_array);
        this.assertIter(iterator, true);
    }

    public void testCompositeDeep() {
        Iterator<? extends IPyroObject> iterator = FDSObjectIteratorTest.iterate(true, this.d_composite);
        this.assertIter(iterator, true);
    }

    private void assertIter(Iterator<? extends IPyroObject> iterator, boolean bl) {
        FDSObjectIteratorTest.assertTrue((boolean)iterator.hasNext());
        IPyroObject iPyroObject = iterator.next();
        FDSObjectIteratorTest.assertEquals((String)"topBlock1", (String)Util.getName(iPyroObject));
        if (bl) {
            FDSObjectIteratorTest.assertTrue((boolean)iterator.hasNext());
            iPyroObject = iterator.next();
            FDSObjectIteratorTest.assertEquals((String)"L2Block1", (String)Util.getName(iPyroObject));
            FDSObjectIteratorTest.assertTrue((boolean)iterator.hasNext());
            iPyroObject = iterator.next();
            FDSObjectIteratorTest.assertEquals((String)"L2Block2", (String)Util.getName(iPyroObject));
        } else {
            FDSObjectIteratorTest.assertTrue((boolean)iterator.hasNext());
            iPyroObject = iterator.next();
            FDSObjectIteratorTest.assertEquals((String)"topComposite1", (String)Util.getName(iPyroObject));
        }
        FDSObjectIteratorTest.assertTrue((boolean)iterator.hasNext());
        iPyroObject = iterator.next();
        FDSObjectIteratorTest.assertEquals((String)"topBlock2", (String)Util.getName(iPyroObject));
        FDSObjectIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testCompositeLastDeep() {
        ModelComposite modelComposite = new ModelComposite();
        modelComposite.setName("C1");
        Obstruction obstruction = this.createTestMember("B1");
        modelComposite.add(obstruction);
        ModelComposite modelComposite2 = new ModelComposite();
        modelComposite2.setName("C2");
        IPyroObject[] iPyroObjectArray = new IPyroObject[]{modelComposite, modelComposite2};
        Iterator<? extends IPyroObject> iterator = FDSObjectIteratorTest.iterate(true, iPyroObjectArray);
        FDSObjectIteratorTest.assertTrue((boolean)iterator.hasNext());
        FDSObjectIteratorTest.assertEquals((String)"B1", (String)((Obstruction)iterator.next()).getName());
        FDSObjectIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testEmptyCompositeInMiddle() {
        Obstruction obstruction = this.createTestMember("B1");
        ModelComposite modelComposite = new ModelComposite("C2");
        ModelComposite modelComposite2 = new ModelComposite("C3");
        Obstruction obstruction2 = this.createTestMember("B2");
        IPyroObject[] iPyroObjectArray = new IPyroObject[]{obstruction, modelComposite, modelComposite2, obstruction2};
        Iterator<? extends IPyroObject> iterator = FDSObjectIteratorTest.iterate(true, iPyroObjectArray);
        FDSObjectIteratorTest.assertTrue((boolean)iterator.hasNext());
        FDSObjectIteratorTest.assertEquals((String)"B1", (String)((Obstruction)iterator.next()).getName());
        FDSObjectIteratorTest.assertTrue((boolean)iterator.hasNext());
        FDSObjectIteratorTest.assertEquals((String)"B2", (String)((Obstruction)iterator.next()).getName());
        FDSObjectIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testEmptyIter() {
        Iterator<? extends IPyroObject> iterator = FDSObjectIteratorTest.iterate(false, new IPyroObject[0]);
        FDSObjectIteratorTest.assertFalse((boolean)iterator.hasNext());
        iterator = FDSObjectIteratorTest.iterate(true, new IPyroObject[0]);
        FDSObjectIteratorTest.assertFalse((boolean)iterator.hasNext());
        iterator = FDSObjectIteratorTest.iterate(false, new ModelComposite());
        FDSObjectIteratorTest.assertFalse((boolean)iterator.hasNext());
        iterator = FDSObjectIteratorTest.iterate(true, new ModelComposite());
        FDSObjectIteratorTest.assertFalse((boolean)iterator.hasNext());
        ModelComposite modelComposite = new ModelComposite();
        ModelComposite modelComposite2 = new ModelComposite();
        ModelComposite modelComposite3 = new ModelComposite();
        modelComposite2.add(modelComposite);
        modelComposite3.add(modelComposite2);
        iterator = FDSObjectIteratorTest.iterate(true, modelComposite3);
        FDSObjectIteratorTest.assertFalse((boolean)iterator.hasNext());
        iterator = FDSObjectIteratorTest.iterate(false, modelComposite3);
        FDSObjectIteratorTest.assertTrue((boolean)iterator.hasNext());
        iterator.next();
        FDSObjectIteratorTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testFilterIter() {
        SurfaceManager surfaceManager = new SurfaceManager();
        surfaceManager.addPredefined();
        Surface surface = surfaceManager.get(PredefSurf.INERT);
        Obstruction obstruction = this.createTestMember("topBlock1");
        Vent vent = new Vent("topVent1", surface, new AARectangle());
        ModelComposite modelComposite = new ModelComposite();
        modelComposite.setName("topComposite1");
        Obstruction obstruction2 = this.createTestMember("L2Block1");
        modelComposite.add(obstruction2);
        Vent vent2 = new Vent("L2Vent1", surface, new AARectangle());
        modelComposite.add(vent2);
        Vent vent3 = new Vent("L2Vent2", surface, new AARectangle());
        modelComposite.add(vent3);
        Obstruction obstruction3 = this.createTestMember("L2Block2");
        modelComposite.add(obstruction3);
        Obstruction obstruction4 = this.createTestMember("topBlock2");
        Vent vent4 = new Vent("topVent2", surface, new AARectangle());
        ModelComposite modelComposite2 = new ModelComposite();
        modelComposite2.add(obstruction);
        modelComposite2.add(vent);
        modelComposite2.add(modelComposite);
        modelComposite2.add(obstruction4);
        modelComposite2.add(vent4);
        FDSObject[] fDSObjectArray = new Vent[]{vent, vent2, vent3, vent4};
        Iterator<Vent> iterator = FDSObjectIteratorTest.iterate(true, Vent.class, modelComposite2);
        this.assertExpectedEntries(fDSObjectArray, iterator);
        fDSObjectArray = new Vent[]{vent, vent4};
        iterator = FDSObjectIteratorTest.iterate(false, Vent.class, modelComposite2);
        this.assertExpectedEntries(fDSObjectArray, iterator);
        FDSObject[] fDSObjectArray2 = new FDSObject[]{obstruction, vent, obstruction2, vent2, vent3, obstruction3, obstruction4, vent4};
        Iterator<AFDSObject> iterator2 = FDSObjectIteratorTest.iterate(true, AFDSObject.class, modelComposite2);
        this.assertExpectedEntries(fDSObjectArray2, iterator2);
        fDSObjectArray2 = new FDSObject[]{obstruction, vent, obstruction4, vent4};
        iterator2 = FDSObjectIteratorTest.iterate(false, AFDSObject.class, modelComposite2);
        this.assertExpectedEntries(fDSObjectArray2, iterator2);
        Iterator<IHole> iterator3 = FDSObjectIteratorTest.iterate(false, IHole.class, modelComposite2);
        FDSObjectIteratorTest.assertTrue((!iterator3.hasNext() ? 1 : 0) != 0);
    }

    private <T extends FDSObject> void assertExpectedEntries(FDSObject[] fDSObjectArray, Iterator<T> iterator) {
        int n = 0;
        while (iterator.hasNext()) {
            FDSObject fDSObject = (FDSObject)iterator.next();
            FDSObject fDSObject2 = fDSObjectArray[n];
            FDSObjectIteratorTest.assertSame((Object)fDSObject, (Object)fDSObject2);
            ++n;
        }
        FDSObjectIteratorTest.assertSame((Object)n, (Object)fDSObjectArray.length);
    }
}

