/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.awt.Color;
import java.util.Iterator;
import java.util.Vector;
import javax.vecmath.Point3d;
import junit.framework.TestCase;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.TestListener;
import pyrosim.domain.APyroObject;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.Obstruction;
import pyrosim.domain.geom.Vent;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.Application;

public class FDSCompositeTest
extends TestCase {
    private Unit d_unit;
    private ModelComposite d_comp;
    private Obstruction d_member1;
    private Obstruction d_member2;
    private TestListener d_listener;
    private IGeom d_defGeom;
    private ModelComposite d_grandParent;
    private ModelComposite d_parent1;
    private ModelComposite d_parent2;
    private Obstruction d_child1;
    private Obstruction d_child2;
    private Obstruction d_child3;
    private Obstruction d_child4;

    public FDSCompositeTest(String string) {
        super(string);
    }

    private void removeAllListeners() {
        PyroSim.getApp().getMediator().getEvents().clearObservers();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.d_listener = new TestListener();
        PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
        this.d_unit = SI.METER;
        Surface surface = new Surface("Wood", new Color(0.22f, 0.33f, 0.44f), null);
        AABoxGeom aABoxGeom = new AABoxGeom(new Point3d(1.0, 2.0, 3.0), new Point3d(3.0, 4.0, 5.0), 0);
        this.d_member1 = new Obstruction("Seat", GeomNodeUtil.newNode(aABoxGeom), new Surface[]{surface});
        aABoxGeom = new AABoxGeom(new Point3d(4.0, 0.0, 7.0), new Point3d(6.0, 2.0, 10.0), 0);
        this.d_member2 = new Obstruction("Back", GeomNodeUtil.newNode(aABoxGeom), new Surface[]{pyroMod.getDefaultSurface()});
        this.d_comp = new ModelComposite();
        this.d_comp.add(this.d_member1);
        this.d_comp.add(this.d_member2);
        this.d_defGeom = new AABoxGeom(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 1.0, 1.0), 0);
        this.d_grandParent = new ModelComposite();
        this.d_parent1 = new ModelComposite();
        this.d_parent2 = new ModelComposite();
        this.d_child1 = this.createTestMember();
        this.d_child2 = this.createTestMember();
        this.d_child3 = this.createTestMember();
        this.d_child4 = this.createTestMember();
        this.d_grandParent.add(this.d_parent1);
        this.d_grandParent.add(this.d_parent2);
        this.d_parent1.add(this.d_child1);
        this.d_parent1.add(this.d_child2);
        this.d_parent2.add(this.d_child3);
        this.d_parent2.add(this.d_child4);
        pyroMod.getObstructions().add(this.d_grandParent);
    }

    private Obstruction createTestMember() {
        PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
        return new Obstruction("test", GeomNodeUtil.newNode(this.d_defGeom), new Surface[]{pyroMod.getDefaultSurface()});
    }

    public void testEventsFired() {
        this.d_listener.ensureNoEvent();
        this.removeAllListeners();
        PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
        pyroMod.getEvents().addObserver(this.d_listener);
        this.d_comp.setDomain(pyroMod, null);
        this.d_comp.setName("Joe");
        this.d_listener.ensureEvent(2);
        this.d_comp.add(this.createTestMember());
        this.d_listener.ensureEvent(2);
        this.d_comp.remove(this.d_member2);
        this.d_listener.ensureEvent(2);
    }

    public void testAddMember() {
        FDSCompositeTest.assertEquals((int)2, (int)this.d_comp.getMembers().size());
        Obstruction obstruction = this.createTestMember();
        this.d_comp.add(obstruction);
        FDSCompositeTest.assertEquals((int)3, (int)this.d_comp.getMembers().size());
        Iterator<IPyroObject> iterator = this.d_comp.getMembers().iterator();
        iterator.next();
        iterator.next();
        FDSCompositeTest.assertEquals((Object)obstruction, (Object)iterator.next());
    }

    public void testGetMemberCount() {
        FDSCompositeTest.assertEquals((int)2, (int)this.d_comp.getMembers().size());
    }

    public void testGetMember() {
        Iterator<IPyroObject> iterator = this.d_comp.getMembers().iterator();
        FDSCompositeTest.assertEquals((Object)this.d_member1, (Object)iterator.next());
        FDSCompositeTest.assertEquals((Object)this.d_member2, (Object)iterator.next());
    }

    public void testRemoveMember() {
        FDSCompositeTest.assertEquals((int)2, (int)this.d_comp.getMembers().size());
        Iterator<IPyroObject> iterator = this.d_comp.getMembers().iterator();
        FDSCompositeTest.assertEquals((Object)this.d_member1, (Object)iterator.next());
        this.d_comp.remove(this.d_member1);
        FDSCompositeTest.assertEquals((int)1, (int)this.d_comp.getMembers().size());
        iterator = this.d_comp.getMembers().iterator();
        FDSCompositeTest.assertEquals((Object)this.d_member2, (Object)iterator.next());
    }

    public void testSetMember() {
        FDSCompositeTest.assertEquals((int)2, (int)this.d_comp.getMembers().size());
        Obstruction obstruction = this.createTestMember();
        this.d_comp.add(obstruction);
        FDSCompositeTest.assertEquals((int)3, (int)this.d_comp.getMembers().size());
        Iterator<IPyroObject> iterator = this.d_comp.getMembers().iterator();
        iterator.next();
        iterator.next();
        FDSCompositeTest.assertEquals((Object)obstruction, (Object)iterator.next());
    }

    public void testGetMinPoint() {
        AABox aABox = GeomUtil.getBounds(this.d_comp.flatten());
        Point3d point3d = aABox.getMin();
        FDSCompositeTest.assertEquals((double)1.0, (double)point3d.x, (double)0.0);
        FDSCompositeTest.assertEquals((double)0.0, (double)point3d.y, (double)0.0);
        FDSCompositeTest.assertEquals((double)3.0, (double)point3d.z, (double)0.0);
    }

    public void testGetMaxPoint() {
        AABox aABox = GeomUtil.getBounds(this.d_comp.flatten());
        Point3d point3d = aABox.getMax();
        FDSCompositeTest.assertEquals((double)6.0, (double)point3d.x, (double)0.0);
        FDSCompositeTest.assertEquals((double)4.0, (double)point3d.y, (double)0.0);
        FDSCompositeTest.assertEquals((double)10.0, (double)point3d.z, (double)0.0);
    }

    public void testGetParent() {
        FDSCompositeTest.assertTrue((this.d_grandParent == this.d_parent1.getParent() ? 1 : 0) != 0);
        FDSCompositeTest.assertTrue((this.d_grandParent == this.d_parent1.getParent() ? 1 : 0) != 0);
        FDSCompositeTest.assertTrue((this.d_parent1 == this.d_child1.getParent() ? 1 : 0) != 0);
        FDSCompositeTest.assertTrue((this.d_parent2 == this.d_child4.getParent() ? 1 : 0) != 0);
    }

    public void testGetPathFromRoot() {
        IPyroObject[] iPyroObjectArray = null;
        iPyroObjectArray = Hierarchy.getPath(this.d_child2, this.d_grandParent, true);
        FDSCompositeTest.assertEquals((int)3, (int)iPyroObjectArray.length);
        FDSCompositeTest.assertTrue((this.d_grandParent == iPyroObjectArray[0] ? 1 : 0) != 0);
        FDSCompositeTest.assertTrue((this.d_parent1 == iPyroObjectArray[1] ? 1 : 0) != 0);
        iPyroObjectArray = Hierarchy.getPath(this.d_child3, this.d_parent2, true);
        FDSCompositeTest.assertEquals((int)2, (int)iPyroObjectArray.length);
        FDSCompositeTest.assertTrue((this.d_parent2 == iPyroObjectArray[0] ? 1 : 0) != 0);
    }

    public void testIsDecendent() {
        FDSCompositeTest.assertTrue((boolean)Hierarchy.isDescendent(this.d_grandParent, this.d_parent1));
        FDSCompositeTest.assertTrue((boolean)Hierarchy.isDescendent(this.d_parent1, this.d_child2));
        FDSCompositeTest.assertTrue((boolean)Hierarchy.isDescendent(this.d_grandParent, this.d_child2));
        FDSCompositeTest.assertTrue((boolean)Hierarchy.isDescendent(this.d_grandParent, this.d_grandParent));
        FDSCompositeTest.assertTrue((!Hierarchy.isDescendent(this.d_parent2, this.d_grandParent) ? 1 : 0) != 0);
        FDSCompositeTest.assertTrue((!Hierarchy.isDescendent(this.d_parent1, this.d_child4) ? 1 : 0) != 0);
    }

    public void testGetVents() {
        PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
        ModelComposite modelComposite = new ModelComposite();
        ModelComposite modelComposite2 = new ModelComposite();
        ModelComposite modelComposite3 = new ModelComposite();
        ModelComposite modelComposite4 = new ModelComposite();
        ModelComposite modelComposite5 = new ModelComposite();
        modelComposite.add(modelComposite2);
        modelComposite.add(modelComposite4);
        modelComposite4.add(modelComposite5);
        modelComposite2.add(modelComposite3);
        Vector<Vent> vector = new Vector<Vent>();
        vector.add(new Vent("blaha1", pyroMod.getDefaultSurface()));
        vector.add(new Vent("blaha2", pyroMod.getDefaultSurface()));
        vector.add(new Vent("blahaa1", pyroMod.getDefaultSurface()));
        vector.add(new Vent("blahaa2", pyroMod.getDefaultSurface()));
        vector.add(new Vent("blahb1", pyroMod.getDefaultSurface()));
        vector.add(new Vent("blahb2", pyroMod.getDefaultSurface()));
        vector.add(new Vent("base1", pyroMod.getDefaultSurface()));
        vector.add(new Vent("base2", pyroMod.getDefaultSurface()));
        modelComposite2.add((Vent)vector.get(0));
        modelComposite2.add(this.createTestMember());
        modelComposite2.add((Vent)vector.get(1));
        modelComposite3.add(this.createTestMember());
        modelComposite3.add((Vent)vector.get(2));
        modelComposite3.add((Vent)vector.get(3));
        modelComposite4.add((Vent)vector.get(4));
        modelComposite4.add((Vent)vector.get(5));
        modelComposite.add((Vent)vector.get(6));
        modelComposite.add((Vent)vector.get(7));
        modelComposite.add(this.createTestMember());
        block0: for (Vent vent : ((APyroObject)modelComposite).flatten(Vent.class)) {
            for (int i = 0; i < vector.size(); ++i) {
                if (!((Vent)vector.get(i)).getName().equals(vent.getName())) continue;
                vector.remove(i);
                continue block0;
            }
        }
        FDSCompositeTest.assertTrue((vector.size() == 0 ? 1 : 0) != 0);
    }

    static {
        new PyroSim();
    }
}

