/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.awt.Color;
import javax.vecmath.Point3d;
import junit.framework.TestCase;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.TestListener;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.Obstruction;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.Application;
import thunderheadeng.scene3d.geom.DisplayGeom;

public class AlignedBlockTest
extends TestCase {
    private Obstruction d_block;
    private TestListener d_listener;
    private Unit d_unit;
    private Surface d_surf;
    private Color d_surfColor;

    public AlignedBlockTest(String string) {
        super(string);
    }

    private void removeAllListeners() {
        PyroSim.getApp().getMediator().getEvents().clearObservers();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.d_unit = SI.METER;
        this.d_surfColor = new Color(0.22f, 0.33f, 0.44f);
        this.d_surf = new Surface("Marble", this.d_surfColor, null);
        this.d_listener = new TestListener();
        AABoxGeom aABoxGeom = new AABoxGeom(new Point3d(1.0, 2.0, 3.0), new Point3d(3.0, 4.0, 5.0), 0);
        this.d_block = new Obstruction("Bob", GeomNodeUtil.newNode(aABoxGeom), new Surface[]{this.d_surf});
    }

    public void testEventsFired() {
        this.d_listener.ensureNoEvent();
        this.removeAllListeners();
        PyroMod pyroMod = ((PyroSim)Application.getApp()).getMediator();
        pyroMod.getEvents().addObserver(this.d_listener);
        this.d_block.setDomain(pyroMod, null);
        this.d_block.setName("Joe");
        this.d_listener.ensureEvent(2);
        this.d_block.setSurfaces(new Surface[]{this.d_surf});
        this.d_listener.ensureEvent();
        this.d_block.setGeom(GeomNodeUtil.newNode(new AABoxGeom(new Point3d(1.0, 2.0, 3.0), new Point3d(3.0, 4.0, 5.0), 0)));
        this.d_listener.ensureEvent();
    }

    public void testGetMinPoint() {
        Point3d point3d = ((AABoxGeom)this.d_block.getGeom().getLocalGeom()).min;
        AlignedBlockTest.assertEquals((double)1.0, (double)point3d.x, (double)0.0);
        AlignedBlockTest.assertEquals((double)2.0, (double)point3d.y, (double)0.0);
        AlignedBlockTest.assertEquals((double)3.0, (double)point3d.z, (double)0.0);
    }

    public void testGetMaxPoint() {
        Point3d point3d = ((AABoxGeom)this.d_block.getGeom().getLocalGeom()).max;
        AlignedBlockTest.assertEquals((double)3.0, (double)point3d.x, (double)0.0);
        AlignedBlockTest.assertEquals((double)4.0, (double)point3d.y, (double)0.0);
        AlignedBlockTest.assertEquals((double)5.0, (double)point3d.z, (double)0.0);
    }

    public void testGetSurface() {
        Surface surface = this.d_block.getSurfaces()[0];
        AlignedBlockTest.assertEquals((String)"Marble", (String)surface.getName());
    }

    public void testGetGeometry() {
        DisplayGeom displayGeom = this.d_block.getDisplayGeom(null);
        AlignedBlockTest.assertTrue((displayGeom.props.getUniformCount(0, 6) == 6 ? 1 : 0) != 0);
        AlignedBlockTest.assertSame(null, (Object)displayGeom.props.get(0).getMaterial());
        AlignedBlockTest.assertSame((Object)this.d_surf.getColor(), (Object)displayGeom.props.get(0).getColor());
    }

    static {
        new PyroSim();
    }
}

