/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Set;
import pyrosim.PyroMod;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.dependencies.SkipDep;
import pyrosim.domain.geom.EvacProps;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.util.LWArray;
import pyrosim.util.Util;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public abstract class AFDSObject
extends NamedPyroObject
implements FDSObject,
IDirectDependent {
    static final long serialVersionUID = 1L;
    protected static final int FLAG_VIS = Integer.MIN_VALUE;
    @Deprecated
    protected static final int FLAG_SEL = 0x40000000;
    protected static final int DEF_FLAGS = Integer.MIN_VALUE;
    private OneLogicInPin d_inPin = new OneLogicInPin(this);
    @SkipDep
    private Object d_colors = null;
    private EvacProps d_evac = EvacProps.DEFAULT;
    private int d_flags = Integer.MIN_VALUE;
    private String d_description = "";
    private CustomFDSProps d_customFDSProps = CustomFDSProps.EMPTY;

    public AFDSObject(String string) {
        super(string);
    }

    @Override
    public boolean equals(Object object) {
        return object == this;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.d_flags &= 0xBFFFFFFF;
        if (this.d_customFDSProps == null) {
            this.d_customFDSProps = CustomFDSProps.EMPTY;
        }
        if (this.d_description == null) {
            this.d_description = "";
        }
    }

    @Override
    public Object clone() {
        AFDSObject aFDSObject = (AFDSObject)super.clone();
        aFDSObject.d_inPin = (OneLogicInPin)this.d_inPin.clone(aFDSObject);
        return aFDSObject;
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String string) {
        return this.d_customFDSProps;
    }

    @Override
    public void setCustomFDSProps(String string, CustomFDSProps customFDSProps) {
        this.d_customFDSProps = customFDSProps;
        this.changedEvt(new Object[0]);
    }

    @Override
    protected boolean registerProximity() {
        return true;
    }

    protected boolean testFlags(int n) {
        return (this.d_flags & n) == n;
    }

    protected void setFlags(int n, boolean bl, Object ... objectArray) {
        int n2 = this.d_flags;
        this.d_flags = bl ? (this.d_flags |= n) : (this.d_flags &= ~n);
        if (this.d_flags != n2) {
            this.changedEvt(objectArray);
        }
    }

    protected int getSetFlags() {
        return this.d_flags;
    }

    @Override
    public void setEvac(EvacProps evacProps) {
        if (evacProps.equals(this.d_evac)) {
            return;
        }
        this.d_evac = evacProps;
        this.changedEvt(new Object[0]);
    }

    @Override
    public EvacProps getEvac() {
        return this.d_evac;
    }

    @Override
    public String getDesc() {
        return this.d_description;
    }

    @Override
    public void setDesc(String string) {
        this.d_description = string;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void setColors(Color ... colorArray) {
        this.d_colors = LWArray.newArray(colorArray);
        this.changedEvt(new Object[0]);
    }

    @Override
    public Color[] getColors() {
        Color[] colorArray;
        Color[] colorArray2 = LWArray.toArray(this.d_colors, Color.class);
        if (colorArray2.length == 0) {
            Color[] colorArray3 = new Color[1];
            colorArray = colorArray3;
            colorArray3[0] = null;
        } else {
            colorArray = colorArray2;
        }
        return colorArray;
    }

    @Override
    public void setVisible(boolean bl) {
        this.setFlags(Integer.MIN_VALUE, bl, PyroMod.EVT_VISIBILITY_CHANGED);
    }

    @Override
    public boolean isVisible() {
        return this.testFlags(Integer.MIN_VALUE);
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        depList.add(DLink.WEAK, (IPyroObject)this.d_evac.mesh);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t instanceof Grid) {
            Util.keepIfNullOr(set, Grid.class);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (iPyroObject != this.d_evac.mesh) {
            return EmptyTask.INSTANCE;
        }
        return new AReplaceRefTask<Grid>((Object)iPyroObject, (Object)iPyroObject2){

            @Override
            protected void set(Grid grid) {
                AFDSObject.this.setEvac(EvacProps.get(((AFDSObject)AFDSObject.this).d_evac.evacuation, grid));
            }
        };
    }

    @Override
    public Task taskUpdateDep(IPyroObject iPyroObject, Collection<Object> collection) {
        return EmptyTask.INSTANCE;
    }
}

