/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.sprayers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.devices.IFreezable;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.sprayers.ASprayer;
import pyrosim.domain.devices.sprayers.DryPipe;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityReplacer;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.signals.AOutPin;
import pyrosim.domain.signals.IDoubleInPin;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.LogicOutPin;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class Sprinkler
extends ASprayer
implements IDirectDependent,
IFreezable {
    static final long serialVersionUID = 1L;
    private LinkModel d_linkModel;
    private DryPipe d_dryPipe;
    private LogicOutPin d_linkAlarmPin;
    private IDoubleOutPin d_linkQuantityPin;
    private OneLogicInPin d_freezePin;

    public Sprinkler(String string, SprayModel sprayModel, LinkModel linkModel, FreePointLoc freePointLoc) {
        super(string, sprayModel, freePointLoc);
        this.d_linkModel = linkModel;
        this.d_freezePin = new OneLogicInPin(this);
        this.initPins();
    }

    private void initPins() {
        this.d_linkAlarmPin = new LogicOutPin(this, Intl.intl("LINK"));
        this.d_linkQuantityPin = new LinkQuantOutPin(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_linkAlarmPin == null) {
            assert (this.d_linkQuantityPin == null);
            this.initPins();
        }
        if (this.d_freezePin == null) {
            this.d_freezePin = new OneLogicInPin(this);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Sprinkler)) {
            return false;
        }
        Sprinkler sprinkler = (Sprinkler)object;
        return super.equals(object) && this.d_linkModel.equals(sprinkler.d_linkModel) && Objects.equals(this.d_dryPipe, sprinkler.d_dryPipe) && this.d_freezePin.equals(sprinkler.d_freezePin);
    }

    @Override
    public Sprinkler clone() {
        Sprinkler sprinkler = (Sprinkler)super.clone();
        sprinkler.d_linkAlarmPin = (LogicOutPin)this.d_linkAlarmPin.clone(sprinkler);
        sprinkler.d_linkQuantityPin = (IDoubleOutPin)this.d_linkQuantityPin.clone(sprinkler);
        sprinkler.d_freezePin = (OneLogicInPin)this.d_freezePin.clone(sprinkler);
        return sprinkler;
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        ArrayList<? extends IOutPin> arrayList = new ArrayList<IOutPin>(super.getOutputPins());
        arrayList.add(this.d_linkAlarmPin);
        arrayList.add(this.d_linkQuantityPin);
        return arrayList;
    }

    public LogicOutPin getLinkAlarmPin() {
        return this.d_linkAlarmPin;
    }

    public IDoubleOutPin getLinkQuantityPin() {
        return this.d_linkQuantityPin;
    }

    @Override
    public OneLogicInPin getFreezePin() {
        return this.d_freezePin;
    }

    public DryPipe getDryPipe() {
        return this.d_dryPipe;
    }

    public void setDryPipe(DryPipe dryPipe) {
        this.d_dryPipe = dryPipe;
        this.changedEvt(new Object[0]);
    }

    public LinkModel getLinkModel() {
        return this.d_linkModel;
    }

    public void setLinkModel(LinkModel linkModel, Unit unit) {
        if (this.d_linkModel == linkModel) {
            return;
        }
        IQuantity iQuantity = this.d_linkModel.getOutputQuantity();
        this.d_linkModel = linkModel;
        IQuantity iQuantity2 = this.d_linkModel.getOutputQuantity();
        if (!iQuantity.equals(iQuantity2) && this.getDomain() != null) {
            DepSnapshot depSnapshot = ((PyroMod)this.getDomain()).getDependencies(this);
            Set<Dependency> set = depSnapshot.getDependents(this);
            for (Dependency dependency : set) {
                if (!(dependency.source instanceof IDoubleInPin)) continue;
                IDoubleInPin iDoubleInPin = (IDoubleInPin)dependency.source;
                iDoubleInPin.updateInputUnit(unit);
            }
        }
        this.changedEvt(new Object[0]);
    }

    public Task taskSetLinkModel(LinkModel linkModel, final Unit unit) {
        return new AReplaceRefTask<LinkModel>((Object)this.d_linkModel, (Object)linkModel){

            @Override
            protected void set(LinkModel linkModel) {
                Sprinkler.this.setLinkModel(linkModel, unit);
            }
        };
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        super.takeDepSnapshot(depList);
        if (this.d_linkModel instanceof TraditionalModel) {
            depList.add(DLink.STRONG, (IPyroObject)((TraditionalModel)this.d_linkModel).d_link);
        } else {
            QuantityUtil.takeDepSnapshot(depList, DLink.STRONG, ((QuantityModel)this.d_linkModel).d_quantity);
        }
        depList.add(DLink.WEAK, (IPyroObject)this.d_dryPipe);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t instanceof SprinklerLinkModel) {
            Util.keepIfNullOr(set, SprinklerLinkModel.class);
        } else if (t instanceof DryPipe) {
            Util.keepIfNullOr(set, DryPipe.class);
        } else if (this.d_linkModel instanceof QuantityModel && QuantityUtil.isQuantityRef(t, ((QuantityModel)this.d_linkModel).d_quantity)) {
            QuantReplacer quantReplacer = new QuantReplacer();
            quantReplacer.removeInvalidReplacements(t, set, ((QuantityModel)this.d_linkModel).d_quantity);
        } else {
            super.removeInvalidReplacements(t, set);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (iPyroObject instanceof SprinklerLinkModel) {
            assert (iPyroObject2 != null);
            TraditionalModel traditionalModel = new TraditionalModel((SprinklerLinkModel)iPyroObject2);
            return this.taskSetLinkModel(traditionalModel, SIUS.unit(((LinkModel)traditionalModel).getOutputQuantity().get().unitType));
        }
        if (iPyroObject instanceof DryPipe) {
            return new AReplaceRefTask<DryPipe>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                protected void set(DryPipe dryPipe) {
                    Sprinkler.this.setDryPipe(dryPipe);
                }
            };
        }
        if (this.d_linkModel instanceof QuantityModel && QuantityUtil.isQuantityRef(iPyroObject, ((QuantityModel)this.d_linkModel).d_quantity)) {
            QuantReplacer quantReplacer = new QuantReplacer();
            return quantReplacer.taskReplaceDep(iPyroObject, iPyroObject2, ((QuantityModel)this.d_linkModel).d_quantity);
        }
        return super.taskReplaceDep(iPyroObject, iPyroObject2);
    }

    public static class LinkQuantOutPin
    extends AOutPin
    implements IDoubleOutPin {
        static final long serialVersionUID = 1L;

        public LinkQuantOutPin(Sprinkler sprinkler) {
            super(sprinkler, Intl.intl("LINK"));
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && object instanceof LinkQuantOutPin;
        }

        @Override
        public void setSource(ISignalSource iSignalSource) {
            assert (iSignalSource instanceof Sprinkler);
            super.setSource(iSignalSource);
        }

        public Sprinkler getSprinkler() {
            return (Sprinkler)this.getAttachedSource();
        }

        @Override
        public int getUnitType() {
            return this.getSprinkler().getLinkModel().getOutputQuantity().get().unitType;
        }
    }

    public static class QuantityModel
    extends LinkModel {
        static final long serialVersionUID = 1L;
        public final IQuantity d_quantity;
        public final UnitDouble d_setPoint;

        public QuantityModel(IQuantity iQuantity, UnitDouble unitDouble) {
            this(iQuantity, unitDouble, false, true);
        }

        public QuantityModel(IQuantity iQuantity, UnitDouble unitDouble, boolean bl, boolean bl2) {
            super(bl, bl2);
            this.d_quantity = iQuantity;
            this.d_setPoint = unitDouble;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof QuantityModel)) {
                return false;
            }
            QuantityModel quantityModel = (QuantityModel)object;
            return this.d_quantity.equals(quantityModel.d_quantity) && this.d_setPoint.equals(quantityModel.d_setPoint);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 1647607715 + this.d_quantity.hashCode() + this.d_setPoint.hashCode();
        }

        public static int getOutputType() {
            return 1;
        }

        public static QuantityType getQuantityType() {
            return QuantityType.GAS;
        }

        public static Predicate<Quantity> getQuantityFilter() {
            return new QuantityUtil.TypeFilter(QuantityModel.getOutputType(), new QuantityType[]{QuantityModel.getQuantityType()}){

                @Override
                public boolean test(Quantity quantity) {
                    return quantity == Quantity.TIME || super.test(quantity);
                }
            };
        }

        @Override
        public IQuantity getOutputQuantity() {
            return this.d_quantity;
        }
    }

    public static class TraditionalModel
    extends LinkModel {
        static final long serialVersionUID = 1L;
        public final SprinklerLinkModel d_link;

        public TraditionalModel(SprinklerLinkModel sprinklerLinkModel) {
            this(sprinklerLinkModel, false, true);
        }

        public TraditionalModel(SprinklerLinkModel sprinklerLinkModel, boolean bl, boolean bl2) {
            super(bl, bl2);
            this.d_link = sprinklerLinkModel;
        }

        @Override
        public boolean equals(Object object) {
            return object == this || object instanceof TraditionalModel && this.d_link.equals(((TraditionalModel)object).d_link);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 864318175 + this.d_link.hashCode();
        }

        @Override
        public IQuantity getOutputQuantity() {
            return Quantity.TEMPERATURE.create();
        }
    }

    public static abstract class LinkModel
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final boolean d_initState;
        public final boolean d_latch;

        public LinkModel(boolean bl, boolean bl2) {
            this.d_initState = bl;
            this.d_latch = bl2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof LinkModel)) {
                return false;
            }
            LinkModel linkModel = (LinkModel)object;
            return this.d_initState == linkModel.d_initState && this.d_latch == linkModel.d_latch;
        }

        public int hashCode() {
            return 9602042 + theUtil.hashCode(this.d_initState) + theUtil.hashCode(this.d_latch);
        }

        public abstract IQuantity getOutputQuantity();
    }

    private class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)Sprinkler.this.getDomain());
        }

        @Override
        protected Task taskReplaceQuant(IQuantity iQuantity, IQuantity iQuantity2) {
            Unit unit;
            assert (iQuantity2 != null);
            QuantityModel quantityModel = (QuantityModel)Sprinkler.this.d_linkModel;
            Unit unit2 = quantityModel.d_setPoint.getUnit();
            UnitDouble unitDouble = pyrosim.domain.signals.Util.areCompatible(unit2, unit = SIUS.unit(iQuantity2.get().unitType)) ? quantityModel.d_setPoint : new UnitDouble(quantityModel.d_setPoint.getValueNoUnit(), unit);
            QuantityModel quantityModel2 = new QuantityModel(iQuantity2, unitDouble);
            return Sprinkler.this.taskSetLinkModel(quantityModel2, unit);
        }
    }
}

