/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.sprayers;

import java.util.Arrays;
import java.util.List;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.particle.ParticleList;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;

public class SprayModelMgr
extends Composite<SprayModel> {
    static final long serialVersionUID = 1L;

    public SprayModelMgr() {
        this(Intl.intl("Spray Models"));
    }

    public SprayModelMgr(String string) {
        super(string, SprayModel.class);
    }

    public SprayModel getDefaultWaterSpray(ParticleList particleList) {
        SprayModel sprayModel = null;
        for (Particle particle : particleList.flatten()) {
            if (!particle.isType(Particle.Type.LIQUID) || !ExSpecList.equalsPredefinedSpecies(particle.getSpecies())) continue;
            sprayModel = new SprayModel(Intl.intl("Water Spray"), particle);
        }
        if (sprayModel == null) {
            return null;
        }
        SprayModel sprayModel2 = (SprayModel)this.get(Intl.intl("Water Spray"));
        if (sprayModel2 == null) {
            return null;
        }
        return sprayModel2.equals(sprayModel) ? sprayModel2 : null;
    }

    public void addDefaults(ParticleList particleList) {
        List<Pair> list = Arrays.asList(new Pair<String, Double>(Intl.intl("Generic Commercial Spray"), 56.1), new Pair<String, Double>(Intl.intl("Generic Industrial Spray"), 80.13), new Pair<String, Double>(Intl.intl("Generic Residential Spray"), 49.05), new Pair<String, Double>(Intl.intl("Generic Storage Spray"), 164.59));
        Particle particle = (Particle)particleList.get(ParticleList.WATER);
        TimeFunction.TanH tanH = new TimeFunction.TanH(new UnitDouble(0.0, SI.SECOND));
        list.forEach(pair -> this.addDefault(new SprayModel((String)pair.v1, particle, new SprayModel.ExplicitFlowRate(new TimeBasedValue<UnitDouble>(SIUS.newud((Double)pair.v2, 30), tanH)))));
    }
}

