/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.sprayers;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.vecmath.Matrix4d;
import pyrosim.Intl;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.devices.ADevice;
import pyrosim.domain.devices.FreeLocSaveTask;
import pyrosim.domain.devices.FreePointGeom;
import pyrosim.domain.devices.IFreePointDevice;
import pyrosim.domain.devices.sprayers.ISprayer;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.LogicOutPin;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.util.Util;
import thunderheadeng.geometry.objs.BlockGeom;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public abstract class ASprayer
extends ADevice
implements ISprayer,
IDirectDependent,
IFreePointDevice {
    static final long serialVersionUID = 1L;
    private SprayModel d_sprayDescription;
    private FreePointLoc d_location;
    private LogicOutPin d_sprayAlarmPin;
    private static final IPrimProps s_primProps = new IPrimProps.Vertex(Color.BLUE, 10.0);

    public ASprayer(String string, SprayModel sprayModel) {
        this(string, sprayModel, new FreePointLoc());
    }

    public ASprayer(String string, SprayModel sprayModel, FreePointLoc freePointLoc) {
        super(string);
        this.d_sprayDescription = sprayModel;
        this.d_location = freePointLoc;
        this.d_sprayAlarmPin = new LogicOutPin(this, Intl.intl("NOZZLE"));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_sprayAlarmPin == null) {
            this.d_sprayAlarmPin = new LogicOutPin(this, Intl.intl("NOZZLE"));
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ASprayer)) {
            return false;
        }
        ASprayer aSprayer = (ASprayer)object;
        return super.equals(object) && this.d_sprayDescription.equals(aSprayer.d_sprayDescription) && this.d_location.equals(aSprayer.d_location);
    }

    @Override
    public ASprayer clone() {
        ASprayer aSprayer = (ASprayer)super.clone();
        aSprayer.d_sprayAlarmPin = (LogicOutPin)this.d_sprayAlarmPin.clone(aSprayer);
        return aSprayer;
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        return Collections.singletonList(this.d_sprayAlarmPin);
    }

    public LogicOutPin getNozzleAlarmPin() {
        return this.d_sprayAlarmPin;
    }

    @Override
    public FreePointLoc getLocation() {
        return this.d_location;
    }

    @Override
    public void setLocation(FreePointLoc freePointLoc) {
        this.d_location = freePointLoc;
        this.changedEvt(new Object[0]);
    }

    public IDOF getDOF() {
        return IDOF.FREE;
    }

    protected void transform(Matrix4d matrix4d) {
        this.setLocation(this.d_location.transform(matrix4d));
    }

    protected void imprintGeom(Object object) {
        this.setLocation(((ASprayer)object).d_location);
    }

    protected Task taskSaveGeometry() {
        return new FreeLocSaveTask(this);
    }

    public SprayModel getSprayModel() {
        return this.d_sprayDescription;
    }

    public void setSprayModel(SprayModel sprayModel) {
        this.d_sprayDescription = sprayModel;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        if (this.d_sprayDescription != null) {
            depList.add(DLink.STRONG, (IPyroObject)this.d_sprayDescription);
        }
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t instanceof SprayModel) {
            Util.keepIfNullOr(set, SprayModel.class);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (iPyroObject == this.d_sprayDescription) {
            assert (iPyroObject2 != null);
            return new AReplaceRefTask<SprayModel>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                public void set(SprayModel sprayModel) {
                    ASprayer.this.setSprayModel(sprayModel);
                }
            };
        }
        return null;
    }

    @Override
    public Task taskUpdateDep(IPyroObject iPyroObject, Collection<Object> collection) {
        return EmptyTask.INSTANCE;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        return new DisplayGeom(this.getGeom(), s_primProps);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getSprayerGeom());
    }

    public IGeom getSprayerGeom() {
        return new FreePointGeom(this.d_location);
    }

    @Override
    public void setGeom(IGeomNode iGeomNode) {
        this.setGeom(iGeomNode.flatten().getLocalGeom());
    }

    public void setGeom(IGeom iGeom) {
        if (iGeom instanceof FreePointGeom) {
            FreePointGeom freePointGeom = (FreePointGeom)iGeom;
            this.setLocation(freePointGeom.loc);
        } else if (iGeom instanceof Point || iGeom instanceof LineSeg || iGeom instanceof BlockGeom) {
            this.setLocation(this.d_location.setGeom(iGeom));
        }
    }
}

