/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import java.awt.Color;
import java.util.Collection;
import java.util.function.Predicate;
import pyrosim.domain.devices.AttachedPointGeom;
import pyrosim.domain.devices.IAttachedPointDevice;
import pyrosim.domain.devices.measurers.AMeasuringDevc;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;

public class SolidPointMeasurer
extends AMeasuringDevc
implements IAttachedPointDevice {
    static final long serialVersionUID = 1L;
    private AttachedPointLoc d_loc;
    private static final IPrimProps s_primProps = new IPrimProps.Vertex(new Color(0.7f, 0.7f, 0.0f), 10.0);

    public SolidPointMeasurer(String string, IQuantity iQuantity, AttachedPointLoc attachedPointLoc) {
        super(string, iQuantity);
        this.d_loc = attachedPointLoc;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof SolidPointMeasurer && super.equals(object) && this.d_loc.equals(((SolidPointMeasurer)object).d_loc);
    }

    public static void getCustomFDSTypes(IQuantity iQuantity, Collection<String> collection) {
        collection.add("DEVC");
        switch (iQuantity.get()) {
            case PRESSURE_COEFFICIENT: 
            case GAUGE_HEAT_FLUX: {
                collection.add("PROP");
            }
        }
    }

    @Override
    public void getCustomFDSTypes(Collection<String> collection) {
        SolidPointMeasurer.getCustomFDSTypes(this.getQuantity(), collection);
    }

    @Override
    public FreePointLoc getLocation() {
        return this.d_loc.toFreePoint();
    }

    @Override
    public AttachedPointLoc getAttachedLocation() {
        return this.d_loc;
    }

    @Override
    public void setLocation(AttachedPointLoc attachedPointLoc) {
        this.d_loc = attachedPointLoc;
        this.changedEvt(new Object[0]);
    }

    public static QuantityType getQuantityType() {
        return QuantityType.SOLID;
    }

    public static int getOutputType() {
        return 1;
    }

    public static Predicate<Quantity> getQuantityFilter() {
        return new QuantityUtil.TypeFilter(SolidPointMeasurer.getOutputType(), SolidPointMeasurer.getQuantityType());
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        return new DisplayGeom(this.getGeom(), s_primProps);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getPointGeom());
    }

    public IGeom getPointGeom() {
        return new AttachedPointGeom(this.d_loc);
    }

    @Override
    public void setGeom(IGeomNode iGeomNode) {
        this.setGeom(iGeomNode.flatten().getLocalGeom());
    }

    public void setGeom(IGeom iGeom) {
        if (iGeom instanceof AttachedPointGeom) {
            AttachedPointGeom attachedPointGeom = (AttachedPointGeom)iGeom;
            this.setLocation(attachedPointGeom.loc);
        } else if (iGeom instanceof Point) {
            this.setLocation(this.d_loc.setLoc(((Point)iGeom).loc));
        }
    }
}

