/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import java.util.function.Predicate;
import org.jscience.physics.units.SI;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;

public class SolidDensityMeasurer
extends SolidPointMeasurer {
    static final long serialVersionUID = 1L;
    private UnitDouble d_depth;

    public SolidDensityMeasurer(String string, ObjectQuantity<Material> objectQuantity, AttachedPointLoc attachedPointLoc) {
        this(string, objectQuantity, new UnitDouble(0.0, SI.METER), attachedPointLoc);
    }

    public SolidDensityMeasurer(String string, ObjectQuantity<Material> objectQuantity, UnitDouble unitDouble, AttachedPointLoc attachedPointLoc) {
        super(string, objectQuantity, attachedPointLoc);
        this.d_depth = unitDouble;
        assert (objectQuantity.get() == Quantity.MATL_SOLID_DENSITY);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof SolidDensityMeasurer && super.equals(object) && this.d_depth.equals(((SolidDensityMeasurer)object).d_depth);
    }

    public static Predicate<Quantity> getQuantityFilter() {
        return Filters.accept(Quantity.MATL_SOLID_DENSITY);
    }

    public UnitDouble getDepth() {
        return this.d_depth;
    }

    public void setDepth(UnitDouble unitDouble) {
        this.d_depth = unitDouble;
        this.changedEvt(new Object[0]);
    }
}

