/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.domain.quantity.Quantity;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class GaugeHeatFluxMeasurer
extends SolidPointMeasurer {
    static final long serialVersionUID = 1L;
    private UnitDouble d_gaugeTemperature;
    private double d_gaugeEmissivity;

    public GaugeHeatFluxMeasurer(String string, UnitDouble unitDouble, AttachedPointLoc attachedPointLoc) {
        this(string, unitDouble, 0.9, attachedPointLoc);
    }

    public GaugeHeatFluxMeasurer(String string, UnitDouble unitDouble, double d, AttachedPointLoc attachedPointLoc) {
        super(string, Quantity.GAUGE_HEAT_FLUX.create(), attachedPointLoc);
        this.d_gaugeTemperature = unitDouble;
        this.d_gaugeEmissivity = d;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof GaugeHeatFluxMeasurer && super.equals(object) && theUtil.equal(this.d_gaugeTemperature, ((GaugeHeatFluxMeasurer)object).d_gaugeTemperature) && theUtil.equal(this.d_gaugeEmissivity, ((GaugeHeatFluxMeasurer)object).d_gaugeEmissivity);
    }

    public void setGaugeTemperature(UnitDouble unitDouble) {
        this.d_gaugeTemperature = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getGaugeTemperature() {
        return this.d_gaugeTemperature;
    }

    public void setGaugeEmissivity(double d) {
        this.d_gaugeEmissivity = d;
        this.changedEvt(new Object[0]);
    }

    public double getGaugeEmissivity() {
        return this.d_gaugeEmissivity;
    }
}

