/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import java.awt.Color;
import java.util.Collection;
import java.util.function.Predicate;
import pyrosim.domain.devices.FreePointGeom;
import pyrosim.domain.devices.IFreePointDevice;
import pyrosim.domain.devices.measurers.AMeasuringDevc;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;

public class GasPointMeasurer
extends AMeasuringDevc
implements IFreePointDevice {
    static final long serialVersionUID = 1L;
    private FreePointLoc d_location;
    private static final IPrimProps s_primProps = new IPrimProps.Vertex(new Color(0.7f, 0.7f, 0.0f), 10.0);

    public GasPointMeasurer(String string, IQuantity iQuantity, FreePointLoc freePointLoc) {
        super(string, iQuantity);
        this.d_location = freePointLoc;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof GasPointMeasurer && super.equals(object) && this.d_location.equals(((GasPointMeasurer)object).d_location);
    }

    @Override
    public FreePointLoc getLocation() {
        return this.d_location;
    }

    @Override
    public void setLocation(FreePointLoc freePointLoc) {
        this.d_location = freePointLoc;
        this.changedEvt(new Object[0]);
    }

    public static QuantityType getQuantityType() {
        return QuantityType.GAS;
    }

    public static int getOutputType() {
        return 1;
    }

    public static Predicate<Quantity> getQuantityFilter() {
        return new QuantityUtil.TypeFilter(GasPointMeasurer.getOutputType(), GasPointMeasurer.getQuantityType());
    }

    public static void getCustomFDSTypes(IQuantity iQuantity, Collection<String> collection) {
        collection.add("DEVC");
        if (iQuantity.get() == Quantity.THERMOCOUPLE) {
            collection.add("PROP");
        }
    }

    @Override
    public void getCustomFDSTypes(Collection<String> collection) {
        GasPointMeasurer.getCustomFDSTypes(this.getQuantity(), collection);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        return new DisplayGeom(this.getGeom(), s_primProps);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getPointGeom());
    }

    public IGeom getPointGeom() {
        return new FreePointGeom(this.d_location);
    }

    @Override
    public void setGeom(IGeomNode iGeomNode) {
        this.setGeom(iGeomNode.flatten().getLocalGeom());
    }

    public void setGeom(IGeom iGeom) {
        if (iGeom instanceof FreePointGeom) {
            FreePointGeom freePointGeom = (FreePointGeom)iGeom;
            this.setLocation(freePointGeom.loc);
        } else if (iGeom instanceof Point) {
            this.setLocation(this.d_location.setGeom(iGeom));
        }
    }
}

