/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import java.awt.Color;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.domain.devices.IAARectDevice;
import pyrosim.domain.devices.measurers.AMeasuringDevc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.util.HashPool;

public class FlowMeasurer
extends AMeasuringDevc
implements IAARectDevice {
    static final long serialVersionUID = 1L;
    public static final int FLOWDIR_POS = 0;
    public static final int FLOWDIR_NEG = 1;
    public static final int FLOWDIR_BOTH = 2;
    private AARectangle d_rect;
    private int d_flowDir;
    private static final IPrimProps s_primProps = new IPrimProps.Face(new Color(1.0f, 1.0f, 0.0f, 0.5f), null, 0);

    public FlowMeasurer(String string, IQuantity iQuantity, AARectangle aARectangle, int n) {
        super(string, iQuantity);
        this.d_rect = aARectangle;
        this.d_flowDir = n;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FlowMeasurer)) {
            return false;
        }
        FlowMeasurer flowMeasurer = (FlowMeasurer)object;
        return super.equals(object) && this.d_flowDir == flowMeasurer.d_flowDir && this.d_rect.equals(flowMeasurer.d_rect);
    }

    private static int toFlowDir(Vector3d vector3d) {
        if (vector3d.epsilonEquals(GeomConstants.VEC3D_XNEG, 1.0E-9) || vector3d.epsilonEquals(GeomConstants.VEC3D_YNEG, 1.0E-9) || vector3d.epsilonEquals(GeomConstants.VEC3D_ZNEG, 1.0E-9)) {
            return 1;
        }
        return 0;
    }

    private static Vector3d toFlowVec(AARectangle aARectangle, int n) {
        switch (aARectangle.d_plane) {
            case 0: {
                switch (n) {
                    case 0: {
                        return GeomConstants.VEC3D_XPOS;
                    }
                    case 1: {
                        return GeomConstants.VEC3D_XNEG;
                    }
                }
                break;
            }
            case 1: {
                switch (n) {
                    case 0: {
                        return GeomConstants.VEC3D_YPOS;
                    }
                    case 1: {
                        return GeomConstants.VEC3D_YNEG;
                    }
                }
                break;
            }
            case 2: {
                switch (n) {
                    case 0: {
                        return GeomConstants.VEC3D_ZPOS;
                    }
                    case 1: {
                        return GeomConstants.VEC3D_ZNEG;
                    }
                }
            }
        }
        return null;
    }

    @Override
    public AARectangle getRect() {
        return this.d_rect;
    }

    public void setRect(AARectangle aARectangle) {
        this.d_rect = aARectangle;
        this.changedEvt(new Object[0]);
    }

    public int getFlowDir() {
        return this.d_flowDir;
    }

    public void setFlowDir(int n) {
        this.d_flowDir = n;
        this.changedEvt(new Object[0]);
    }

    public static QuantityType[] getQuantityTypes() {
        return new QuantityType[]{QuantityType.GAS, QuantityType.SOLID};
    }

    public static int getOutputType() {
        return 2;
    }

    public static Predicate<Quantity> getQuantityFilter() {
        return new QuantityUtil.TypeFilter(FlowMeasurer.getOutputType(), FlowMeasurer.getQuantityTypes());
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        return new DisplayGeom(this.getGeom(), s_primProps);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getFlowGeom());
    }

    public IGeom getFlowGeom() {
        return new FlowMsrGeom(this.d_rect, this.d_flowDir);
    }

    @Override
    public void setGeom(IGeomNode iGeomNode) {
        this.setGeom(iGeomNode.flatten().getLocalGeom());
    }

    public void setGeom(IGeom iGeom) {
        if (iGeom instanceof FlowMsrGeom) {
            FlowMsrGeom flowMsrGeom = (FlowMsrGeom)iGeom;
            this.pauseUpdates();
            this.setRect(new AARectangle(flowMsrGeom.d_plane, flowMsrGeom.d_planeVal, flowMsrGeom.d_minx, flowMsrGeom.d_miny, flowMsrGeom.d_maxx, flowMsrGeom.d_maxy, flowMsrGeom.flipped));
            this.setFlowDir(flowMsrGeom.flowDir);
            this.resumeUpdates();
        } else if (iGeom instanceof AARectangle) {
            this.setRect((AARectangle)iGeom);
        }
    }

    private static class FlowMsrGeom
    extends AARectangle {
        private static final long serialVersionUID = 2650183771693314825L;
        public final int flowDir;

        public FlowMsrGeom(AARectangle aARectangle, int n) {
            super(aARectangle.d_plane, aARectangle.d_planeVal, aARectangle.d_minx, aARectangle.d_miny, aARectangle.d_maxx, aARectangle.d_maxy, aARectangle.flipped);
            this.flowDir = n;
        }

        public FlowMsrGeom optimize(HashPool<Point3d> hashPool) {
            return this;
        }

        @Override
        public IDOF getDOF() {
            return IDOF.ALIGNED;
        }

        @Override
        public IPolygon transform(TransformInfo transformInfo, int n) {
            if (transformInfo.isIdentity()) {
                return this;
            }
            Matrix4d matrix4d = transformInfo.getMatrix();
            AABox aABox = new AABox();
            this.getBoundingBox(aABox);
            Point3d point3d = Util3D.xform(matrix4d, aABox.getMin());
            Point3d point3d2 = Util3D.xform(matrix4d, aABox.getMax());
            AARectangle aARectangle = AARectangle.construct(point3d, point3d2, false);
            int n2 = this.flowDir;
            if (this.flowDir != 2) {
                Vector3d vector3d = FlowMeasurer.toFlowVec(this, this.flowDir);
                vector3d.normalize();
                vector3d = Util3D.xform(matrix4d, vector3d);
                n2 = FlowMeasurer.toFlowDir(vector3d);
            }
            return new FlowMsrGeom(aARectangle, n2);
        }
    }
}

