/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import java.awt.Color;
import java.util.function.Predicate;
import pyrosim.domain.devices.IAABoxDevice;
import pyrosim.domain.devices.measurers.AMeasuringDevc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.BlockGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.UnitAABox;

public class AABoxMeasurer
extends AMeasuringDevc
implements IAABoxDevice {
    static final long serialVersionUID = 1L;
    private UnitAABox d_box;
    private static final IPrimProps s_primProps = new IPrimProps.Face(new Color(1.0f, 1.0f, 0.0f, 0.5f), null, 2);

    public AABoxMeasurer(String string, IQuantity iQuantity, UnitAABox unitAABox) {
        super(string, iQuantity);
        this.d_box = unitAABox;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof AABoxMeasurer && super.equals(object) && this.d_box.equals(((AABoxMeasurer)object).d_box);
    }

    @Override
    public UnitAABox getBox() {
        return this.d_box;
    }

    public void setBox(UnitAABox unitAABox) {
        this.d_box = unitAABox;
        this.changedEvt(new Object[0]);
    }

    public static int getOutputType() {
        return 4;
    }

    public static Predicate<Quantity> getQuantityFilter() {
        return new Predicate<Quantity>(){

            @Override
            public boolean test(Quantity quantity) {
                return QuantityUtil.canOutputAll(quantity, AABoxMeasurer.getOutputType());
            }
        };
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        return new DisplayGeom(this.getGeom(), s_primProps);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getBoxGeom());
    }

    public AABoxGeom getBoxGeom() {
        return new BlockGeom(this.d_box.getMin(Geometry.LU), this.d_box.getMax(Geometry.LU), 0);
    }

    @Override
    public void setGeom(IGeomNode iGeomNode) {
        this.setGeom(iGeomNode.flatten().getLocalGeom());
    }

    public void setGeom(IGeom iGeom) {
        if (iGeom instanceof AABoxGeom) {
            AABoxGeom aABoxGeom = (AABoxGeom)iGeom;
            this.setBox(new UnitAABox(aABoxGeom.min, aABoxGeom.max, Geometry.LU));
        }
    }
}

