/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.hvac;

import java.util.Arrays;
import javax.vecmath.Point3d;
import pyrosim.domain.devices.hvac.HvacDevice;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.theUtil;

public class NodeDevice
extends HvacDevice {
    static final long serialVersionUID = 1L;

    public NodeDevice(String string, IQuantity iQuantity) {
        super(string, iQuantity);
    }

    @Override
    public IGeom getDevcGeom() {
        ObjectQuantity objectQuantity = (ObjectQuantity)this.getQuantity();
        IFilteredCollection<HvacNode> iFilteredCollection = theUtil.filter(Arrays.asList(objectQuantity.objects), HvacNode.class);
        if (iFilteredCollection.isEmpty()) {
            return EmptyGeom.INSTANCE;
        }
        if (objectQuantity.get() == Quantity.HVAC_NODE_PRESSURE_DIFFERENCE) {
            assert (iFilteredCollection.size() == 2);
        } else {
            HvacNode hvacNode = (HvacNode)iFilteredCollection.iterator().next();
            Point3d point3d = NodeDevice.getPointForNode(hvacNode);
            if (point3d != null) {
                return new Point(point3d);
            }
            System.err.printf("[x] Unable to find location for NodeDevice (%s)%n", hvacNode.getName());
        }
        return EmptyGeom.INSTANCE;
    }
}

