/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.hvac;

import java.util.Collection;
import java.util.Set;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.devices.ADevice;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.QuantityReplacer;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.tasks.AReplaceRefTask;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public abstract class HvacDevice
extends ADevice
implements IDirectDependent {
    static final long serialVersionUID = 1L;
    private IQuantity d_msr;

    public HvacDevice(String string, IQuantity iQuantity) {
        super(string);
        this.d_msr = iQuantity;
    }

    public IQuantity getQuantity() {
        return this.d_msr;
    }

    public void setQuantity(IQuantity iQuantity) {
        this.d_msr = iQuantity;
    }

    @Override
    public void setGeom(IGeomNode iGeomNode) {
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getDevcGeom());
    }

    protected abstract IGeom getDevcGeom();

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        return DisplayGeom.EMPTY;
    }

    public static Point3d getPointForNode(HvacNode hvacNode) {
        if (hvacNode != null && hvacNode.getProp("XYZ") != null) {
            return ((UnitPoint3D)hvacNode.getProp("XYZ")).getPoint3dValue(SI.METER);
        }
        return null;
    }

    public static boolean isValidQuantity(IQuantity iQuantity) {
        if (!(iQuantity instanceof ObjectQuantity)) {
            return false;
        }
        ObjectQuantity objectQuantity = (ObjectQuantity)iQuantity;
        for (Object t : objectQuantity.objects) {
            if (!(t instanceof HvacDuct) && !(t instanceof HvacNode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        assert (this.d_msr != null);
        QuantityUtil.takeDepSnapshot(depList, DLink.STRONG, this.d_msr);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        QuantReplacer quantReplacer = new QuantReplacer();
        quantReplacer.removeInvalidReplacements(t, set, this.d_msr);
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        QuantReplacer quantReplacer = new QuantReplacer();
        return quantReplacer.taskReplaceDep(iPyroObject, iPyroObject2, this.d_msr);
    }

    @Override
    public Task taskUpdateDep(IPyroObject iPyroObject, Collection<Object> collection) {
        return EmptyTask.INSTANCE;
    }

    private class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)HvacDevice.this.getDomain());
        }

        @Override
        protected Task taskReplaceQuant(IQuantity iQuantity, IQuantity iQuantity2) {
            assert (iQuantity2 != null);
            return new AReplaceRefTask<IQuantity>((Object)iQuantity, (Object)iQuantity2){

                @Override
                protected void set(IQuantity iQuantity) {
                    HvacDevice.this.d_msr = iQuantity;
                    HvacDevice.this.changedEvt(new Object[0]);
                }
            };
        }
    }
}

