/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.hvac;

import java.util.Arrays;
import java.util.List;
import javax.vecmath.Point3d;
import pyrosim.domain.devices.hvac.HvacDevice;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.theUtil;

public class DuctDevice
extends HvacDevice {
    static final long serialVersionUID = 1L;

    public DuctDevice(String string, IQuantity iQuantity) {
        super(string, iQuantity);
    }

    @Override
    public IGeom getDevcGeom() {
        ObjectQuantity objectQuantity = (ObjectQuantity)this.getQuantity();
        IFilteredCollection<HvacDuct> iFilteredCollection = theUtil.filter(Arrays.asList(objectQuantity.objects), HvacDuct.class);
        if (iFilteredCollection.isEmpty()) {
            return EmptyGeom.INSTANCE;
        }
        HvacDuct hvacDuct = (HvacDuct)iFilteredCollection.iterator().next();
        List list = (List)hvacDuct.getProp("NODE_ID");
        if (list == null || list.isEmpty() || list.get(0) == null) {
            System.err.printf("[x] Unable to find location for DUCT (%s)%n", hvacDuct.getName());
            return EmptyGeom.INSTANCE;
        }
        if (list.size() < 2) {
            Point3d point3d = DuctDevice.getPointForNode((HvacNode)list.get(0));
            if (point3d != null) {
                return new Point(point3d);
            }
            System.err.printf("[xx] Unable to find location for DUCT (%s)%n", hvacDuct.getName());
        } else {
            Point3d point3d = DuctDevice.getPointForNode((HvacNode)list.get(0));
            Point3d point3d2 = DuctDevice.getPointForNode((HvacNode)list.get(1));
            if (point3d != null && point3d2 != null) {
                Point3d point3d3 = Util3D.getMidPoint(point3d, point3d2);
                return new Point(point3d3);
            }
            System.err.printf("[xxx] Unable to find location for DUCT (%s)%n", hvacDuct.getName());
        }
        return EmptyGeom.INSTANCE;
    }
}

