/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.detectors;

import java.io.IOException;
import java.io.ObjectInputStream;
import pyrosim.Intl;
import pyrosim.domain.devices.ADevice;
import pyrosim.domain.devices.AlarmInfo;
import pyrosim.domain.devices.TripFlags;
import pyrosim.domain.devices.detectors.IDetector;
import pyrosim.domain.signals.DoubleOutPin;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.ILatchable;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.LogicOutPin;
import pyrosim.domain.signals.OneLogicInPin;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.units.UnitDouble;

public class Timer
extends ADevice
implements IDetector,
ILatchable,
Cloneable {
    static final long serialVersionUID = 1L;
    private LogicOutPin d_alarmPin = new LogicOutPin(this);
    private IDoubleOutPin d_quantPin;
    private final AlarmInfo d_alarmInfo;
    private OneLogicInPin d_freezePin;

    public Timer(UnitDouble unitDouble, boolean bl) {
        this(Intl.intl("TIMER"), unitDouble, bl);
    }

    public Timer(String string, UnitDouble unitDouble, boolean bl) {
        super(string);
        this.d_alarmInfo = new AlarmInfo(unitDouble, TripFlags.toFlags(true, bl));
        this.d_quantPin = this.createQuantPin();
        this.d_freezePin = this.createFreezePin();
    }

    protected IDoubleOutPin createQuantPin() {
        return new DoubleOutPin(this, Intl.intl("TIME"), 2);
    }

    protected OneLogicInPin createFreezePin() {
        return new OneLogicInPin(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_quantPin == null) {
            this.d_quantPin = this.createQuantPin();
        }
        if (this.d_freezePin == null) {
            this.d_freezePin = this.createFreezePin();
        }
    }

    public int hashCode() {
        return 50330243 + this.getName().hashCode() + this.d_alarmInfo.hashCode() + this.d_freezePin.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Timer)) {
            return false;
        }
        Timer timer = (Timer)object;
        return super.equals(object) && this.d_alarmInfo.equals(timer.d_alarmInfo) && this.d_freezePin.equals(timer.d_freezePin);
    }

    @Override
    public Object clone() {
        Timer timer = (Timer)super.clone();
        timer.d_alarmPin = (LogicOutPin)this.d_alarmPin.clone(timer);
        timer.d_quantPin = (IDoubleOutPin)this.d_quantPin.clone(timer);
        timer.d_freezePin = (OneLogicInPin)this.d_freezePin.clone(timer);
        return timer;
    }

    public AlarmInfo getAlarmInfo() {
        return this.d_alarmInfo;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        return DisplayGeom.EMPTY;
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.EMPTY_NODE;
    }

    @Override
    public void setGeom(IGeomNode iGeomNode) {
    }

    @Override
    public OneLogicInPin getFreezePin() {
        return this.d_freezePin;
    }

    @Override
    public ILogicOutPin getAlarmPin() {
        return this.d_alarmPin;
    }

    @Override
    public IDoubleOutPin getQuantityPin() {
        return this.d_quantPin;
    }

    @Override
    public int getTripFlags() {
        return this.d_alarmInfo.tripFlags;
    }

    @Override
    public void setTripFlags(int n) {
    }

    @Override
    public boolean latches(ILogicOutPin iLogicOutPin) {
        return TripFlags.latch(this.d_alarmInfo.tripFlags);
    }
}

