/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.detectors;

import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.devices.detectors.APointDetector;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.util.Util;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public class SprinklerLink
extends APointDetector
implements IDirectDependent,
Serializable {
    static final long serialVersionUID = 1L;
    private SprinklerLinkModel d_linkDesc;
    private static final IPrimProps s_primProps = new IPrimProps.Vertex(Color.GREEN, 10.0);

    public SprinklerLink(String string, SprinklerLinkModel sprinklerLinkModel, FreePointLoc freePointLoc) {
        super(string, freePointLoc);
        this.d_linkDesc = sprinklerLinkModel;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof SprinklerLink && super.equals(object) && this.d_linkDesc.equals(((SprinklerLink)object).d_linkDesc);
    }

    @Override
    protected IQuantity getQuantity() {
        return Quantity.SPRINKLER_LINK_TEMPERATURE.create();
    }

    public SprinklerLinkModel getModel() {
        return this.d_linkDesc;
    }

    public void setModel(SprinklerLinkModel sprinklerLinkModel) {
        this.d_linkDesc = sprinklerLinkModel;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        assert (this.d_linkDesc != null) : "A sprinkler link must have a link description";
        depList.add(DLink.STRONG, (IPyroObject)this.d_linkDesc);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        Util.keepIfNullOr(set, SprinklerLinkModel.class);
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (iPyroObject == this.getModel()) {
            assert (iPyroObject2 != null);
            return new AReplaceRefTask<SprinklerLinkModel>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                public void set(SprinklerLinkModel sprinklerLinkModel) {
                    SprinklerLink.this.setModel(sprinklerLinkModel);
                }
            };
        }
        return null;
    }

    @Override
    public Task taskUpdateDep(IPyroObject iPyroObject, Collection<Object> collection) {
        return EmptyTask.INSTANCE;
    }

    @Override
    protected IPrimProps getPrimProps() {
        return s_primProps;
    }
}

