/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.detectors;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.jscience.physics.units.SI;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.devices.IDeviceModel;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class SmokeLinkModel
extends NamedPyroObject
implements IDeviceModel,
IDirectDependent {
    static final long serialVersionUID = 1L;
    private String d_fyi;
    private UnitDouble d_actObsc;
    private ExSpec d_smokeSpecies;
    private ISpec d_spec;
    private CustomFDSProps d_customProps;

    public SmokeLinkModel(String string) {
        this(string, SIUS.newud(3.28, 31), null, new Cleary());
    }

    public SmokeLinkModel(String string, UnitDouble unitDouble, ExSpec exSpec, ISpec iSpec) {
        super(string);
        this.d_actObsc = unitDouble;
        this.d_smokeSpecies = exSpec;
        this.d_spec = iSpec;
        this.d_customProps = CustomFDSProps.EMPTY;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_customProps == null) {
            this.d_customProps = CustomFDSProps.EMPTY;
        }
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String string) {
        return this.d_customProps;
    }

    @Override
    public void setCustomFDSProps(String string, CustomFDSProps customFDSProps) {
        this.d_customProps = customFDSProps;
        this.changedEvt(new Object[0]);
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String string) {
        this.d_fyi = string;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return super.equals(object) && this.propEquals(object);
    }

    public boolean propEquals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SmokeLinkModel)) {
            return false;
        }
        SmokeLinkModel smokeLinkModel = (SmokeLinkModel)object;
        return this.d_actObsc.equals(smokeLinkModel.d_actObsc) && theUtil.equal(this.d_smokeSpecies, smokeLinkModel.d_smokeSpecies) && this.d_spec.equals(smokeLinkModel.d_spec) && this.d_customProps.equals(smokeLinkModel.d_customProps);
    }

    public int propHash() {
        return this.d_actObsc.hashCode() + theUtil.hashCode(this.d_smokeSpecies) + this.d_spec.hashCode() + this.d_customProps.hashCode();
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        depList.add(DLink.WEAK, (IPyroObject)this.d_smokeSpecies);
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (iPyroObject instanceof ExSpec) {
            return new AReplaceRefTask<ExSpec>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                protected void set(ExSpec exSpec) {
                    SmokeLinkModel.this.setSmokeSpecies(exSpec);
                }
            };
        }
        return null;
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t instanceof ExSpec) {
            Util.keepIfNullOr(set, ExSpec.class);
        }
    }

    @Override
    public Task taskUpdateDep(IPyroObject iPyroObject, Collection<Object> collection) {
        return EmptyTask.INSTANCE;
    }

    public UnitDouble getActivationObscuration() {
        return this.d_actObsc;
    }

    public void setActivationObscuration(UnitDouble unitDouble) {
        this.d_actObsc = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public ExSpec getSmokeSpecies() {
        return this.d_smokeSpecies;
    }

    public void setSmokeSpecies(ExSpec exSpec) {
        this.d_smokeSpecies = exSpec;
        this.changedEvt(new Object[0]);
    }

    public ISpec getSpec() {
        return this.d_spec;
    }

    public void setSpec(ISpec iSpec) {
        this.d_spec = iSpec;
        this.changedEvt(new Object[0]);
    }

    public static class Cleary
    implements ISpec {
        static final long serialVersionUID = 1L;
        public final double d_cAlpha;
        public final double d_cBeta;
        public final double d_eAlpha;
        public final double d_eBeta;

        public Cleary() {
            this(1.8, 1.0, 0.0, 1.0);
        }

        public Cleary(double d, double d2, double d3, double d4) {
            this.d_cAlpha = d;
            this.d_cBeta = d2;
            this.d_eAlpha = d3;
            this.d_eBeta = d4;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Cleary)) {
                return false;
            }
            Cleary cleary = (Cleary)object;
            return this.d_cAlpha == cleary.d_cAlpha && this.d_cBeta == cleary.d_cBeta && this.d_eAlpha == cleary.d_eAlpha && this.d_eBeta == cleary.d_eBeta;
        }

        public int hashCode() {
            return theUtil.hashCode(this.d_cAlpha + this.d_cBeta + this.d_eAlpha + this.d_eBeta);
        }
    }

    public static class Heskestad
    implements ISpec {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_length;

        public Heskestad() {
            this(new UnitDouble(1.8, SI.METER));
        }

        public Heskestad(UnitDouble unitDouble) {
            this.d_length = unitDouble;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Heskestad)) {
                return false;
            }
            Heskestad heskestad = (Heskestad)object;
            return this.d_length.equals(heskestad.d_length);
        }

        public int hashCode() {
            return -2092433667 + this.d_length.hashCode();
        }
    }

    public static interface ISpec
    extends Serializable {
    }
}

