/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.detectors;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import pyrosim.Intl;
import pyrosim.domain.devices.APointSrcDevc;
import pyrosim.domain.devices.TripFlags;
import pyrosim.domain.devices.detectors.IDetector;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.signals.DoubleOutPin;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.ILatchable;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.LogicOutPin;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.io.PyroSimObjectInputStream;

public abstract class APointDetector
extends APointSrcDevc
implements IDetector,
Serializable,
ILatchable {
    static final long serialVersionUID = 1L;
    private LogicOutPin d_alarmPin = new LogicOutPin(this, Intl.intl("ALARM"));
    private int d_tripFlags = 1;
    private IDoubleOutPin d_quantPin = this.createQuantPin();
    private OneLogicInPin d_freezePin = this.createFreezePin();

    protected abstract IQuantity getQuantity();

    public APointDetector(String string, FreePointLoc freePointLoc) {
        super(string, freePointLoc);
    }

    protected IDoubleOutPin createQuantPin() {
        return new DoubleOutPin(this, Intl.intl("QUANTITY"), this.getQuantity().get().unitType);
    }

    protected OneLogicInPin createFreezePin() {
        return new OneLogicInPin(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (objectInputStream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)objectInputStream).getVersion() < 29) {
            this.d_tripFlags = 0;
        }
        if (this.d_quantPin == null) {
            this.d_quantPin = this.createQuantPin();
        }
        if (this.d_freezePin == null) {
            this.d_freezePin = this.createFreezePin();
        }
    }

    @Override
    public Object clone() {
        APointDetector aPointDetector = (APointDetector)super.clone();
        aPointDetector.d_alarmPin = (LogicOutPin)this.d_alarmPin.clone(aPointDetector);
        aPointDetector.d_quantPin = (IDoubleOutPin)this.d_quantPin.clone(aPointDetector);
        aPointDetector.d_freezePin = (OneLogicInPin)this.d_freezePin.clone(aPointDetector);
        return aPointDetector;
    }

    @Override
    public boolean equals(Object object) {
        return object == this || object instanceof APointDetector && super.equals(object) && ((APointDetector)object).d_tripFlags == this.d_tripFlags && ((APointDetector)object).d_freezePin.equals(this.d_freezePin);
    }

    @Override
    public boolean latches(ILogicOutPin iLogicOutPin) {
        return TripFlags.latch(this.d_tripFlags);
    }

    @Override
    public ILogicOutPin getAlarmPin() {
        return this.d_alarmPin;
    }

    @Override
    public IDoubleOutPin getQuantityPin() {
        return this.d_quantPin;
    }

    @Override
    public OneLogicInPin getFreezePin() {
        return this.d_freezePin;
    }

    @Override
    public void setTripFlags(int n) {
        this.d_tripFlags = n;
        this.changedEvt(new Object[0]);
    }

    @Override
    public int getTripFlags() {
        return this.d_tripFlags;
    }
}

