/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.domain.geom.FreePointLoc;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;

public class FreePointGeom
implements IGeom,
IManipulatable {
    private static final long serialVersionUID = 8277755820854432148L;
    public final FreePointLoc loc;

    public FreePointGeom(FreePointLoc freePointLoc) {
        this.loc = freePointLoc;
    }

    @Override
    public FreePointGeom optimize(IPointOptimizer iPointOptimizer) {
        return this;
    }

    @Override
    public IGeom transform(TransformInfo transformInfo, int n) {
        if (transformInfo.isIdentity()) {
            return this;
        }
        FreePointLoc freePointLoc = this.loc.transform(transformInfo.getMatrix());
        return new FreePointGeom(freePointLoc);
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        return this.loc.d_geom.getBoundingBox(aABox);
    }

    @Override
    public boolean getBakeTransform() {
        return true;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public boolean isAxisAlignedBlock(TransformInfo transformInfo) {
        return false;
    }

    @Override
    public boolean isShell() {
        return true;
    }

    @Override
    public int getNumPrims(int n) {
        if ((n & 4) == 4) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean canExplode() {
        return true;
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> collection) {
        collection.add(this.getGeom());
        return collection;
    }

    private IGeom getGeom() {
        return this.loc.d_geom;
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        this.getGeom().pickPoints(iIsectCollector, iIsectFilter, object, point3d, point3d2, vector3d, iTest);
    }

    @Override
    public void pickBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull, IBoxCollector iBoxCollector) throws CancelledException {
        this.getGeom().pickBox(object, iIsectFilter, convexHull, iBoxCollector);
    }

    @Override
    public void find(ITest<AABox> iTest, IResult<? super IPrimitive> iResult) {
        this.getGeom().find(iTest, iResult);
    }

    @Override
    public void getAll(IResult<? super IPrimitive> iResult) {
        this.getGeom().getAll(iResult);
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        IGeom iGeom = this.getGeom();
        if (iGeom instanceof IManipulatable) {
            Collection<? extends IHandle> collection = ((IManipulatable)((Object)iGeom)).generateManipHandles();
            return collection.stream().map(iHandle -> new Handle(this, (IHandle)iHandle)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static class Handle
    implements IHandle {
        private FreePointGeom d_geom;
        private IHandle d_geomHandle;

        public Handle(FreePointGeom freePointGeom, IHandle iHandle) {
            this.d_geom = freePointGeom;
            this.d_geomHandle = iHandle;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Handle)) {
                return false;
            }
            Handle handle = (Handle)object;
            return this.d_geomHandle.equals(handle.d_geomHandle);
        }

        @Override
        public IGeomNode getGeom() {
            return this.d_geomHandle.getGeom();
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return this.d_geomHandle.getPickFilter();
        }

        @Override
        public ISnapConstraint getConstraint(Point3d point3d) {
            return this.d_geomHandle.getConstraint(point3d);
        }

        @Override
        public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
            this.d_geomHandle.begin(point3d, iSnapConstraint);
        }

        @Override
        public Object modify(Point3d point3d) throws ManipException {
            Object object = this.d_geomHandle.modify(point3d);
            if (object instanceof IGeom) {
                FreePointLoc freePointLoc = new FreePointLoc((IGeom)object, this.d_geom.loc.d_orientation, this.d_geom.loc.d_rotation);
                this.d_geom = new FreePointGeom(freePointLoc);
            }
            return this.d_geom;
        }

        @Override
        public Object end() {
            Object object = this.d_geomHandle.end();
            if (object instanceof IGeom) {
                FreePointLoc freePointLoc = new FreePointLoc((IGeom)object, this.d_geom.loc.d_orientation, this.d_geom.loc.d_rotation);
                this.d_geom = new FreePointGeom(freePointLoc);
            }
            return this.d_geom;
        }
    }
}

