/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices;

import java.util.Arrays;
import java.util.Collection;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;

public class AttachedPointGeom
implements IGeom,
IManipulatable {
    private static final long serialVersionUID = -6537792298278955828L;
    public final AttachedPointLoc loc;

    public AttachedPointGeom(AttachedPointLoc attachedPointLoc) {
        this.loc = attachedPointLoc;
    }

    @Override
    public AttachedPointGeom optimize(IPointOptimizer iPointOptimizer) {
        return this;
    }

    @Override
    public IGeom transform(TransformInfo transformInfo, int n) {
        if (transformInfo.isIdentity()) {
            return this;
        }
        AttachedPointLoc attachedPointLoc = this.loc.transform(transformInfo.getMatrix());
        return new AttachedPointGeom(attachedPointLoc);
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        aABox.add(this.loc.d_location.getPoint3dValue(Geometry.LU));
        return aABox;
    }

    @Override
    public boolean getBakeTransform() {
        return true;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IDOF getRetainingDOF() {
        return IDOF.FREE;
    }

    @Override
    public boolean isAxisAlignedBlock(TransformInfo transformInfo) {
        return false;
    }

    @Override
    public boolean isShell() {
        return true;
    }

    @Override
    public int getNumPrims(int n) {
        if ((n & 4) == 4) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean canExplode() {
        return true;
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> collection) {
        collection.add(this.getPoint());
        return collection;
    }

    private Point getPoint() {
        return new Point(this.loc.d_location.getPoint3dValue(Geometry.LU));
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        this.getPoint().pickPoints(iIsectCollector, iIsectFilter, object, point3d, point3d2, vector3d, iTest);
    }

    @Override
    public void pickBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull, IBoxCollector iBoxCollector) throws CancelledException {
        this.getPoint().pickBox(object, iIsectFilter, convexHull, iBoxCollector);
    }

    @Override
    public void find(ITest<AABox> iTest, IResult<? super IPrimitive> iResult) {
        this.getPoint().find(iTest, iResult);
    }

    @Override
    public void getAll(IResult<? super IPrimitive> iResult) {
        this.getPoint().getAll(iResult);
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        return Arrays.asList(new Handle(this));
    }

    private static class Handle
    implements IHandle {
        private AttachedPointGeom d_geom;

        public Handle(AttachedPointGeom attachedPointGeom) {
            this.d_geom = attachedPointGeom;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof Handle;
        }

        @Override
        public IGeomNode getGeom() {
            return GeomNodeUtil.newNode(new Point(this.d_geom.loc.d_location.getPoint3dValue(Geometry.LU)));
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d point3d) {
            return null;
        }

        @Override
        public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
        }

        @Override
        public Object modify(Point3d point3d) throws ManipException {
            AttachedPointLoc attachedPointLoc = new AttachedPointLoc(new UnitPoint3D(point3d, Geometry.LU), this.d_geom.loc.d_faceNormal, this.d_geom.loc.d_rotation);
            this.d_geom = new AttachedPointGeom(attachedPointLoc);
            return this.d_geom;
        }

        @Override
        public Object end() {
            return this.d_geom;
        }
    }
}

