/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.dependencies;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import pyrosim.domain.CompTestMod;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.geom.Obstruction;
import pyrosim.domain.particle.ParticleList;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.domain.tasks.SetNameTask;
import pyrosim.domain.tasks.Tasks;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.Task;

public class PyroDependencyTest
extends CompTestMod.ATest {
    private static final String HEAT_RENAMED1 = "HEAT renamed1";
    private static final String PART_RENAMED1 = "PART renamed1";
    private static final String PART_RENAMED2 = "PART renamed2";
    private static final String REAC_RENAMED1 = "REAC renamed1";
    private static final String MAT_RENAMED1 = "MAT renamed1";

    private <T extends IPyroObject> Task replace(List<T> list, List<T> list2) {
        CompositeTask<CompTestMod> compositeTask = new CompositeTask<CompTestMod>(this.getMod());
        DepSnapshot depSnapshot = this.getMod().getDependencies(new IPyroObject[0]);
        for (int i = 0; i < list.size(); ++i) {
            IPyroObject iPyroObject = (IPyroObject)list.get(i);
            IPyroObject iPyroObject2 = (IPyroObject)list2.get(i);
            for (Dependency dependency : depSnapshot.getDependents(iPyroObject)) {
                assert (iPyroObject2 != null || dependency.link == DLink.WEAK);
                compositeTask.addTask(dependency.source.taskReplaceDep(iPyroObject, iPyroObject2));
            }
        }
        compositeTask.addTask(Tasks.delete(list));
        return compositeTask;
    }

    public void testRemovePartRecords() {
        ParticleList particleList = this.getMod().getPartList();
        Vector vector = new Vector();
        vector.add(particleList.get("PART #3"));
        vector.add(particleList.get("PART #4"));
        Vector vector2 = new Vector();
        vector2.add(particleList.get("PART #2"));
        vector2.add(particleList.get("PART #1"));
        Task task = this.replace(vector, vector2);
        this.getMod().getTaskManager().exec(task, null);
        this.checkRemovedPartRecords();
        this.getMod().getTaskManager().undo();
        this.assertIsInOriginalState();
        this.getMod().getTaskManager().redo();
        this.checkRemovedPartRecords();
    }

    private void checkRemovedPartRecords() {
        ParticleList particleList = this.getMod().getPartList();
        SurfaceManager surfaceManager = this.getMod().getSurfaceMgr();
        PyroDependencyTest.assertNull(particleList.get("PART #3"));
        PyroDependencyTest.assertNull(particleList.get("PART #4"));
        PyroDependencyTest.assertTrue((boolean)((LayeredSurfDesc)((Surface)surfaceManager.get((String)"MAT #4")).getSurfDesc()).d_partInj.getParticle().equals(particleList.get("PART #1")));
        PyroDependencyTest.assertTrue((boolean)((LayeredSurfDesc)((Surface)surfaceManager.get((String)"MAT #2")).getSurfDesc()).d_partInj.getParticle().equals(particleList.get("PART #2")));
        PyroDependencyTest.assertTrue((boolean)((LayeredSurfDesc)((Surface)surfaceManager.get((String)"MAT #3")).getSurfDesc()).d_partInj.getParticle().equals(particleList.get("PART #2")));
    }

    public void testRemoveReactions() {
        ReactionList reactionList = this.getMod().getReactions();
        Vector vector = new Vector();
        vector.add(reactionList.get("REAC #2"));
        vector.add(reactionList.get("REAC #3"));
        Vector vector2 = new Vector();
        vector2.add(reactionList.get("REAC #1"));
        vector2.add(null);
        Task task = this.replace(vector, vector2);
        this.getMod().getTaskManager().exec(task, null);
        this.checkRemovedReactions();
        this.getMod().getTaskManager().undo();
        this.assertIsInOriginalState();
        this.getMod().getTaskManager().redo();
        this.checkRemovedReactions();
    }

    private void checkRemovedReactions() {
        ReactionList reactionList = this.getMod().getReactions();
        PyroDependencyTest.assertNull(reactionList.get("REAC #2"));
    }

    public void testRemoveMaterials() {
        SurfaceManager surfaceManager = this.getMod().getSurfaceMgr();
        Vector vector = new Vector();
        vector.add(surfaceManager.get("MAT #1"));
        vector.add(surfaceManager.get("MAT #4"));
        vector.add(surfaceManager.get("MAT #3"));
        Vector vector2 = new Vector();
        vector2.add(surfaceManager.get("MAT #2"));
        vector2.add(null);
        vector2.add(surfaceManager.get("MAT #5"));
        Task task = this.replace(vector, vector2);
        this.getMod().getTaskManager().exec(task, null);
        this.checkRemovedMaterials();
        this.getMod().getTaskManager().undo();
        this.assertIsInOriginalState();
        this.getMod().getTaskManager().redo();
        this.checkRemovedMaterials();
    }

    private void checkRemovedMaterials() {
        SurfaceManager surfaceManager = this.getMod().getSurfaceMgr();
        PyroDependencyTest.assertNull(surfaceManager.get("MAT #1"));
        PyroDependencyTest.assertNull(surfaceManager.get("MAT #3"));
        PyroDependencyTest.assertNull(surfaceManager.get("MAT #4"));
        PyroDependencyTest.assertTrue((boolean)this.getMod().d_wall1.getSurfaces()[0].equals(surfaceManager.get("MAT #2")));
        PyroDependencyTest.assertTrue((boolean)this.getMod().d_ab1.getSurfaces()[0].equals(surfaceManager.get("MAT #2")));
        PyroDependencyTest.assertTrue((boolean)this.getMod().d_ab1.getSurfaces()[1].equals(surfaceManager.get("MAT #2")));
        PyroDependencyTest.assertTrue((boolean)this.getMod().d_ab1.getSurfaces()[2].equals(surfaceManager.get("MAT #5")));
        PyroDependencyTest.assertTrue((boolean)this.getMod().d_vent1.getSurface().equals(surfaceManager.get("MAT #5")));
    }

    public void testRenamePartRecords() {
        ParticleList particleList = this.getMod().getPartList();
        SetNameTask setNameTask = new SetNameTask((INamed)particleList.get("PART #3"), PART_RENAMED1);
        this.getMod().getTaskManager().exec(setNameTask, null);
        SetNameTask setNameTask2 = new SetNameTask((INamed)particleList.get("PART #4"), PART_RENAMED2);
        this.getMod().getTaskManager().exec(setNameTask2, null);
        this.checkRenamedPartRecords();
        this.getMod().getTaskManager().undo();
        this.getMod().getTaskManager().undo();
        this.assertIsInOriginalState();
        this.getMod().getTaskManager().redo();
        this.getMod().getTaskManager().redo();
        this.checkRenamedPartRecords();
    }

    private void checkRenamedPartRecords() {
        ParticleList particleList = this.getMod().getPartList();
        SurfaceManager surfaceManager = this.getMod().getSurfaceMgr();
        PyroDependencyTest.assertNull(particleList.get("PART #3"));
        PyroDependencyTest.assertNotNull(particleList.get(PART_RENAMED1));
        PyroDependencyTest.assertNull(particleList.get("PART #4"));
        PyroDependencyTest.assertNotNull(particleList.get(PART_RENAMED2));
        PyroDependencyTest.assertTrue((boolean)((LayeredSurfDesc)((Surface)surfaceManager.get((String)"MAT #4")).getSurfDesc()).d_partInj.getParticle().equals(particleList.get(PART_RENAMED2)));
        PyroDependencyTest.assertTrue((boolean)((LayeredSurfDesc)((Surface)surfaceManager.get((String)"MAT #3")).getSurfDesc()).d_partInj.getParticle().equals(particleList.get(PART_RENAMED1)));
    }

    public void testRenameReactions() {
        ReactionList reactionList = this.getMod().getReactions();
        SetNameTask setNameTask = new SetNameTask((INamed)reactionList.get("REAC #2"), REAC_RENAMED1);
        this.getMod().getTaskManager().exec(setNameTask, null);
        this.checkRenamedReactions();
        this.getMod().getTaskManager().undo();
        this.assertIsInOriginalState();
        this.getMod().getTaskManager().redo();
        this.checkRenamedReactions();
    }

    private void checkRenamedReactions() {
        ReactionList reactionList = this.getMod().getReactions();
        PyroDependencyTest.assertNull(reactionList.get("REAC #2"));
        PyroDependencyTest.assertNotNull(reactionList.get(REAC_RENAMED1));
    }

    public void testRenameMats() {
        SurfaceManager surfaceManager = this.getMod().getSurfaceMgr();
        SetNameTask setNameTask = new SetNameTask((INamed)surfaceManager.get("MAT #3"), MAT_RENAMED1);
        this.getMod().getTaskManager().exec(setNameTask, null);
        this.checkRenamedMats();
        this.getMod().getTaskManager().undo();
        this.assertIsInOriginalState();
        this.getMod().getTaskManager().redo();
        this.checkRenamedMats();
    }

    private void checkRenamedMats() {
        SurfaceManager surfaceManager = this.getMod().getSurfaceMgr();
        PyroDependencyTest.assertNull(surfaceManager.get("MAT #3"));
        PyroDependencyTest.assertNotNull(surfaceManager.get(MAT_RENAMED1));
        PyroDependencyTest.assertTrue((boolean)this.getMod().d_ab1.getSurfaces()[2].equals(surfaceManager.get(MAT_RENAMED1)));
        PyroDependencyTest.assertTrue((boolean)this.getMod().d_vent1.getSurface().equals(surfaceManager.get(MAT_RENAMED1)));
    }

    private void checkClonedDependencyUpdates(Map<Object, Object> map) {
        SurfaceManager surfaceManager = this.getMod().getSurfaceMgr();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object object = entry.getKey();
            Object object2 = entry.getValue();
            if (object == this.getMod().d_ab1) {
                Obstruction obstruction = (Obstruction)object;
                Obstruction obstruction2 = (Obstruction)object2;
                PyroDependencyTest.assertNotSame((Object)obstruction, (Object)obstruction2);
                System.out.println("testing ab " + obstruction.getSurfaces()[0] + " " + obstruction2.getSurfaces()[0]);
                System.out.println("testing ab " + obstruction.getSurfaces()[1] + " " + obstruction2.getSurfaces()[1]);
                System.out.println("testing ab " + obstruction.getSurfaces()[2] + " " + obstruction2.getSurfaces()[2]);
                PyroDependencyTest.assertNotSame((Object)obstruction.getSurfaces()[0], (Object)obstruction2.getSurfaces()[0]);
                PyroDependencyTest.assertSame((Object)obstruction.getSurfaces()[0], surfaceManager.get("MAT #2"));
                PyroDependencyTest.assertSame((Object)obstruction2.getSurfaces()[0], (Object)map.get(surfaceManager.get("MAT #2")));
                PyroDependencyTest.assertNotSame((Object)obstruction.getSurfaces()[1], (Object)obstruction2.getSurfaces()[1]);
                PyroDependencyTest.assertSame((Object)obstruction.getSurfaces()[1], surfaceManager.get("MAT #1"));
                PyroDependencyTest.assertSame((Object)obstruction2.getSurfaces()[1], (Object)map.get(surfaceManager.get("MAT #1")));
                PyroDependencyTest.assertNotSame((Object)obstruction.getSurfaces()[2], (Object)obstruction2.getSurfaces()[2]);
                PyroDependencyTest.assertSame((Object)obstruction.getSurfaces()[2], surfaceManager.get("MAT #3"));
                PyroDependencyTest.assertSame((Object)obstruction2.getSurfaces()[2], (Object)map.get(surfaceManager.get("MAT #3")));
                continue;
            }
            if (!object.equals(this.getMod().d_vent1) && !object.equals(this.getMod().d_wall1) && !object.equals(this.getMod().d_hole1) && !object.equals(surfaceManager.get("MAT #1")) && !object.equals(surfaceManager.get("MAT #2")) && !object.equals(surfaceManager.get("MAT #3")) && !object.equals(surfaceManager.get("MAT #4")) && !object.equals(surfaceManager.get("MAT #5"))) continue;
        }
    }
}

