/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.dependencies;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.Serialized;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.dependencies.SkipDep;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Sets;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;

public class DepSnapshot {
    private final Map<Object, Set<IParentEntry>> d_map;
    private final Set<?> d_interestingDepOns;
    private Map<Class, List<Field>> d_fieldCache = new HashMap<Class, List<Field>>();
    private static final Predicate<Field> s_fieldFilter = field -> !Modifier.isStatic(field.getModifiers()) && !DepSnapshot.isSkippable(field.getType()) && !field.isAnnotationPresent(SkipDep.class);
    private static final Function<Class, List<Field>> s_fieldFunc = clazz -> new ArrayList<Field>(theUtil.filter(Arrays.asList(clazz.getDeclaredFields()), s_fieldFilter));
    private static final Set<? extends Class> s_skipClazzes = Sets.fromArrayHS(String.class, Boolean.class, Boolean.TYPE, Character.class, Character.TYPE, Byte.class, Byte.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, PyroSim.class);

    public DepSnapshot() {
        this(Collections.EMPTY_LIST);
    }

    public DepSnapshot(Collection<?> collection) {
        this.d_map = new LinkedIdentityHashMap<Object, Set<IParentEntry>>();
        this.d_interestingDepOns = collection instanceof Set ? (Set<Object>)collection : (collection.isEmpty() ? Collections.EMPTY_SET : new IdentityHashSet(collection));
    }

    public void start(PyroMod pyroMod, Serialized serialized) {
        theTimer theTimer2 = new theTimer();
        this.add(pyroMod, serialized, DLink.WEAK);
        System.out.println("DepSnapshot: " + theTimer2.curr());
    }

    private boolean add(Object object, Object object2, DLink dLink) {
        if (object2 == null) {
            return false;
        }
        assert (object != null);
        boolean bl = this.takeSnapshot(object2);
        if (bl) {
            Set<IParentEntry> set = this.d_map.get(object2);
            assert (set != null);
            if (object instanceof IDirectDependent) {
                DirectEntry directEntry = new DirectEntry(dLink, (IDirectDependent)object);
                if (dLink != DLink.WEAK) {
                    set.remove(directEntry);
                }
                set.add(directEntry);
            } else {
                set.add(new IndirectEntry(object));
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public boolean takeSnapshot(Object object) {
        Class<?> clazz;
        boolean bl;
        if (object instanceof PyroMod) {
            return false;
        }
        if (this.d_map.containsKey(object)) {
            Set<IParentEntry> set = this.d_map.get(object);
            return set != null;
        }
        this.d_map.put(object, new LinkedHashSet());
        boolean bl2 = bl = this.d_interestingDepOns.isEmpty() && object instanceof IPyroObject || this.d_interestingDepOns.contains(object);
        if (object instanceof IDirectDependent) {
            clazz = new DepList((IDirectDependent)object);
            ((IDirectDependent)object).takeDepSnapshot((DepList)((Object)clazz));
            for (Pair<DLink, IPyroObject> pair : ((DepList)((Object)clazz)).getLinks()) {
                bl |= this.add(object, pair.v2, (DLink)((Object)pair.v1));
            }
        }
        if (object instanceof Composite) {
            for (Object e : ((Composite)object).getMembers()) {
                bl |= this.takeSnapshot(e);
            }
        } else if (!(object instanceof IDirectDependent) && object instanceof Collection) {
            for (Object e : (Collection)object) {
                bl |= this.checkTypeAndAdd(object, e);
            }
        } else if (!(object instanceof IDirectDependent) && object instanceof Map) {
            clazz = ((Map)object).entrySet();
            Iterator iterator = clazz.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                bl |= this.checkTypeAndAdd(object, entry.getKey());
                bl |= this.checkTypeAndAdd(object, entry.getValue());
            }
        } else if (object.getClass().isArray()) {
            clazz = object.getClass().getComponentType();
            if (!DepSnapshot.isSkippable(clazz)) {
                void var5_19;
                int n = Array.getLength(object);
                boolean bl3 = false;
                while (var5_19 < n) {
                    bl |= this.checkTypeAndAdd(object, Array.get(object, (int)var5_19));
                    ++var5_19;
                }
            }
        } else {
            try {
                for (clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                    for (Field field : this.d_fieldCache.computeIfAbsent(clazz, s_fieldFunc)) {
                        boolean bl4 = field.isAccessible();
                        if (!bl4) {
                            field.setAccessible(true);
                        }
                        Object object2 = field.get(object);
                        if (!bl4) {
                            field.setAccessible(false);
                        }
                        if (object2 == null) continue;
                        bl |= this.checkTypeAndAdd(object, object2);
                    }
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                assert (false);
            }
        }
        if (!bl) {
            this.d_map.put(object, null);
        }
        return bl;
    }

    private boolean checkTypeAndAdd(Object object, Object object2) {
        if (DepSnapshot.isSkippable(object2)) {
            return false;
        }
        return this.add(object, object2, DLink.WEAK);
    }

    private static boolean isSkippable(Object object) {
        return object == null || DepSnapshot.isSkippable(object.getClass());
    }

    private static boolean isSkippable(Class clazz) {
        return s_skipClazzes.contains(clazz) || IGeom.class.isAssignableFrom(clazz) || IGeomNode.class.isAssignableFrom(clazz) || IElemSource.class.isAssignableFrom(clazz);
    }

    public <T> Set<T> findAllDependents(Class<T> clazz, Object object) {
        LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
        TypeFilter<Object> typeFilter = new TypeFilter<Object>(clazz);
        this.findAllDependents(typeFilter, object, linkedIdentityHashSet);
        return linkedIdentityHashSet;
    }

    public Set<Object> findAllDependents(Predicate<Object> predicate, Object object) {
        LinkedIdentityHashSet<Object> linkedIdentityHashSet = new LinkedIdentityHashSet<Object>();
        this.findAllDependents(predicate, object, linkedIdentityHashSet);
        return linkedIdentityHashSet;
    }

    public void findAllDependents(Predicate<Object> predicate, Object object, Set set) {
        LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        arrayDeque.addLast(object);
        linkedIdentityHashSet.add(object);
        while (!arrayDeque.isEmpty()) {
            Object e = arrayDeque.removeLast();
            Set<IParentEntry> set2 = this.d_map.get(e);
            if (set2 == null) continue;
            for (IParentEntry iParentEntry : set2) {
                Object object2 = iParentEntry.getSource();
                if (predicate.test(object2)) {
                    set.add(object2);
                    continue;
                }
                if (!linkedIdentityHashSet.add(object2)) continue;
                arrayDeque.addLast(object2);
            }
        }
    }

    public Set<IPyroObject> getAllDependedOn() {
        Predicate<IPyroObject> predicate = new Predicate<IPyroObject>(){

            @Override
            public boolean test(IPyroObject iPyroObject) {
                Set set = (Set)DepSnapshot.this.d_map.get(iPyroObject);
                return set != null && !set.isEmpty();
            }
        };
        return theUtil.filter(this.d_map.keySet(), IPyroObject.class, predicate);
    }

    public Set<Dependency> getDependents(IPyroObject iPyroObject) {
        Set<IParentEntry> set = this.d_map.get(iPyroObject);
        if (set == null || set.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Function<DirectEntry, Dependency> function = new Function<DirectEntry, Dependency>(){

            @Override
            public Dependency apply(DirectEntry directEntry) {
                return new Dependency(directEntry.link, directEntry.source);
            }
        };
        Function<Dependency, DirectEntry> function2 = new Function<Dependency, DirectEntry>(){

            @Override
            public DirectEntry apply(Dependency dependency) {
                return new DirectEntry(dependency.link, dependency.source);
            }
        };
        IFilteredCollection<DirectEntry> iFilteredCollection = theUtil.filter(set, DirectEntry.class);
        return theUtil.map(iFilteredCollection, function, function2, Dependency.class);
    }

    public <T> Set<T> getAncestors(Class<T> clazz, Object object) {
        LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        arrayDeque.push(object);
        while (!arrayDeque.isEmpty()) {
            Object e = arrayDeque.pop();
            Set<IParentEntry> set = this.d_map.get(e);
            if (set == null) continue;
            for (IParentEntry iParentEntry : set) {
                Object object2 = iParentEntry.getSource();
                if (clazz.isInstance(object2)) {
                    linkedIdentityHashSet.add(clazz.cast(object2));
                    continue;
                }
                arrayDeque.push(object2);
            }
        }
        return linkedIdentityHashSet;
    }

    public void removeMappings(Collection<?> collection) {
        this.d_map.keySet().removeAll(collection);
    }

    private static class DirectEntry
    implements IParentEntry {
        public final DLink link;
        public final IDirectDependent source;

        public DirectEntry(DLink dLink, IDirectDependent iDirectDependent) {
            this.source = iDirectDependent;
            this.link = dLink;
        }

        public int hashCode() {
            return -1826424077 + System.identityHashCode(this.source);
        }

        public boolean equals(Object object) {
            return object == this || object instanceof DirectEntry && this.source == ((DirectEntry)object).source;
        }

        @Override
        public Object getSource() {
            return this.source;
        }
    }

    private static class IndirectEntry
    implements IParentEntry {
        public final Object obj;

        public IndirectEntry(Object object) {
            this.obj = object;
        }

        public int hashCode() {
            return System.identityHashCode(this.obj);
        }

        public boolean equals(Object object) {
            return object == this || object == this.obj || object instanceof IndirectEntry && ((IndirectEntry)object).obj == this.obj;
        }

        @Override
        public Object getSource() {
            return this.obj;
        }
    }

    private static interface IParentEntry {
        public Object getSource();
    }
}

