/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.controls;

import java.util.ArrayList;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;

public class Util {
    public static boolean deleteWires(IInPin iInPin) {
        if (iInPin == null) {
            return false;
        }
        boolean bl = false;
        ArrayList<? extends IOutPin> arrayList = new ArrayList<IOutPin>(iInPin.getConnections());
        block0: for (IOutPin iOutPin : arrayList) {
            ISignalSink iSignalSink;
            if (iOutPin.getAttachedSource() instanceof ISignalSink) {
                iSignalSink = (ISignalSink)((Object)iOutPin.getAttachedSource());
                bl |= Util.deleteWires(iSignalSink.getInputPin());
            }
            if (!(iOutPin.getAttachedSource() instanceof IControl) || !(iSignalSink = (IControl)iOutPin.getAttachedSource()).isWire() || iSignalSink instanceof ControlBridge) continue;
            bl = true;
            iInPin.disconnect(iOutPin);
            for (IOutPin iOutPin2 : iSignalSink.getInputPin().getConnections()) {
                if (!iInPin.isCompatible(iOutPin2)) continue;
                iInPin.connect(iOutPin2);
                continue block0;
            }
        }
        return bl;
    }

    public static boolean isComplete(IOutPin iOutPin) {
        ISignalSource iSignalSource = iOutPin.getAttachedSource();
        return !(iSignalSource instanceof IControl) || ((IControl)iSignalSource).isComplete();
    }

    public static boolean isWire(IOutPin iOutPin) {
        ISignalSource iSignalSource = iOutPin.getAttachedSource();
        return iSignalSource instanceof IControl && ((IControl)iSignalSource).isWire();
    }

    public static int countNumCompleteInputs(IInPin iInPin) {
        int n = 0;
        for (IOutPin iOutPin : iInPin.getConnections()) {
            if (!Util.isComplete(iOutPin)) continue;
            ++n;
        }
        return n;
    }

    public static boolean inputLatches(IInPin iInPin) {
        for (IOutPin iOutPin : iInPin.getConnections()) {
            if (!(iOutPin instanceof ILogicOutPin)) continue;
            return ((ILogicOutPin)iOutPin).latches();
        }
        return false;
    }
}

